/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.annotation.processor.common;

import com.squareup.javapoet.TypeName;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.RecordComponentElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;

public class RecordUtils {
    public static ExecutableElement findCanonicalConstructor(TypeElement record) {
        assert (record.getKind() == ElementKind.RECORD);
        List<? extends RecordComponentElement> recordComponents = record.getRecordComponents();
        block0: for (Element element : record.getEnclosedElements()) {
            if (element.getKind() != ElementKind.CONSTRUCTOR || !(element instanceof ExecutableElement)) continue;
            ExecutableElement constructor = (ExecutableElement)element;
            if (recordComponents.size() != constructor.getParameters().size()) continue;
            for (int i = 0; i < recordComponents.size(); ++i) {
                TypeName constructorParamType;
                RecordComponentElement recordComponent = recordComponents.get(i);
                VariableElement constructorParam = constructor.getParameters().get(i);
                if (!recordComponent.getSimpleName().contentEquals(constructorParam.getSimpleName())) continue block0;
                TypeName recordComponentType = TypeName.get((TypeMirror)recordComponent.asType()).withoutAnnotations();
                if (!recordComponentType.equals((Object)(constructorParamType = TypeName.get((TypeMirror)constructorParam.asType()).withoutAnnotations()))) continue;
                return constructor;
            }
        }
        throw new IllegalStateException("Canonical record constructor not found!");
    }
}

