/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.annotation.processor.common;

import com.squareup.javapoet.ClassName;
import jakarta.annotation.Nullable;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

public final class TypeUtils {
    @Nullable
    public static DeclaredType findSupertype(@Nullable DeclaredType type, ClassName expectedSupertype) {
        DeclaredType declaredType;
        DeclaredType supertypeResult;
        if (type == null) {
            return null;
        }
        TypeElement typeElement = (TypeElement)type.asElement();
        if (typeElement.getQualifiedName().contentEquals(expectedSupertype.canonicalName())) {
            return type;
        }
        for (TypeMirror typeMirror : typeElement.getInterfaces()) {
            DeclaredType supertype = TypeUtils.findSupertype((DeclaredType)typeMirror, expectedSupertype);
            if (supertype == null) continue;
            return supertype;
        }
        TypeMirror supertype = typeElement.getSuperclass();
        if (supertype.getKind() == TypeKind.DECLARED && (supertypeResult = TypeUtils.findSupertype(declaredType = (DeclaredType)supertype, expectedSupertype)) != null) {
            return declaredType;
        }
        return null;
    }
}

