/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.aop.annotation.processor;

import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeSpec;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;
import ru.tinkoff.kora.annotation.processor.common.AbstractKoraProcessor;
import ru.tinkoff.kora.annotation.processor.common.LogUtils;
import ru.tinkoff.kora.annotation.processor.common.ProcessingError;
import ru.tinkoff.kora.annotation.processor.common.ProcessingErrorException;
import ru.tinkoff.kora.aop.annotation.processor.AopProcessor;
import ru.tinkoff.kora.aop.annotation.processor.AopUtils;
import ru.tinkoff.kora.aop.annotation.processor.KoraAspect;
import ru.tinkoff.kora.aop.annotation.processor.KoraAspectFactory;
import ru.tinkoff.kora.common.AopAnnotation;
import ru.tinkoff.kora.common.util.Either;

public class AopAnnotationProcessor
extends AbstractKoraProcessor {
    private static final Logger log = LoggerFactory.getLogger(AopAnnotationProcessor.class);
    private List<KoraAspect> aspects;
    private TypeElement[] annotations;
    private AopProcessor aopProcessor;

    public Set<String> getSupportedAnnotationTypes() {
        return this.aspects.stream().mapMulti((a, sink) -> a.getSupportedAnnotationTypes().forEach(sink)).collect(Collectors.toSet());
    }

    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        TypeElement aopAnnotation = processingEnv.getElementUtils().getTypeElement("ru.tinkoff.kora.common.AopAnnotation");
        if (aopAnnotation == null) {
            this.annotations = new TypeElement[0];
            this.aspects = List.of();
            return;
        }
        this.aspects = ServiceLoader.load(KoraAspectFactory.class, ((Object)((Object)this)).getClass().getClassLoader()).stream().map(ServiceLoader.Provider::get).mapMulti((factory, sink) -> factory.create(processingEnv).ifPresent((Consumer<KoraAspect>)sink)).toList();
        if (this.aspects.isEmpty()) {
            this.annotations = new TypeElement[0];
            return;
        }
        this.aopProcessor = new AopProcessor(this.types, this.elements, this.aspects);
        if (log.isDebugEnabled()) {
            String aspects = this.aspects.stream().map(Object::getClass).map(Class::getCanonicalName).collect(Collectors.joining("\n\t", "\t", "")).indent(4);
            log.debug("Discovered aspects:\n{}", (Object)aspects);
        }
        this.annotations = (TypeElement[])this.aspects.stream().mapMulti((a, sink) -> a.getSupportedAnnotationTypes().forEach(sink)).map(c -> this.elements.getTypeElement((CharSequence)c)).filter(Objects::nonNull).toArray(TypeElement[]::new);
        List<TypeElement> noAopAnnotation = Arrays.stream(this.annotations).filter(a -> a.getAnnotation(AopAnnotation.class) == null).toList();
        for (TypeElement typeElement : noAopAnnotation) {
            log.warn("Annotation {} has no @AopAnnotation marker, it will not be handled by some util methods", (Object)typeElement.getSimpleName());
        }
    }

    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Set<? extends Element> elements = roundEnv.getElementsAnnotatedWithAny(this.annotations);
        HashSet<TypeElementWithEquals> classesToProcess = new HashSet<TypeElementWithEquals>();
        for (Element element : elements) {
            Either<TypeElement, ProcessingError> typeElement = this.findTypeElement(element);
            if (typeElement.isRight()) {
                ((ProcessingError)typeElement.right()).print(this.processingEnv);
                continue;
            }
            if (!typeElement.isLeft() || typeElement.left() == null) continue;
            classesToProcess.add(new TypeElementWithEquals((TypeElement)typeElement.left()));
        }
        if (!classesToProcess.isEmpty() && log.isInfoEnabled()) {
            List<TypeElement> elems = classesToProcess.stream().map(c -> c.te).toList();
            LogUtils.logElementsFull((Logger)log, (Level)Level.INFO, (String)"Components with aspects found", elems);
        }
        for (TypeElementWithEquals typeElementWithEquals : classesToProcess) {
            TypeSpec typeSpec;
            TypeElement te = typeElementWithEquals.te();
            try {
                typeSpec = this.aopProcessor.applyAspects(te);
            }
            catch (ProcessingErrorException e) {
                e.printError(this.processingEnv);
                continue;
            }
            PackageElement packageElement = this.elements.getPackageOf(te);
            JavaFile javaFile = JavaFile.builder((String)packageElement.getQualifiedName().toString(), (TypeSpec)typeSpec.toBuilder().addOriginatingElement((Element)te).build()).build();
            try {
                javaFile.writeTo(this.processingEnv.getFiler());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return false;
    }

    @Nullable
    private Either<TypeElement, ProcessingError> findTypeElement(Element element) {
        if (element.getKind() == ElementKind.INTERFACE) {
            return Either.left(null);
        }
        if (element.getKind() == ElementKind.CLASS) {
            if (element.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                return Either.left(null);
            }
            if (element.getModifiers().contains((Object)Modifier.FINAL)) {
                return Either.right((Object)new ProcessingError("Aspects can't be applied to final classes, but " + element.getSimpleName() + " is final", element));
            }
            TypeElement typeElement = (TypeElement)element;
            ExecutableElement constructor = AopUtils.findAopConstructor(typeElement);
            if (constructor == null) {
                return Either.right((Object)new ProcessingError("Can't find constructor suitable for aop proxy for " + element.getSimpleName(), element));
            }
            return Either.left((Object)typeElement);
        }
        if (element.getKind() == ElementKind.PARAMETER) {
            return this.findTypeElement(element.getEnclosingElement());
        }
        if (element.getKind() != ElementKind.METHOD) {
            return Either.right((Object)new ProcessingError("Aspects can be applied only to classes or methods, got %s".formatted(new Object[]{element.getKind()}), element));
        }
        if (element.getModifiers().contains((Object)Modifier.FINAL)) {
            return Either.right((Object)new ProcessingError("Aspects can't be applied to final methods, but method " + element.getEnclosingElement().getSimpleName() + "#" + element.getSimpleName() + "() is final", element));
        }
        if (element.getModifiers().contains((Object)Modifier.PRIVATE)) {
            return Either.right((Object)new ProcessingError("Aspects can't be applied to private methods, but method " + element.getEnclosingElement().getSimpleName() + "#" + element.getSimpleName() + "() is private", element));
        }
        return this.findTypeElement(element.getEnclosingElement());
    }

    private record TypeElementWithEquals(TypeElement te) {
        @Override
        public boolean equals(Object obj) {
            if (obj instanceof TypeElementWithEquals) {
                TypeElementWithEquals that = (TypeElementWithEquals)obj;
                return this.te.getQualifiedName().contentEquals(that.te.getQualifiedName());
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.te.getQualifiedName().hashCode();
        }
    }
}

