/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.aop.annotation.processor;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.tinkoff.kora.annotation.processor.common.AnnotationUtils;
import ru.tinkoff.kora.annotation.processor.common.CommonClassNames;
import ru.tinkoff.kora.annotation.processor.common.CommonUtils;
import ru.tinkoff.kora.annotation.processor.common.ProcessingErrorException;
import ru.tinkoff.kora.annotation.processor.common.TagUtils;
import ru.tinkoff.kora.aop.annotation.processor.AopAnnotationProcessor;
import ru.tinkoff.kora.aop.annotation.processor.AopUtils;
import ru.tinkoff.kora.aop.annotation.processor.KoraAspect;

public class AopProcessor {
    private static final Logger log = LoggerFactory.getLogger(AopProcessor.class);
    private final List<KoraAspect> aspects;
    private final Types types;
    private final Elements elements;

    public AopProcessor(Types types, Elements elements, List<KoraAspect> aspects) {
        this.aspects = aspects;
        this.types = types;
        this.elements = elements;
    }

    /*
     * WARNING - void declaration
     */
    public TypeSpec applyAspects(TypeElement typeElement) {
        ExecutableElement constructor = AopUtils.findAopConstructor(typeElement);
        if (constructor == null) {
            throw new ProcessingErrorException("Class has no aop suitable constructor", (Element)typeElement);
        }
        ArrayList<KoraAspect> typeLevelAspects = new ArrayList<KoraAspect>();
        for (AnnotationMirror annotationMirror : typeElement.getAnnotationMirrors()) {
            for (KoraAspect aspect : this.aspects) {
                if (!aspect.getSupportedAnnotationTypes().contains(annotationMirror.getAnnotationType().toString()) || typeLevelAspects.contains(aspect)) continue;
                typeLevelAspects.add(aspect);
            }
        }
        log.trace("Type level aspects for {}: {}", (Object)typeElement, typeLevelAspects);
        TypeSpec.Builder typeBuilder = TypeSpec.classBuilder((String)AopUtils.aopProxyName(typeElement)).superclass(typeElement.asType()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addAnnotation(CommonClassNames.aopProxy);
        TypeFieldFactory typeFieldFactory = new TypeFieldFactory(this.types);
        KoraAspect.AspectContext aopContext = new KoraAspect.AspectContext(typeBuilder, typeFieldFactory);
        Set tag = TagUtils.parseTagValue((AnnotatedConstruct)typeElement);
        if (tag != null && !tag.isEmpty()) {
            typeBuilder.addAnnotation(TagUtils.makeAnnotationSpec((Set)tag));
        }
        if (AnnotationUtils.isAnnotationPresent((Element)typeElement, (ClassName)CommonClassNames.root)) {
            typeBuilder.addAnnotation(CommonClassNames.root);
        }
        LinkedHashSet<String> appliedProcessors = new LinkedHashSet<String>();
        appliedProcessors.add(AopAnnotationProcessor.class.getCanonicalName());
        List typeMethods = CommonUtils.findMethods((TypeElement)typeElement, m -> !m.contains((Object)Modifier.STATIC) && (m.contains((Object)Modifier.PROTECTED) || m.contains((Object)Modifier.PUBLIC)));
        for (ExecutableElement typeMethod : typeMethods) {
            void var16_22;
            ArrayList methodLevelTypeAspects = new ArrayList(typeLevelAspects);
            ArrayList<KoraAspect> methodLevelAspects = new ArrayList<KoraAspect>();
            ArrayList<KoraAspect> methodParameterLevelAspects = new ArrayList<KoraAspect>();
            for (AnnotationMirror annotationMirror : typeMethod.getAnnotationMirrors()) {
                for (KoraAspect koraAspect : this.aspects) {
                    if (!koraAspect.getSupportedAnnotationTypes().contains(annotationMirror.getAnnotationType().toString())) continue;
                    if (!methodLevelAspects.contains(koraAspect)) {
                        methodLevelAspects.add(koraAspect);
                    }
                    methodLevelTypeAspects.remove(koraAspect);
                }
            }
            for (VariableElement variableElement : typeMethod.getParameters()) {
                for (AnnotationMirror annotationMirror : variableElement.getAnnotationMirrors()) {
                    for (KoraAspect aspect : this.aspects) {
                        if (!aspect.getSupportedAnnotationTypes().contains(annotationMirror.getAnnotationType().toString())) continue;
                        if (!methodParameterLevelAspects.contains(aspect) && !methodLevelAspects.contains(aspect)) {
                            methodParameterLevelAspects.add(aspect);
                        }
                        methodLevelTypeAspects.remove(aspect);
                    }
                }
            }
            if (methodLevelTypeAspects.isEmpty() && methodLevelAspects.isEmpty() && methodParameterLevelAspects.isEmpty()) continue;
            log.trace("Method level aspects for {}#{}: {}", new Object[]{typeElement, typeMethod.getSimpleName(), methodLevelAspects});
            ArrayList<KoraAspect> aspectsToApply = new ArrayList<KoraAspect>(methodLevelTypeAspects);
            aspectsToApply.addAll(methodLevelAspects);
            aspectsToApply.addAll(methodParameterLevelAspects);
            String string = "super." + typeMethod.getSimpleName();
            MethodSpec.Builder overridenMethod = MethodSpec.overriding((ExecutableElement)typeMethod);
            Collections.reverse(aspectsToApply);
            HashSet<CallSite> hashSet = new HashSet<CallSite>();
            for (KoraAspect aspect : aspectsToApply) {
                KoraAspect.ApplyResult result = aspect.apply(typeMethod, (String)var16_22, aopContext);
                if (result instanceof KoraAspect.ApplyResult.Noop) continue;
                KoraAspect.ApplyResult.MethodBody methodBody = (KoraAspect.ApplyResult.MethodBody)result;
                String methodNameBase = "_" + typeMethod.getSimpleName() + "_AopProxy_" + aspect.getClass().getSimpleName();
                String methodName = "_" + typeMethod.getSimpleName() + "_AopProxy_" + aspect.getClass().getSimpleName();
                for (int i = 0; i < Integer.MAX_VALUE && !hashSet.add((CallSite)((Object)methodName)); ++i) {
                    methodName = methodNameBase + i;
                }
                String string2 = methodName;
                MethodSpec.Builder m2 = MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PRIVATE}).addCode(methodBody.codeBlock());
                for (VariableElement variableElement : typeMethod.getParameters()) {
                    m2.addParameter(ParameterSpec.builder((TypeName)TypeName.get((TypeMirror)variableElement.asType()), (String)variableElement.getSimpleName().toString(), (Modifier[])new Modifier[0]).build());
                }
                for (TypeParameterElement typeParameterElement : typeMethod.getTypeParameters()) {
                    m2.addTypeVariable(TypeVariableName.get((TypeParameterElement)typeParameterElement));
                }
                for (TypeMirror typeMirror : typeMethod.getThrownTypes()) {
                    m2.addException(TypeName.get((TypeMirror)typeMirror));
                }
                m2.returns(TypeName.get((TypeMirror)typeMethod.getReturnType()));
                typeBuilder.addMethod(m2.build());
                appliedProcessors.add(aspect.getClass().getCanonicalName());
            }
            CodeBlock.Builder b = CodeBlock.builder();
            if (typeMethod.getReturnType().getKind() != TypeKind.VOID) {
                b.add("return ", new Object[0]);
            }
            if (var16_22.startsWith("super.")) {
                b.add("$L(", new Object[]{var16_22});
            } else {
                b.add("this.$L(", new Object[]{var16_22});
            }
            for (int i = 0; i < typeMethod.getParameters().size(); ++i) {
                if (i > 0) {
                    b.add(", ", new Object[0]);
                }
                VariableElement parameter = typeMethod.getParameters().get(i);
                b.add("$L", new Object[]{parameter});
            }
            b.add(");\n", new Object[0]);
            overridenMethod.addCode(b.build());
            typeBuilder.addMethod(overridenMethod.build());
        }
        CodeBlock generated = (CodeBlock)appliedProcessors.stream().map(a -> CodeBlock.of((String)"$S", (Object[])new Object[]{a})).collect(CodeBlock.joining((String)", ", (String)"{", (String)"}"));
        typeBuilder.addAnnotation(AnnotationSpec.builder((ClassName)CommonClassNames.koraGenerated).addMember("value", generated).build());
        if (AnnotationUtils.findAnnotation((Element)typeElement, (ClassName)CommonClassNames.component) != null) {
            typeBuilder.addAnnotation(CommonClassNames.component);
        }
        MethodSpec.Builder constructorBuilder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC});
        constructorBuilder.addCode("super(", new Object[0]);
        for (int i = 0; i < constructor.getParameters().size(); ++i) {
            if (i > 0) {
                constructorBuilder.addCode(", ", new Object[0]);
            }
            VariableElement parameter = constructor.getParameters().get(i);
            constructorBuilder.addCode("$L", new Object[]{parameter});
            ParameterSpec parameterSpec = ParameterSpec.get((VariableElement)parameter);
            Set tags = TagUtils.parseTagValue((AnnotatedConstruct)parameter);
            if (!tags.isEmpty()) {
                parameterSpec = parameterSpec.toBuilder().addAnnotation(TagUtils.makeAnnotationSpec((Set)tags)).build();
            }
            if (CommonUtils.isNullable((AnnotatedConstruct)parameter)) {
                parameterSpec = parameterSpec.toBuilder().addAnnotation(CommonClassNames.nullable).build();
            }
            constructorBuilder.addParameter(parameterSpec);
        }
        constructorBuilder.addCode(");\n", new Object[0]);
        typeFieldFactory.addFields(typeBuilder);
        typeFieldFactory.enrichConstructor(constructorBuilder);
        typeBuilder.addMethod(constructorBuilder.build());
        return typeBuilder.build();
    }

    private static class TypeFieldFactory
    implements KoraAspect.FieldFactory {
        private final Types types;
        private final Set<String> fieldNames = new HashSet<String>();
        private final Map<ConstructorParamKey, String> constructorParams = new LinkedHashMap<ConstructorParamKey, String>();
        private final Map<ConstructorInitializedParamKey, String> constructorInitializedParams = new LinkedHashMap<ConstructorInitializedParamKey, String>();

        private TypeFieldFactory(Types types) {
            this.types = types;
        }

        public void addFields(TypeSpec.Builder typeBuilder) {
            Record fd;
            String name;
            for (Map.Entry<ConstructorParamKey, String> entry : this.constructorParams.entrySet()) {
                name = entry.getValue();
                fd = entry.getKey();
                typeBuilder.addField(FieldSpec.builder((TypeName)((ConstructorParamKey)fd).type(), (String)name, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build());
            }
            for (Map.Entry<Record, String> entry : this.constructorInitializedParams.entrySet()) {
                name = entry.getValue();
                fd = (ConstructorInitializedParamKey)entry.getKey();
                typeBuilder.addField(FieldSpec.builder((TypeName)((ConstructorInitializedParamKey)fd).type(), (String)name, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build());
            }
        }

        @Override
        public String constructorParam(TypeName type, List<AnnotationSpec> annotations) {
            return this.constructorParams.computeIfAbsent(new ConstructorParamKey(type, annotations, this.types), this::computeFieldName);
        }

        @Override
        public String constructorInitialized(TypeName type, CodeBlock initializer) {
            return this.constructorInitializedParams.computeIfAbsent(new ConstructorInitializedParamKey(type, initializer, this.types), this::computeFieldName);
        }

        public void enrichConstructor(MethodSpec.Builder constructorBuilder) {
            Record fd;
            String name;
            for (Map.Entry<ConstructorParamKey, String> entry : this.constructorParams.entrySet()) {
                name = entry.getValue();
                fd = entry.getKey();
                constructorBuilder.addParameter(ParameterSpec.builder((TypeName)fd.type(), (String)name, (Modifier[])new Modifier[0]).addAnnotations(fd.annotations()).build());
                constructorBuilder.addCode("this.$L = $L;\n", new Object[]{name, name});
            }
            for (Map.Entry<Record, String> entry : this.constructorInitializedParams.entrySet()) {
                name = entry.getValue();
                fd = (ConstructorInitializedParamKey)entry.getKey();
                constructorBuilder.addCode("this.$L = $L;\n", new Object[]{name, ((ConstructorInitializedParamKey)fd).initializer});
            }
        }

        private String computeFieldName(ConstructorParamKey key) {
            int dotIndex;
            String qualifiedType = key.type().toString();
            if (qualifiedType.indexOf(60) > 0) {
                qualifiedType = qualifiedType.substring(0, qualifiedType.indexOf(60));
            }
            String shortName = (dotIndex = qualifiedType.lastIndexOf(46)) < 0 ? CommonUtils.decapitalize((String)qualifiedType) : CommonUtils.decapitalize((String)qualifiedType.substring(dotIndex + 1));
            for (int i = 1; i < Integer.MAX_VALUE; ++i) {
                String name = shortName + i;
                if (!this.fieldNames.add(name)) continue;
                return name;
            }
            throw new IllegalStateException("Can't compute name for " + key);
        }

        private String computeFieldName(ConstructorInitializedParamKey key) {
            int dotIndex;
            String qualifiedType = key.type().toString();
            if (qualifiedType.indexOf(60) > 0) {
                qualifiedType = qualifiedType.substring(0, qualifiedType.indexOf(60));
            }
            String shortName = (dotIndex = qualifiedType.lastIndexOf(46)) < 0 ? CommonUtils.decapitalize((String)qualifiedType) : CommonUtils.decapitalize((String)qualifiedType.substring(dotIndex + 1));
            for (int i = 1; i < Integer.MAX_VALUE; ++i) {
                String name = shortName + i;
                if (!this.fieldNames.add(name)) continue;
                return name;
            }
            return null;
        }

        private record ConstructorParamKey(TypeName type, List<AnnotationSpec> annotations, Types types) {
        }

        private record ConstructorInitializedParamKey(TypeName type, CodeBlock initializer, Types types) {
        }
    }
}

