/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.aop.annotation.processor;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;

public interface KoraAspect {
    public Set<String> getSupportedAnnotationTypes();

    public ApplyResult apply(ExecutableElement var1, String var2, AspectContext var3);

    public static CodeBlock callSuper(String superCall, List<String> params) {
        CodeBlock.Builder b = CodeBlock.builder().add(superCall, new Object[0]).add("(", new Object[0]);
        for (int i = 0; i < params.size(); ++i) {
            String param = params.get(i);
            if (i > 0) {
                b.add(", ", new Object[0]);
            }
            b.add("$N", new Object[]{param});
        }
        b.add(")", new Object[0]);
        return b.build();
    }

    public static CodeBlock callSuper(ExecutableElement executableElement, String superCall) {
        ArrayList<String> params = new ArrayList<String>(executableElement.getParameters().size());
        for (VariableElement variableElement : executableElement.getParameters()) {
            params.add(variableElement.getSimpleName().toString());
        }
        return KoraAspect.callSuper(superCall, params);
    }

    public record AspectContext(TypeSpec.Builder typeBuilder, FieldFactory fieldFactory) {
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface ApplyResult {

        public record MethodBody(CodeBlock codeBlock) implements ApplyResult
        {
        }

        public static enum Noop implements ApplyResult
        {
            INSTANCE;

        }
    }

    public static interface FieldFactory {
        default public String constructorParam(TypeMirror type, List<AnnotationSpec> annotations) {
            return this.constructorParam(TypeName.get((TypeMirror)type), annotations);
        }

        public String constructorParam(TypeName var1, List<AnnotationSpec> var2);

        default public String constructorInitialized(TypeMirror type, CodeBlock initializer) {
            return this.constructorInitialized(TypeName.get((TypeMirror)type), initializer);
        }

        public String constructorInitialized(TypeName var1, CodeBlock var2);
    }
}

