/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.aop.annotation.processor;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeSpec;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;
import ru.tinkoff.kora.annotation.processor.common.AbstractKoraProcessor;
import ru.tinkoff.kora.annotation.processor.common.AnnotationUtils;
import ru.tinkoff.kora.annotation.processor.common.CommonClassNames;
import ru.tinkoff.kora.annotation.processor.common.Either;
import ru.tinkoff.kora.annotation.processor.common.LogUtils;
import ru.tinkoff.kora.annotation.processor.common.ProcessingError;
import ru.tinkoff.kora.annotation.processor.common.ProcessingErrorException;
import ru.tinkoff.kora.aop.annotation.processor.AopProcessor;
import ru.tinkoff.kora.aop.annotation.processor.AopUtils;
import ru.tinkoff.kora.aop.annotation.processor.KoraAspect;
import ru.tinkoff.kora.aop.annotation.processor.KoraAspectFactory;

public class AopAnnotationProcessor
extends AbstractKoraProcessor {
    private static final Logger log = LoggerFactory.getLogger(AopAnnotationProcessor.class);
    private List<KoraAspect> aspects;
    private Set<ClassName> annotations;
    private AopProcessor aopProcessor;

    public Set<ClassName> getSupportedAnnotationClassNames() {
        return this.annotations;
    }

    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.aspects = ServiceLoader.load(KoraAspectFactory.class, ((Object)((Object)this)).getClass().getClassLoader()).stream().map(ServiceLoader.Provider::get).mapMulti((factory, sink) -> factory.create(processingEnv).ifPresent((Consumer<KoraAspect>)sink)).toList();
        this.aopProcessor = new AopProcessor(this.types, this.elements, this.aspects);
        this.annotations = this.aspects.stream().flatMap(a -> a.getSupportedAnnotationClassNames().stream()).collect(Collectors.toSet());
        if (log.isDebugEnabled()) {
            String aspects = this.aspects.stream().map(Object::getClass).map(Class::getCanonicalName).collect(Collectors.joining("\n\t", "\t", "")).indent(4);
            log.debug("Discovered aspects:\n{}", (Object)aspects);
        }
    }

    protected void process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv, Map<ClassName, List<AbstractKoraProcessor.AnnotatedElement>> annotatedElements) {
        record RoundAnnotations(List<? extends TypeElement> withAopAnnotation, List<? extends TypeElement> noAopAnnotation) {
        }
        RoundAnnotations roundAnnotations = annotations.stream().filter(a -> this.annotations.contains(ClassName.get((TypeElement)a))).collect(Collectors.teeing(Collectors.filtering(a -> AnnotationUtils.isAnnotationPresent((Element)a, (ClassName)CommonClassNames.aopAnnotation), Collectors.toList()), Collectors.filtering(a -> !AnnotationUtils.isAnnotationPresent((Element)a, (ClassName)CommonClassNames.aopAnnotation), Collectors.toList()), (x$0, x$1) -> new RoundAnnotations((List<? extends TypeElement>)x$0, (List<? extends TypeElement>)x$1)));
        for (TypeElement typeElement : roundAnnotations.noAopAnnotation()) {
            log.warn("Annotation {} has no @AopAnnotation marker, it will not be handled by some util methods", (Object)typeElement.getSimpleName());
        }
        Set<? extends Element> elements = roundEnv.getElementsAnnotatedWithAny((TypeElement[])roundAnnotations.withAopAnnotation().toArray(TypeElement[]::new));
        HashMap<ClassName, TypeElement> hashMap = new HashMap<ClassName, TypeElement>();
        for (Element element : elements) {
            Either<TypeElement, ProcessingError> typeElement = this.findTypeElement(element);
            if (typeElement.isRight()) {
                ((ProcessingError)typeElement.right()).print(this.processingEnv);
                continue;
            }
            if (!typeElement.isLeft() || typeElement.left() == null) continue;
            hashMap.put(ClassName.get((TypeElement)((TypeElement)typeElement.left())), (TypeElement)typeElement.left());
        }
        if (!hashMap.isEmpty() && log.isInfoEnabled()) {
            LogUtils.logElementsFull((Logger)log, (Level)Level.INFO, (String)"Components with aspects found", hashMap.values());
        }
        for (TypeElement typeElement : hashMap.values()) {
            TypeSpec typeSpec;
            try {
                typeSpec = this.aopProcessor.applyAspects(typeElement);
            }
            catch (ProcessingErrorException e) {
                e.printError(this.processingEnv);
                continue;
            }
            PackageElement packageElement = this.elements.getPackageOf(typeElement);
            JavaFile javaFile = JavaFile.builder((String)packageElement.getQualifiedName().toString(), (TypeSpec)typeSpec.toBuilder().addOriginatingElement((Element)typeElement).build()).build();
            try {
                javaFile.writeTo(this.processingEnv.getFiler());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Nullable
    private Either<TypeElement, ProcessingError> findTypeElement(Element element) {
        if (element.getKind() == ElementKind.INTERFACE) {
            return Either.left(null);
        }
        if (element.getKind() == ElementKind.CLASS) {
            if (element.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                return Either.left(null);
            }
            if (element.getModifiers().contains((Object)Modifier.FINAL)) {
                return Either.right((Object)new ProcessingError("Aspects can't be applied to final classes, but " + String.valueOf(element.getSimpleName()) + " is final", element));
            }
            TypeElement typeElement = (TypeElement)element;
            ExecutableElement constructor = AopUtils.findAopConstructor(typeElement);
            if (constructor == null) {
                return Either.right((Object)new ProcessingError("Can't find constructor suitable for aop proxy for " + String.valueOf(element.getSimpleName()), element));
            }
            return Either.left((Object)typeElement);
        }
        if (element.getKind() == ElementKind.PARAMETER) {
            return this.findTypeElement(element.getEnclosingElement());
        }
        if (element.getKind() != ElementKind.METHOD) {
            return Either.right((Object)new ProcessingError("Aspects can be applied only to classes or methods, got %s".formatted(new Object[]{element.getKind()}), element));
        }
        if (element.getModifiers().contains((Object)Modifier.FINAL)) {
            return Either.right((Object)new ProcessingError("Aspects can't be applied to final methods, but method " + String.valueOf(element.getEnclosingElement().getSimpleName()) + "#" + String.valueOf(element.getSimpleName()) + "() is final", element));
        }
        if (element.getModifiers().contains((Object)Modifier.PRIVATE)) {
            return Either.right((Object)new ProcessingError("Aspects can't be applied to private methods, but method " + String.valueOf(element.getEnclosingElement().getSimpleName()) + "#" + String.valueOf(element.getSimpleName()) + "() is private", element));
        }
        return this.findTypeElement(element.getEnclosingElement());
    }
}

