/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.application.graph;

import jakarta.annotation.Nullable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import ru.tinkoff.kora.application.graph.Graph;
import ru.tinkoff.kora.application.graph.GraphInterceptor;
import ru.tinkoff.kora.application.graph.Node;
import ru.tinkoff.kora.application.graph.PromiseOf;
import ru.tinkoff.kora.application.graph.RefreshableGraph;
import ru.tinkoff.kora.application.graph.ValueOf;
import ru.tinkoff.kora.application.graph.internal.GraphImpl;
import ru.tinkoff.kora.application.graph.internal.NodeImpl;

public class ApplicationGraphDraw {
    private final List<NodeImpl<?>> graphNodes = new ArrayList();
    private final Class<?> root;

    public ApplicationGraphDraw(Class<?> root) {
        this.root = root;
    }

    public Class<?> getRoot() {
        return this.root;
    }

    public <T> Node<T> addNode0(Type type, Class<?>[] tags, Graph.Factory<? extends T> factory, Node<?> ... dependencies) {
        return this.addNode0(type, tags, factory, List.of(), dependencies);
    }

    /*
     * WARNING - void declaration
     */
    public <T> Node<T> addNode0(Type type, Class<?>[] tags, Graph.Factory<? extends T> factory, List<? extends Node<? extends GraphInterceptor<T>>> interceptors, Node<?> ... dependencies) {
        void var10_18;
        void var9_11;
        ArrayList dependenciesList = new ArrayList();
        Node<?>[] nodeArray = dependencies;
        int n = nodeArray.length;
        boolean bl = false;
        while (var9_11 < n) {
            Node<?> node = nodeArray[var9_11];
            dependenciesList.add((NodeImpl)node);
            ++var9_11;
        }
        ArrayList interceptorsList = new ArrayList();
        for (Node<GraphInterceptor<T>> node : interceptors) {
            interceptorsList.add((NodeImpl)node);
        }
        Node<?>[] nodeArray2 = dependencies;
        int n2 = nodeArray2.length;
        boolean bl2 = false;
        while (var10_18 < n2) {
            Node<?> dependency = nodeArray2[var10_18];
            NodeImpl node = (NodeImpl)dependency;
            if (node.index >= 0 && node.graphDraw != this) {
                throw new IllegalArgumentException("Dependency is from another graph");
            }
            ++var10_18;
        }
        NodeImpl<T> node = new NodeImpl<T>(this, this.graphNodes.size(), factory, type, dependenciesList, interceptorsList, tags);
        this.graphNodes.add(node);
        for (NodeImpl<? extends T> nodeImpl : dependenciesList) {
            if (nodeImpl.isValueOf()) {
                nodeImpl.addDependentNode((NodeImpl)node.valueOf());
                continue;
            }
            nodeImpl.addDependentNode(node);
        }
        for (Node<GraphInterceptor<T>> node2 : interceptors) {
            NodeImpl n3 = (NodeImpl)node2;
            n3.intercepts(node);
        }
        return node;
    }

    public RefreshableGraph init() {
        GraphImpl graph = new GraphImpl(this);
        graph.init();
        return graph;
    }

    public List<Node<?>> getNodes() {
        return Collections.unmodifiableList(this.graphNodes);
    }

    public int size() {
        return this.graphNodes.size();
    }

    @Nullable
    public Node<?> findNodeByType(Type type) {
        for (NodeImpl<?> graphNode : this.graphNodes) {
            if (!graphNode.type().equals(type) || graphNode.tags().length != 0) continue;
            return graphNode;
        }
        return null;
    }

    public List<Node<?>> findNodesByType(Type type, Class<?>[] tags) {
        ArrayList result = new ArrayList();
        for (NodeImpl<?> graphNode : this.graphNodes) {
            if (!graphNode.type().equals(type)) continue;
            if (tags.length == 0 && graphNode.tags().length == 0) {
                result.add(graphNode);
                continue;
            }
            if (tags.length == 1 && tags[0].getCanonicalName().equals("ru.tinkoff.kora.common.Tag.Any")) {
                result.add(graphNode);
                continue;
            }
            if (!Arrays.equals(tags, graphNode.tags()) || !graphNode.type().equals(type)) continue;
            result.add(graphNode);
        }
        return result;
    }

    public <T> void replaceNode(Node<T> node, Graph.Factory<? extends T> factory) {
        NodeImpl casted = (NodeImpl)node;
        this.graphNodes.set(casted.index, new NodeImpl<T>(this, casted.index, factory, node.type(), List.of(), List.of(), node.tags()));
        for (NodeImpl<?> graphNode : this.graphNodes) {
            graphNode.deleteDependentNode(casted);
        }
    }

    public <T> void replaceNodeKeepDependencies(Node<T> node, Graph.Factory<? extends T> factory) {
        NodeImpl casted = (NodeImpl)node;
        this.graphNodes.set(casted.index, new NodeImpl<T>(this, casted.index, factory, node.type(), casted.getDependencyNodes(), List.of(), node.tags()));
    }

    public ApplicationGraphDraw copy() {
        ApplicationGraphDraw draw = new ApplicationGraphDraw(this.root);
        for (NodeImpl<?> node : this.graphNodes) {
            class T {
                T() {
                }

                static <T> void addNode(ApplicationGraphDraw draw, NodeImpl<T> node) {
                    NodeImpl[] dependencies = new NodeImpl[node.getDependencyNodes().size()];
                    for (int i = 0; i < dependencies.length; ++i) {
                        NodeImpl<?> dependency = node.getDependencyNodes().get(i);
                        dependencies[i] = draw.graphNodes.get(dependency.index);
                    }
                    draw.addNode0(node.type(), node.tags(), node.factory, node.getInterceptors(), dependencies);
                }
            }
            T.addNode(draw, node);
        }
        return draw;
    }

    public ApplicationGraphDraw subgraph(List<Node<?>> excludeTransitive, Iterable<Node<?>> rootNodes) {
        final TreeMap seen = new TreeMap();
        final Set excludeTransitiveSet = excludeTransitive.stream().map(n -> ((NodeImpl)n).index).collect(Collectors.toSet());
        final ApplicationGraphDraw subgraph = new ApplicationGraphDraw(this.root);
        var visitor = new Object(){

            public <T> Node<T> accept(NodeImpl<T> node) {
                if (!seen.containsKey(node.index)) {
                    ArrayList<Node<Object>> dependencies = new ArrayList<Node<Object>>();
                    ArrayList<Node<Object>> interceptors = new ArrayList<Node<Object>>();
                    if (!excludeTransitiveSet.contains(node.index)) {
                        for (NodeImpl<Object> nodeImpl : node.getDependencyNodes()) {
                            dependencies.add(this.accept(nodeImpl));
                        }
                    }
                    for (NodeImpl<Object> nodeImpl : node.getInterceptors()) {
                        interceptors.add(this.accept(nodeImpl));
                    }
                    Graph.Factory<Object> factory = graph -> node.factory.get(new Graph(){

                        @Override
                        public ApplicationGraphDraw draw() {
                            return subgraph;
                        }

                        public <Q> Q get(Node<Q> node1) {
                            NodeImpl casted = (NodeImpl)node1;
                            Node realNode = subgraph.graphNodes.get((Integer)seen.get(casted.index));
                            return (Q)graph.get(realNode);
                        }

                        public <Q> ValueOf<Q> valueOf(Node<? extends Q> node1) {
                            NodeImpl casted = (NodeImpl)node1;
                            Node realNode = subgraph.graphNodes.get((Integer)seen.get(casted.index));
                            return graph.valueOf(realNode);
                        }

                        public <Q> PromiseOf<Q> promiseOf(Node<Q> node1) {
                            NodeImpl casted = (NodeImpl)node1;
                            Node realNode = subgraph.graphNodes.get((Integer)seen.get(casted.index));
                            return graph.promiseOf(realNode);
                        }
                    });
                    NodeImpl nodeImpl = (NodeImpl)subgraph.addNode0(node.type(), node.tags(), factory, interceptors, dependencies.toArray(new Node[0]));
                    seen.put(node.index, nodeImpl.index);
                    return nodeImpl;
                }
                Integer index = (Integer)seen.get(node.index);
                Node newNode = subgraph.graphNodes.get(index);
                return newNode;
            }
        };
        for (Node<?> rootNode : rootNodes) {
            NodeImpl casted = (NodeImpl)rootNode;
            visitor.accept(this.graphNodes.get(casted.index));
        }
        return subgraph;
    }
}

