/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.application.graph.internal;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.tinkoff.kora.application.graph.ApplicationGraphDraw;
import ru.tinkoff.kora.application.graph.Graph;
import ru.tinkoff.kora.application.graph.GraphInterceptor;
import ru.tinkoff.kora.application.graph.Lifecycle;
import ru.tinkoff.kora.application.graph.Node;
import ru.tinkoff.kora.application.graph.PromiseOf;
import ru.tinkoff.kora.application.graph.RefreshListener;
import ru.tinkoff.kora.application.graph.RefreshableGraph;
import ru.tinkoff.kora.application.graph.ValueOf;
import ru.tinkoff.kora.application.graph.internal.NodeImpl;
import ru.tinkoff.kora.application.graph.internal.PromiseOfImpl;
import ru.tinkoff.kora.application.graph.internal.loom.VirtualThreadExecutorHolder;

public final class GraphImpl
implements RefreshableGraph,
Lifecycle {
    private static final CompletableFuture<Void> EMPTY_FUTURE = CompletableFuture.completedFuture(null);
    private final Executor executor;
    private final ApplicationGraphDraw draw;
    private final Logger log;
    private final Semaphore semaphore = new Semaphore(1);
    private final Set<Integer> refreshListenerNodes = new HashSet<Integer>();
    private volatile AtomicReferenceArray<Object> objects;

    public GraphImpl(ApplicationGraphDraw draw) {
        this.draw = draw;
        this.log = LoggerFactory.getLogger(this.draw.getRoot());
        this.objects = new AtomicReferenceArray(this.draw.size());
        Executor loomExecutor = VirtualThreadExecutorHolder.executor();
        this.executor = Objects.requireNonNullElse(loomExecutor, ForkJoinPool.commonPool());
        Logger loomLogger = LoggerFactory.getLogger(VirtualThreadExecutorHolder.class);
        VirtualThreadExecutorHolder.VirtualThreadStatus status = VirtualThreadExecutorHolder.status();
        if (status == VirtualThreadExecutorHolder.VirtualThreadStatus.ENABLED) {
            loomLogger.info("VirtualThreadExecutor enabled");
        } else if (status == VirtualThreadExecutorHolder.VirtualThreadStatus.DISABLED) {
            loomLogger.info("VirtualThreadExecutor disabled");
        } else {
            loomLogger.info("VirtualThreadExecutor unavailable");
        }
    }

    @Override
    public ApplicationGraphDraw draw() {
        return this.draw;
    }

    @Override
    public <T> T get(Node<T> node) {
        NodeImpl casted = (NodeImpl)node;
        if (casted.graphDraw != this.draw) {
            throw new IllegalArgumentException("Node is from another graph");
        }
        Object value = this.objects.get(casted.index);
        if (value == null) {
            throw new IllegalStateException("Value was note initialized");
        }
        return (T)value;
    }

    @Override
    public <T> ValueOf<T> valueOf(final Node<? extends T> node) {
        final NodeImpl casted = (NodeImpl)node;
        if (casted.graphDraw != this.draw) {
            throw new IllegalArgumentException("Node is from another graph");
        }
        return new ValueOf<T>(){

            @Override
            public T get() {
                return GraphImpl.this.get(node);
            }

            @Override
            public void refresh() {
                GraphImpl.this.refresh(casted);
            }
        };
    }

    @Override
    public <T> PromiseOf<T> promiseOf(Node<T> node) {
        NodeImpl casted = (NodeImpl)node;
        if (casted.index >= 0 && casted.graphDraw != this.draw) {
            throw new IllegalArgumentException("Node is from another graph");
        }
        return new PromiseOfImpl(this, casted);
    }

    @Override
    public void refresh(Node<?> fromNodeRaw) {
        NodeImpl fromNode = (NodeImpl)fromNodeRaw;
        BitSet root = new BitSet(this.objects.length());
        root.set(fromNode.index);
        this.semaphore.acquireUninterruptibly();
        this.log.debug("Dependency container refreshing from node {} of class {}...", (Object)fromNode.index, this.objects.get(fromNode.index).getClass());
        long started = this.log.isDebugEnabled() ? GraphImpl.started() : 0L;
        try {
            this.initializeSubgraph(root).toCompletableFuture().join();
            if (this.log.isDebugEnabled()) {
                this.log.debug("Dependency container refreshed in {}", (Object)GraphImpl.tookForLogging(started));
            }
        }
        catch (Throwable e) {
            if (e instanceof CancellationException) {
                this.log.debug("Dependency container refresh cancelled");
            } else {
                this.log.debug("Dependency container refresh error", e);
            }
            if (e instanceof CompletionException) {
                CompletionException ce = (CompletionException)e;
                Throwable throwable = ce.getCause();
                if (throwable instanceof RuntimeException) {
                    RuntimeException re = (RuntimeException)throwable;
                    throw re;
                }
                throwable = ce.getCause();
                if (throwable instanceof Error) {
                    Error re = (Error)throwable;
                    throw re;
                }
                throw ce;
            }
            throw e;
        }
        finally {
            this.semaphore.release();
        }
    }

    @Override
    public void init() {
        BitSet root = new BitSet(this.objects.length());
        root.set(0, this.objects.length());
        this.semaphore.acquireUninterruptibly();
        this.log.debug("Dependency container initializing...");
        long started = GraphImpl.started();
        CompletionStage<Void> f = this.initializeSubgraph(root).whenComplete((unused, throwable) -> {
            this.semaphore.release();
            if (throwable == null) {
                this.log.debug("Dependency container initialized in {}", (Object)GraphImpl.tookForLogging(started));
                return;
            }
            if (throwable instanceof CancellationException) {
                this.log.debug("Dependency container initialization cancelled");
            } else if (throwable instanceof CompletionException) {
                CompletionException ce = (CompletionException)throwable;
                this.log.debug("Dependency container initialization failed", ce.getCause());
            } else {
                this.log.debug("Dependency container initialization failed", throwable);
            }
        });
        try {
            f.toCompletableFuture().join();
        }
        catch (CompletionException e) {
            Throwable throwable2 = e.getCause();
            if (throwable2 instanceof RuntimeException) {
                RuntimeException re = (RuntimeException)throwable2;
                throw re;
            }
            throwable2 = e.getCause();
            if (throwable2 instanceof Error) {
                Error re = (Error)throwable2;
                throw re;
            }
            throw e;
        }
    }

    @Override
    public void release() {
        BitSet root = new BitSet(this.objects.length());
        root.set(0, this.objects.length());
        this.semaphore.acquireUninterruptibly();
        this.log.debug("Dependency container releasing...");
        long started = GraphImpl.started();
        CompletionStage<Void> f = this.releaseNodes(this.objects, root).whenComplete((unused, throwable) -> {
            this.semaphore.release();
            if (throwable == null) {
                this.log.debug("Dependency container released in {}", (Object)GraphImpl.tookForLogging(started));
                return;
            }
            if (throwable instanceof CancellationException) {
                this.log.debug("Dependency container releasing cancelled");
            } else {
                this.log.debug("Dependency container releasing failed", throwable);
            }
        });
        try {
            f.toCompletableFuture().join();
        }
        catch (CompletionException e) {
            Throwable throwable2 = e.getCause();
            if (throwable2 instanceof RuntimeException) {
                RuntimeException re = (RuntimeException)throwable2;
                throw re;
            }
            throwable2 = e.getCause();
            if (throwable2 instanceof Error) {
                Error re = (Error)throwable2;
                throw re;
            }
            throw e;
        }
    }

    private CompletionStage<Void> initializeSubgraph(BitSet root) {
        this.log.trace("Materializing graph objects {}", (Object)root);
        TmpGraph tmpGraph = new TmpGraph(this);
        return tmpGraph.init(root).thenCompose(unused -> {
            AtomicReferenceArray<Object> oldObjects = this.objects;
            this.objects = tmpGraph.tmpArray;
            for (TmpValueOf<?> tmpValueOf : tmpGraph.newValueOf) {
                tmpValueOf.tmpGraph = this;
            }
            for (PromiseOfImpl promiseOfImpl : tmpGraph.newPromises) {
                promiseOfImpl.graph = this;
            }
            this.log.trace("Dependency container refreshed, calling interceptors...");
            for (Integer n : this.refreshListenerNodes) {
                Object patt8036$temp = this.objects.get(n);
                if (!(patt8036$temp instanceof RefreshListener)) continue;
                RefreshListener refreshListener = (RefreshListener)patt8036$temp;
                try {
                    refreshListener.graphRefreshed();
                }
                catch (Exception e2) {
                    this.log.warn("Exception caught when calling listener.graphRefreshed(), object={}", (Object)refreshListener);
                }
            }
            this.log.trace("Dependency container refreshed, ");
            return this.releaseNodes(oldObjects, tmpGraph.initialized).exceptionally(e -> {
                this.log.warn("Error on releasing original objects after refresh", e);
                return null;
            });
        }).exceptionallyCompose(e -> this.releaseNodes(tmpGraph.tmpArray, tmpGraph.initialized).exceptionallyCompose(e1 -> {
            this.log.warn("Error on releasing temporary objects after init error", e1);
            e.addSuppressed((Throwable)e1);
            return CompletableFuture.failedFuture(e);
        }).thenCompose(v -> CompletableFuture.failedFuture(e)));
    }

    private CompletionStage<Void> releaseNodes(AtomicReferenceArray<Object> objects, BitSet root) {
        CompletableFuture[] release = new CompletableFuture[objects.length()];
        for (int i = objects.length() - 1; i >= 0; --i) {
            if (!root.get(i)) {
                release[i] = EMPTY_FUTURE;
                continue;
            }
            NodeImpl node = (NodeImpl)this.draw.getNodes().get(i);
            release[i] = this.release(objects, release, node);
        }
        return CompletableFuture.allOf(release);
    }

    private <T> CompletableFuture<Void> release(AtomicReferenceArray<Object> objects, CompletableFuture<?>[] releases, NodeImpl<T> node) {
        int i;
        Object object = objects.get(node.index);
        if (object == null) {
            return EMPTY_FUTURE;
        }
        CompletableFuture[] dependentNodes = new CompletableFuture[node.getDependentNodes().size() + node.getIntercepts().size()];
        for (i = 0; i < node.getDependentNodes().size(); ++i) {
            NodeImpl<?> n = node.getDependentNodes().get(i);
            dependentNodes[i] = n.index >= 0 ? Objects.requireNonNullElse(releases[n.index], EMPTY_FUTURE).exceptionally(e -> null) : EMPTY_FUTURE;
        }
        for (i = 0; i < node.getIntercepts().size(); ++i) {
            NodeImpl<?> interceptor = node.getIntercepts().get(i);
            dependentNodes[node.getDependentNodes().size() + i] = interceptor.index >= 0 ? Objects.requireNonNullElse(releases[interceptor.index], EMPTY_FUTURE).exceptionally(e -> null) : EMPTY_FUTURE;
        }
        CompletableFuture<Void> dependentReleases = CompletableFuture.allOf(dependentNodes);
        CompletionStage<Object> intercept = CompletableFuture.completedFuture(object);
        ListIterator<NodeImpl<GraphInterceptor<T>>> i2 = node.getInterceptors().listIterator(node.getInterceptors().size());
        while (i2.hasPrevious()) {
            NodeImpl<GraphInterceptor<T>> interceptorNode = i2.previous();
            GraphInterceptor interceptor = (GraphInterceptor)objects.get(interceptorNode.index);
            intercept = intercept.thenApplyAsync(o -> {
                this.log.trace("Intercepting release node {} of class {} with node {} of class {}", new Object[]{node.index, o.getClass(), interceptorNode.index, interceptor.getClass()});
                try {
                    Object intercepted = interceptor.release(o);
                    this.log.trace("Intercepting release node {} of class {} with node {} of class {} complete", new Object[]{node.index, o.getClass(), interceptorNode.index, interceptor.getClass()});
                    return intercepted;
                }
                catch (Error | RuntimeException e) {
                    this.log.trace("Intercepting release node {} of class {} with node {} of class {} error", new Object[]{node.index, o.getClass(), interceptorNode.index, interceptor.getClass(), e});
                    throw e;
                }
                catch (Throwable e) {
                    this.log.trace("Intercepting release node {} of class {} with node {} of class {} error", new Object[]{node.index, o.getClass(), interceptorNode.index, interceptor.getClass(), e});
                    throw new IllegalStateException(e);
                }
            }, this.executor);
        }
        CompletableFuture<Object> finalIntercept = intercept;
        return ((CompletableFuture)dependentReleases.thenCompose(v -> finalIntercept)).thenComposeAsync(v -> {
            if (v instanceof Lifecycle) {
                Lifecycle lifecycle = (Lifecycle)v;
                this.log.trace("Releasing node {} of class {}", (Object)node.index, object.getClass());
                try {
                    lifecycle.release();
                }
                catch (Error | Exception e) {
                    return CompletableFuture.failedFuture(e);
                }
                this.log.trace("Node {} of class {} released", (Object)node.index, object.getClass());
            } else if (v instanceof AutoCloseable) {
                AutoCloseable closeable = (AutoCloseable)v;
                this.log.trace("Releasing node {} of class {}", (Object)node.index, object.getClass());
                try {
                    closeable.close();
                }
                catch (Error | Exception e) {
                    return CompletableFuture.failedFuture(e);
                }
                this.log.trace("Node {} of class {} released", (Object)node.index, object.getClass());
            }
            return CompletableFuture.completedFuture(null);
        }, this.executor);
    }

    private static long started() {
        return System.nanoTime();
    }

    private static String tookForLogging(long started) {
        return Duration.ofNanos(System.nanoTime() - started).truncatedTo(ChronoUnit.MILLIS).toString().substring(2).toLowerCase();
    }

    private static class TmpGraph
    implements Graph {
        private final GraphImpl rootGraph;
        private final AtomicReferenceArray<Object> tmpArray;
        private final Collection<TmpValueOf<?>> newValueOf = new ConcurrentLinkedDeque();
        private final Collection<PromiseOfImpl<?>> newPromises = new ConcurrentLinkedDeque();
        private final AtomicReferenceArray<CompletableFuture<Void>> inits;
        private final BitSet initialized;
        private final Executor executor;

        private TmpGraph(GraphImpl rootGraph) {
            this.rootGraph = rootGraph;
            this.tmpArray = new AtomicReferenceArray(this.rootGraph.objects.length());
            for (int i = 0; i < this.rootGraph.objects.length(); ++i) {
                this.tmpArray.set(i, this.rootGraph.objects.get(i));
            }
            this.inits = new AtomicReferenceArray(this.tmpArray.length());
            this.initialized = new BitSet(this.tmpArray.length());
            this.executor = rootGraph.executor;
        }

        @Override
        public ApplicationGraphDraw draw() {
            return this.rootGraph.draw();
        }

        @Override
        public <T> T get(Node<T> node) {
            NodeImpl casted = (NodeImpl)node;
            return (T)this.tmpArray.get(casted.index);
        }

        @Override
        public <T> ValueOf<T> valueOf(Node<? extends T> node) {
            NodeImpl casted = (NodeImpl)node;
            NodeImpl fixed = (NodeImpl)this.rootGraph.draw.getNodes().get(casted.index);
            TmpValueOf value = new TmpValueOf(fixed, this, this.rootGraph);
            this.newValueOf.add(value);
            return value;
        }

        @Override
        public <T> PromiseOf<T> promiseOf(Node<T> node) {
            NodeImpl casted = (NodeImpl)node;
            NodeImpl fixed = (NodeImpl)this.rootGraph.draw.getNodes().get(casted.index);
            PromiseOfImpl promise = new PromiseOfImpl(null, fixed);
            this.newPromises.add(promise);
            return promise;
        }

        private <T> void createNode(NodeImpl<T> node, AtomicIntegerArray dependencies) {
            NodeImpl<Object> dependency;
            int i;
            Object oldObject = this.rootGraph.objects.get(node.index);
            int nodeDependencies = dependencies.get(node.index);
            if (nodeDependencies == 0) {
                int r;
                for (NodeImpl<?> dependentNode : node.getDependentNodes()) {
                    r = dependencies.decrementAndGet(dependentNode.index);
                    if (r >= 0) continue;
                    throw new IllegalStateException();
                }
                for (NodeImpl<?> interceptedNode : node.getIntercepts()) {
                    r = dependencies.decrementAndGet(interceptedNode.index);
                    if (r >= 0) continue;
                    throw new IllegalStateException();
                }
                this.inits.set(node.index, EMPTY_FUTURE);
                this.tmpArray.set(node.index, oldObject);
                return;
            }
            if (nodeDependencies < 0) {
                this.inits.set(node.index, EMPTY_FUTURE);
                this.tmpArray.set(node.index, oldObject);
                return;
            }
            Callable<Object> create = () -> {
                CompletableFuture<Void> completableFuture;
                Object newObject;
                if (dependencies.get(node.index) == 0) {
                    for (NodeImpl<?> dependentNode : node.getDependentNodes()) {
                        dependencies.decrementAndGet(dependentNode.index);
                    }
                    for (NodeImpl<?> interceptedNode : node.getIntercepts()) {
                        dependencies.decrementAndGet(interceptedNode.index);
                    }
                    this.inits.set(node.index, EMPTY_FUTURE);
                    this.tmpArray.set(node.index, oldObject);
                    return oldObject;
                }
                if (this.rootGraph.log.isTraceEnabled()) {
                    String dependenciesStr = node.getDependencyNodes().stream().map(n -> String.valueOf(n.index)).collect(Collectors.joining(",", "[", "]"));
                    this.rootGraph.log.trace("Creating node {}, dependencies {}", (Object)node.index, (Object)dependenciesStr);
                }
                if (Objects.equals(newObject = node.factory.get(this), oldObject)) {
                    for (NodeImpl<?> dependentNode : node.getDependentNodes()) {
                        dependencies.decrementAndGet(dependentNode.index);
                    }
                    for (NodeImpl<?> interceptedNode : node.getIntercepts()) {
                        dependencies.decrementAndGet(interceptedNode.index);
                    }
                    return null;
                }
                if (newObject instanceof RefreshListener) {
                    Set<Integer> interceptedNode = this.rootGraph.refreshListenerNodes;
                    synchronized (interceptedNode) {
                        this.rootGraph.refreshListenerNodes.add(node.index);
                    }
                }
                this.rootGraph.log.trace("Created node {} {}", (Object)node.index, newObject.getClass());
                if (newObject instanceof Lifecycle) {
                    Lifecycle lifecycle = (Lifecycle)newObject;
                    completableFuture = this.initializeNode(node, lifecycle);
                } else {
                    completableFuture = EMPTY_FUTURE;
                }
                CompletableFuture<Void> init = completableFuture;
                CompletionStage objectFuture = init.thenApply(v -> newObject);
                for (NodeImpl interceptor : node.getInterceptors()) {
                    GraphInterceptor interceptorObject = (GraphInterceptor)this.tmpArray.get(interceptor.index);
                    objectFuture = ((CompletableFuture)objectFuture).thenApplyAsync(o -> {
                        this.rootGraph.log.trace("Intercepting init node {} of class {} with node {} of class {}", new Object[]{node.index, o.getClass(), interceptor.index, interceptorObject.getClass()});
                        try {
                            Object intercepted = interceptorObject.init(o);
                            this.rootGraph.log.trace("Intercepting init node {} of class {} with node {} of class {} complete", new Object[]{node.index, o.getClass(), interceptor.index, interceptorObject.getClass()});
                            return intercepted;
                        }
                        catch (Error | RuntimeException e) {
                            this.rootGraph.log.trace("Intercepting init node {} of class {} with node {} of class {} error", new Object[]{node.index, o.getClass(), interceptor.index, interceptorObject.getClass(), e});
                            throw e;
                        }
                        catch (Throwable e) {
                            this.rootGraph.log.trace("Intercepting init node {} of class {} with node {} of class {} error", new Object[]{node.index, o.getClass(), interceptor.index, interceptorObject.getClass(), e});
                            throw new IllegalStateException(e);
                        }
                    }, this.executor);
                }
                Object result = ((CompletableFuture)objectFuture).join();
                this.tmpArray.set(node.index, result);
                return result;
            };
            CompletableFuture[] dependencyInitializationFutures = new CompletableFuture[node.getDependencyNodes().size() + node.getInterceptors().size()];
            for (i = 0; i < node.getDependencyNodes().size(); ++i) {
                dependency = node.getDependencyNodes().get(i);
                dependencyInitializationFutures[i] = dependency.index >= 0 ? Objects.requireNonNullElse(this.inits.get(dependency.index), EMPTY_FUTURE) : EMPTY_FUTURE;
            }
            for (i = 0; i < node.getInterceptors().size(); ++i) {
                dependency = node.getInterceptors().get(i);
                dependencyInitializationFutures[node.getDependencyNodes().size() + i] = dependency.index >= 0 ? Objects.requireNonNullElse(this.inits.get(dependency.index), EMPTY_FUTURE) : EMPTY_FUTURE;
            }
            CompletionStage dependencyInitialization = CompletableFuture.allOf(dependencyInitializationFutures).exceptionallyCompose(e -> CompletableFuture.failedFuture(new DependencyInitializationFailedException()));
            this.inits.set(node.index, (CompletableFuture<Void>)((CompletableFuture)dependencyInitialization).thenAcceptAsync(v -> {
                try {
                    create.call();
                }
                catch (CompletionException e) {
                    Throwable patt22898$temp = e.getCause();
                    if (patt22898$temp instanceof RuntimeException) {
                        RuntimeException re = (RuntimeException)patt22898$temp;
                        throw re;
                    }
                    Throwable patt23025$temp = e.getCause();
                    if (patt23025$temp instanceof Error) {
                        Error re = (Error)patt23025$temp;
                        throw re;
                    }
                    throw e;
                }
                catch (Error | RuntimeException e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw new IllegalStateException(e);
                }
            }, this.executor));
        }

        private CompletableFuture<Void> initializeNode(NodeImpl<?> node, Lifecycle lifecycle) {
            int index = node.index;
            this.rootGraph.log.trace("Initializing node {} of class {} cancelled", (Object)index, lifecycle.getClass());
            return CompletableFuture.runAsync(() -> {
                try {
                    lifecycle.init();
                    TmpGraph tmpGraph = this;
                    synchronized (tmpGraph) {
                        this.initialized.set(node.index);
                    }
                    this.rootGraph.log.trace("Node Initializing {} of class {} complete", (Object)index, lifecycle.getClass());
                }
                catch (CancellationException e) {
                    this.rootGraph.log.trace("Node Initializing {} of class {} cancelled", (Object)index, lifecycle.getClass());
                    throw e;
                }
                catch (CompletionException ce) {
                    this.rootGraph.log.trace("Node Initializing {} of class {} error", new Object[]{index, lifecycle.getClass(), ce.getCause()});
                    throw ce;
                }
                catch (Error | RuntimeException e) {
                    this.rootGraph.log.trace("Node Initializing {} of class {} error", new Object[]{index, lifecycle.getClass(), e});
                    throw e;
                }
                catch (Throwable e) {
                    this.rootGraph.log.trace("Initializing node {} of class {} error", new Object[]{index, lifecycle.getClass(), e});
                    throw new IllegalStateException(e);
                }
            }, this.executor);
        }

        private CompletionStage<Void> init(BitSet root) {
            NodeImpl node;
            int i;
            final AtomicIntegerArray dependencies = new AtomicIntegerArray(this.tmpArray.length());
            var visitor = new Object(){
                private final BitSet processed;
                {
                    this.processed = new BitSet(tmpArray.length());
                }

                public void apply(NodeImpl<?> node) {
                    if (this.processed.get(node.index)) {
                        return;
                    }
                    this.processed.set(node.index);
                    for (NodeImpl<?> dependentNode : node.getDependentNodes()) {
                        if (dependentNode.isValueOf()) continue;
                        dependencies.incrementAndGet(dependentNode.index);
                        this.apply(dependentNode);
                    }
                    for (NodeImpl<?> interceptedNode : node.getIntercepts()) {
                        dependencies.incrementAndGet(interceptedNode.index);
                        this.apply(interceptedNode);
                    }
                }
            };
            List<Node<?>> nodes = this.rootGraph.draw.getNodes();
            for (i = 0; i < this.tmpArray.length(); ++i) {
                if (root.get(i)) {
                    dependencies.incrementAndGet(i);
                    node = (NodeImpl)nodes.get(i);
                    visitor.apply(node);
                    continue;
                }
                if (visitor.processed.get(i)) continue;
                dependencies.set(i, -1);
            }
            for (i = 0; i < dependencies.length(); ++i) {
                node = (NodeImpl)nodes.get(i);
                this.createNode(node, dependencies);
            }
            int startingFrom = Integer.MAX_VALUE;
            for (int i2 = 0; i2 < this.inits.length(); ++i2) {
                CompletableFuture<Void> init = this.inits.get(i2);
                if (init == null) continue;
                startingFrom = i2;
                break;
            }
            ArrayList<CompletionStage> inits = new ArrayList<CompletionStage>();
            for (int i3 = startingFrom; i3 < this.inits.length(); ++i3) {
                CompletableFuture<Void> init = this.inits.get(i3);
                if (init == null) continue;
                inits.add(init.exceptionallyCompose(error -> {
                    if (error instanceof DependencyInitializationFailedException) {
                        return EMPTY_FUTURE;
                    }
                    if (error instanceof CompletionException) {
                        CompletionException ce = (CompletionException)error;
                        if (ce.getCause() instanceof DependencyInitializationFailedException) {
                            return EMPTY_FUTURE;
                        }
                        return CompletableFuture.failedFuture(ce.getCause());
                    }
                    return CompletableFuture.failedFuture(error);
                }));
            }
            return CompletableFuture.allOf((CompletableFuture[])inits.toArray(CompletableFuture[]::new));
        }

        private static class DependencyInitializationFailedException
        extends RuntimeException {
            private DependencyInitializationFailedException() {
            }

            @Override
            public Throwable fillInStackTrace() {
                return this;
            }
        }
    }

    private static class TmpValueOf<T>
    implements ValueOf<T> {
        public volatile Graph tmpGraph;
        private final GraphImpl rootGraph;
        private final NodeImpl<? extends T> node;

        private TmpValueOf(NodeImpl<? extends T> node, Graph tmpGraph, GraphImpl rootGraph) {
            this.node = node;
            this.tmpGraph = tmpGraph;
            this.rootGraph = rootGraph;
        }

        @Override
        public T get() {
            return this.tmpGraph.get(this.node);
        }

        @Override
        public void refresh() {
            this.rootGraph.refresh(this.node);
        }
    }
}

