/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.application.graph;

import java.lang.management.ManagementFactory;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.tinkoff.kora.application.graph.ApplicationGraphDraw;
import ru.tinkoff.kora.application.graph.RefreshableGraph;

public final class KoraApplication {
    private KoraApplication() {
        throw new IllegalStateException();
    }

    public static RefreshableGraph run(Supplier<ApplicationGraphDraw> supplier) {
        long start = System.currentTimeMillis();
        ApplicationGraphDraw graphDraw = supplier.get();
        Logger log = LoggerFactory.getLogger(graphDraw.getRoot());
        log.debug("Application initializing...");
        try {
            RefreshableGraph graph = graphDraw.init();
            long end = System.currentTimeMillis();
            try {
                double uptime = (double)ManagementFactory.getRuntimeMXBean().getUptime() / 1000.0;
                log.info("Application initialized in {} ms (JVM running for {} s)", (Object)(end - start), (Object)uptime);
            }
            catch (Throwable ex) {
                log.info("Application initialized in {}ms", (Object)(end - start));
            }
            Thread thread = new Thread(() -> {
                try {
                    log.info("Application shutdown");
                    graph.release();
                    log.info("Application released");
                }
                catch (Exception e) {
                    log.error("Application release error", (Throwable)e);
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    System.exit(-1);
                }
            });
            thread.setName("kora-shutdown");
            Runtime.getRuntime().addShutdownHook(thread);
            return graph;
        }
        catch (Exception e) {
            log.error("Application initializing failed with error", (Throwable)e);
            e.printStackTrace();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            System.exit(-1);
            return null;
        }
    }
}

