/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.application.graph;

import java.util.Optional;
import java.util.function.Function;

public interface PromiseOf<T> {
    public Optional<T> get();

    default public <Q> PromiseOf<Q> map(Function<T, Q> mapper) {
        return () -> {
            Optional<T> value = this.get();
            return value.map(mapper);
        };
    }

    default public PromiseOf<Optional<T>> optional() {
        return this.map(Optional::ofNullable);
    }

    public static <T> PromiseOf<T> of(T value) {
        return () -> Optional.ofNullable(value);
    }

    public static <T> PromiseOf<T> promiseOfNull() {
        return Optional::empty;
    }

    public static <T> PromiseOf<Optional<T>> emptyOptional() {
        return Optional::empty;
    }
}

