/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.application.graph.internal.loom;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

public final class VirtualThreadExecutorHolder {
    @Nullable
    private static final Executor executor;
    @Nullable
    private static final ExecutorService executorService;
    private static final VirtualThreadStatus status;

    private VirtualThreadExecutorHolder() {
    }

    @Nonnull
    public static VirtualThreadStatus status() {
        return status;
    }

    @Nullable
    public static Executor executor() {
        return executor;
    }

    @Nullable
    public static ExecutorService executorService() {
        return executorService;
    }

    @Nullable
    private static ThreadFactory createLoomThreadFactory(String name) {
        try {
            MethodHandles.Lookup lookup = MethodHandles.publicLookup();
            Class<?> classLoomBuilder = lookup.findClass("java.lang.Thread$Builder$OfVirtual");
            MethodHandle methodLoomBuilder = lookup.findStatic(Thread.class, "ofVirtual", MethodType.methodType(classLoomBuilder));
            MethodHandle methodLoomName = lookup.findVirtual(classLoomBuilder, "name", MethodType.methodType(classLoomBuilder, String.class, Long.TYPE));
            MethodHandle methodLoomFactory = lookup.findVirtual(classLoomBuilder, "factory", MethodType.methodType(ThreadFactory.class));
            Object builder = methodLoomBuilder.invoke();
            builder = methodLoomName.invoke(builder, name, 1);
            ThreadFactory loomFactory = methodLoomFactory.invoke(builder);
            return Objects.requireNonNull(loomFactory);
        }
        catch (Throwable t) {
            return null;
        }
    }

    @Nullable
    private static Executor createExecutor(@Nullable ThreadFactory loomThreadFactory) {
        if (loomThreadFactory == null) {
            return null;
        }
        return runnable -> {
            try {
                Thread thread = loomThreadFactory.newThread(runnable);
                thread.start();
            }
            catch (Error | RuntimeException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new IllegalStateException(e);
            }
        };
    }

    @Nullable
    private static ExecutorService createExecutorService(@Nullable ThreadFactory loomThreadFactory) {
        if (loomThreadFactory == null) {
            return null;
        }
        try {
            MethodHandles.Lookup lookup = MethodHandles.publicLookup();
            MethodHandle methodLoomExecutor = lookup.findStatic(Executors.class, "newThreadPerTaskExecutor", MethodType.methodType(ExecutorService.class, ThreadFactory.class));
            return methodLoomExecutor.invoke(loomThreadFactory);
        }
        catch (Throwable t) {
            return null;
        }
    }

    static {
        String loomEnabled = System.getProperty("kora.loom.enabled");
        if (loomEnabled != null && !Boolean.parseBoolean(loomEnabled)) {
            executor = null;
            executorService = null;
            status = VirtualThreadStatus.DISABLED;
        } else {
            if (loomEnabled == null) {
                loomEnabled = "true";
            }
            if (Boolean.parseBoolean(loomEnabled)) {
                ThreadFactory loomThreadFactory = VirtualThreadExecutorHolder.createLoomThreadFactory("E-VThread-");
                executor = VirtualThreadExecutorHolder.createExecutor(loomThreadFactory);
                ThreadFactory loomServiceFactory = VirtualThreadExecutorHolder.createLoomThreadFactory("ES-VThread-");
                executorService = VirtualThreadExecutorHolder.createExecutorService(loomServiceFactory);
                status = executor != null ? VirtualThreadStatus.ENABLED : VirtualThreadStatus.UNAVAILABLE;
            } else {
                executor = null;
                executorService = null;
                status = VirtualThreadStatus.UNAVAILABLE;
            }
        }
    }

    public static enum VirtualThreadStatus {
        DISABLED,
        ENABLED,
        UNAVAILABLE;

    }
}

