/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.application.graph;

import java.util.Optional;
import java.util.function.Function;

public interface ValueOf<T> {
    public T get();

    public void refresh();

    default public <Q> ValueOf<Q> map(final Function<T, Q> mapper) {
        return new ValueOf<Q>(){

            @Override
            public Q get() {
                Object value = ValueOf.this.get();
                return mapper.apply(value);
            }

            @Override
            public void refresh() {
                ValueOf.this.refresh();
            }
        };
    }

    default public ValueOf<Optional<T>> optional() {
        return new ValueOf<Optional<T>>(){

            @Override
            public Optional<T> get() {
                return Optional.of(ValueOf.this.get());
            }

            @Override
            public void refresh() {
                ValueOf.this.refresh();
            }
        };
    }

    public static <T> ValueOf<Optional<T>> emptyOptional() {
        return new ValueOf<Optional<T>>(){

            @Override
            public Optional<T> get() {
                return Optional.empty();
            }

            @Override
            public void refresh() {
            }
        };
    }

    public static <T> ValueOf<T> valueOfNull() {
        return new ValueOf<T>(){

            @Override
            public T get() {
                return null;
            }

            @Override
            public void refresh() {
            }
        };
    }
}

