/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.cache.redis;

import jakarta.annotation.Nonnull;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.stream.Collectors;
import ru.tinkoff.kora.cache.AsyncCache;
import ru.tinkoff.kora.cache.redis.RedisCacheClient;
import ru.tinkoff.kora.cache.redis.RedisCacheConfig;
import ru.tinkoff.kora.cache.redis.RedisCacheKeyMapper;
import ru.tinkoff.kora.cache.redis.RedisCacheTelemetry;
import ru.tinkoff.kora.cache.redis.RedisCacheValueMapper;

public abstract class AbstractRedisCache<K, V>
implements AsyncCache<K, V> {
    private final String name;
    private final RedisCacheClient redisClient;
    private final RedisCacheTelemetry telemetry;
    private final byte[] keyPrefix;
    private final RedisCacheKeyMapper<K> keyMapper;
    private final RedisCacheValueMapper<V> valueMapper;
    private final Long expireAfterAccessMillis;
    private final Long expireAfterWriteMillis;

    protected AbstractRedisCache(String name, RedisCacheConfig config, RedisCacheClient redisClient, RedisCacheTelemetry telemetry, RedisCacheKeyMapper<K> keyMapper, RedisCacheValueMapper<V> valueMapper) {
        this.name = name;
        this.redisClient = redisClient;
        this.telemetry = telemetry;
        this.keyMapper = keyMapper;
        this.valueMapper = valueMapper;
        this.expireAfterAccessMillis = config.expireAfterAccess() == null ? null : Long.valueOf(config.expireAfterAccess().toMillis());
        Long l = this.expireAfterWriteMillis = config.expireAfterWrite() == null ? null : Long.valueOf(config.expireAfterWrite().toMillis());
        if (config.keyPrefix().isEmpty()) {
            this.keyPrefix = null;
        } else {
            byte[] prefixRaw = config.keyPrefix().getBytes(StandardCharsets.UTF_8);
            this.keyPrefix = new byte[prefixRaw.length + RedisCacheKeyMapper.DELIMITER.length];
            System.arraycopy(prefixRaw, 0, this.keyPrefix, 0, prefixRaw.length);
            System.arraycopy(RedisCacheKeyMapper.DELIMITER, 0, this.keyPrefix, prefixRaw.length, RedisCacheKeyMapper.DELIMITER.length);
        }
    }

    public V get(@Nonnull K key) {
        if (key == null) {
            return null;
        }
        RedisCacheTelemetry.TelemetryContext telemetryContext = this.telemetry.create("GET", this.name);
        try {
            byte[] keyAsBytes = this.mapKey(key);
            byte[] jsonAsBytes = this.expireAfterAccessMillis == null ? this.redisClient.get(keyAsBytes).toCompletableFuture().join() : this.redisClient.getex(keyAsBytes, (long)this.expireAfterAccessMillis).toCompletableFuture().join();
            V value = this.valueMapper.read(jsonAsBytes);
            telemetryContext.recordSuccess(value);
            return value;
        }
        catch (CompletionException e) {
            telemetryContext.recordFailure(e.getCause());
            return null;
        }
        catch (Exception e) {
            telemetryContext.recordFailure(e);
            return null;
        }
    }

    @Nonnull
    public Map<K, V> get(@Nonnull Collection<K> keys) {
        if (keys == null || keys.isEmpty()) {
            return null;
        }
        RedisCacheTelemetry.TelemetryContext telemetryContext = this.telemetry.create("GET_MANY", this.name);
        try {
            Map<Object, byte[]> keysByKeyBytes = keys.stream().collect(Collectors.toMap(k -> k, this::mapKey, (v1, v2) -> v2));
            byte[][] keysByBytes = (byte[][])keysByKeyBytes.values().toArray(x$0 -> new byte[x$0][]);
            Map<byte[], byte[]> valueByKeys = this.expireAfterAccessMillis == null ? this.redisClient.mget(keysByBytes).toCompletableFuture().join() : this.redisClient.getex(keysByBytes, (long)this.expireAfterAccessMillis).toCompletableFuture().join();
            HashMap keyToValue = new HashMap();
            for (Map.Entry<Object, byte[]> entry : keysByKeyBytes.entrySet()) {
                valueByKeys.forEach((k, v) -> {
                    if (Arrays.equals((byte[])entry.getValue(), k)) {
                        V value = this.valueMapper.read((byte[])v);
                        keyToValue.put(entry.getKey(), value);
                    }
                });
            }
            telemetryContext.recordSuccess(keyToValue);
            return keyToValue;
        }
        catch (CompletionException e) {
            telemetryContext.recordFailure(e.getCause());
            return Collections.emptyMap();
        }
        catch (Exception e) {
            telemetryContext.recordFailure(e);
            return Collections.emptyMap();
        }
    }

    @Nonnull
    public V put(@Nonnull K key, @Nonnull V value) {
        if (key == null || value == null) {
            return null;
        }
        RedisCacheTelemetry.TelemetryContext telemetryContext = this.telemetry.create("PUT", this.name);
        try {
            byte[] keyAsBytes = this.mapKey(key);
            byte[] valueAsBytes = this.valueMapper.write(value);
            if (this.expireAfterWriteMillis == null) {
                this.redisClient.set(keyAsBytes, valueAsBytes).toCompletableFuture().join();
            } else {
                this.redisClient.psetex(keyAsBytes, valueAsBytes, this.expireAfterWriteMillis).toCompletableFuture().join();
            }
            telemetryContext.recordSuccess();
            return value;
        }
        catch (CompletionException e) {
            telemetryContext.recordFailure(e.getCause());
            return value;
        }
        catch (Exception e) {
            telemetryContext.recordFailure(e);
            return value;
        }
    }

    @Nonnull
    public Map<K, V> put(@Nonnull Map<K, V> keyAndValues) {
        if (keyAndValues == null || keyAndValues.isEmpty()) {
            return Collections.emptyMap();
        }
        RedisCacheTelemetry.TelemetryContext telemetryContext = this.telemetry.create("PUT_MANY", this.name);
        try {
            HashMap<byte[], byte[]> keyAndValuesAsBytes = new HashMap<byte[], byte[]>();
            keyAndValues.forEach((k, v) -> {
                byte[] keyAsBytes = this.mapKey(k);
                byte[] valueAsBytes = this.valueMapper.write(v);
                keyAndValuesAsBytes.put(keyAsBytes, valueAsBytes);
            });
            if (this.expireAfterWriteMillis == null) {
                this.redisClient.mset(keyAndValuesAsBytes).toCompletableFuture().join();
            } else {
                this.redisClient.psetex(keyAndValuesAsBytes, this.expireAfterWriteMillis).toCompletableFuture().join();
            }
            telemetryContext.recordSuccess();
            return keyAndValues;
        }
        catch (CompletionException e) {
            telemetryContext.recordFailure(e.getCause());
            return keyAndValues;
        }
        catch (Exception e) {
            telemetryContext.recordFailure(e);
            return keyAndValues;
        }
    }

    public V computeIfAbsent(@Nonnull K key, @Nonnull Function<K, V> mappingFunction) {
        if (key == null) {
            return mappingFunction.apply(key);
        }
        RedisCacheTelemetry.TelemetryContext telemetryContext = this.telemetry.create("COMPUTE_IF_ABSENT", this.name);
        V fromCache = null;
        try {
            byte[] keyAsBytes = this.mapKey(key);
            byte[] jsonAsBytes = this.expireAfterAccessMillis == null ? this.redisClient.get(keyAsBytes).toCompletableFuture().join() : this.redisClient.getex(keyAsBytes, (long)this.expireAfterAccessMillis).toCompletableFuture().join();
            fromCache = this.valueMapper.read(jsonAsBytes);
        }
        catch (Exception keyAsBytes) {
            // empty catch block
        }
        if (fromCache != null) {
            telemetryContext.recordSuccess();
            return fromCache;
        }
        try {
            V value = mappingFunction.apply(key);
            if (value != null) {
                try {
                    byte[] keyAsBytes = this.mapKey(key);
                    byte[] valueAsBytes = this.valueMapper.write(value);
                    if (this.expireAfterWriteMillis == null) {
                        this.redisClient.set(keyAsBytes, valueAsBytes).toCompletableFuture().join();
                    } else {
                        this.redisClient.psetex(keyAsBytes, valueAsBytes, this.expireAfterWriteMillis).toCompletableFuture().join();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            telemetryContext.recordSuccess();
            return value;
        }
        catch (CompletionException e) {
            telemetryContext.recordFailure(e.getCause());
            return null;
        }
        catch (Exception e) {
            telemetryContext.recordFailure(e);
            return null;
        }
    }

    @Nonnull
    public Map<K, V> computeIfAbsent(@Nonnull Collection<K> keys, @Nonnull Function<Set<K>, Map<K, V>> mappingFunction) {
        if (keys == null || keys.isEmpty()) {
            return mappingFunction.apply(Collections.emptySet());
        }
        RedisCacheTelemetry.TelemetryContext telemetryContext = this.telemetry.create("COMPUTE_IF_ABSENT_MANY", this.name);
        HashMap<Object, Object> fromCache = new HashMap<Object, Object>();
        try {
            Map<Object, byte[]> keysByKeyBytes = keys.stream().collect(Collectors.toMap(k -> k, this::mapKey, (v1, v2) -> v2));
            byte[][] keysByBytes = (byte[][])keysByKeyBytes.values().toArray(x$0 -> new byte[x$0][]);
            Map<byte[], byte[]> valueByKeys = this.expireAfterAccessMillis == null ? this.redisClient.mget(keysByBytes).toCompletableFuture().join() : this.redisClient.getex(keysByBytes, (long)this.expireAfterAccessMillis).toCompletableFuture().join();
            for (Map.Entry<Object, byte[]> entry : keysByKeyBytes.entrySet()) {
                valueByKeys.forEach((k, v) -> {
                    if (Arrays.equals((byte[])entry.getValue(), k)) {
                        V value = this.valueMapper.read((byte[])v);
                        fromCache.put(entry.getKey(), value);
                    }
                });
            }
        }
        catch (Exception keysByKeyBytes) {
            // empty catch block
        }
        if (fromCache.size() == keys.size()) {
            telemetryContext.recordSuccess();
            return fromCache;
        }
        Set missingKeys = keys.stream().filter(k -> !fromCache.containsKey(k)).collect(Collectors.toSet());
        try {
            Map<Object, Object> values = mappingFunction.apply(missingKeys);
            if (!values.isEmpty()) {
                try {
                    HashMap<byte[], byte[]> keyAndValuesAsBytes = new HashMap<byte[], byte[]>();
                    values.forEach((k, v) -> {
                        byte[] keyAsBytes = this.mapKey(k);
                        byte[] valueAsBytes = this.valueMapper.write(v);
                        keyAndValuesAsBytes.put(keyAsBytes, valueAsBytes);
                    });
                    if (this.expireAfterWriteMillis == null) {
                        this.redisClient.mset(keyAndValuesAsBytes).toCompletableFuture().join();
                    } else {
                        this.redisClient.psetex(keyAndValuesAsBytes, this.expireAfterWriteMillis).toCompletableFuture().join();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            telemetryContext.recordSuccess();
            fromCache.putAll(values);
            return fromCache;
        }
        catch (CompletionException e) {
            telemetryContext.recordFailure(e.getCause());
            return fromCache;
        }
        catch (Exception e) {
            telemetryContext.recordFailure(e);
            return fromCache;
        }
    }

    public void invalidate(@Nonnull K key) {
        if (key != null) {
            byte[] keyAsBytes = this.mapKey(key);
            RedisCacheTelemetry.TelemetryContext telemetryContext = this.telemetry.create("INVALIDATE", this.name);
            try {
                this.redisClient.del(keyAsBytes).toCompletableFuture().join();
                telemetryContext.recordSuccess();
            }
            catch (CompletionException e) {
                telemetryContext.recordFailure(e.getCause());
            }
            catch (Exception e) {
                telemetryContext.recordFailure(e);
            }
        }
    }

    public void invalidate(@Nonnull Collection<K> keys) {
        if (keys != null && !keys.isEmpty()) {
            RedisCacheTelemetry.TelemetryContext telemetryContext = this.telemetry.create("INVALIDATE_MANY", this.name);
            try {
                byte[][] keysAsBytes = (byte[][])keys.stream().map(this::mapKey).toArray(x$0 -> new byte[x$0][]);
                this.redisClient.del(keysAsBytes).toCompletableFuture().join();
                telemetryContext.recordSuccess();
            }
            catch (CompletionException e) {
                telemetryContext.recordFailure(e.getCause());
            }
            catch (Exception e) {
                telemetryContext.recordFailure(e);
            }
        }
    }

    public void invalidateAll() {
        RedisCacheTelemetry.TelemetryContext telemetryContext = this.telemetry.create("INVALIDATE_ALL", this.name);
        try {
            this.redisClient.flushAll().toCompletableFuture().join();
            telemetryContext.recordSuccess();
        }
        catch (CompletionException e) {
            telemetryContext.recordFailure(e.getCause());
        }
        catch (Exception e) {
            telemetryContext.recordFailure(e);
        }
    }

    @Nonnull
    public CompletionStage<V> getAsync(@Nonnull K key) {
        if (key == null) {
            return CompletableFuture.completedFuture(null);
        }
        RedisCacheTelemetry.TelemetryContext telemetryContext = this.telemetry.create("GET", this.name);
        byte[] keyAsBytes = this.mapKey(key);
        CompletionStage<byte[]> responseCompletionStage = this.expireAfterAccessMillis == null ? this.redisClient.get(keyAsBytes) : this.redisClient.getex(keyAsBytes, (long)this.expireAfterAccessMillis);
        return responseCompletionStage.thenApply(jsonAsBytes -> {
            V value = this.valueMapper.read((byte[])jsonAsBytes);
            telemetryContext.recordSuccess(value);
            return value;
        }).exceptionally(e -> {
            telemetryContext.recordFailure((Throwable)e);
            return null;
        });
    }

    @Nonnull
    public CompletionStage<Map<K, V>> getAsync(@Nonnull Collection<K> keys) {
        if (keys == null || keys.isEmpty()) {
            return CompletableFuture.completedFuture(Collections.emptyMap());
        }
        RedisCacheTelemetry.TelemetryContext telemetryContext = this.telemetry.create("GET_MANY", this.name);
        Map<Object, byte[]> keysByKeyByte = keys.stream().collect(Collectors.toMap(k -> k, this::mapKey, (v1, v2) -> v2));
        byte[][] keysAsBytes = (byte[][])keysByKeyByte.values().toArray(x$0 -> new byte[x$0][]);
        CompletionStage<Map<byte[], byte[]>> responseCompletionStage = this.expireAfterAccessMillis == null ? this.redisClient.mget(keysAsBytes) : this.redisClient.getex(keysAsBytes, (long)this.expireAfterAccessMillis);
        return responseCompletionStage.thenApply(valuesByKeys -> {
            HashMap keyToValue = new HashMap();
            for (Map.Entry entry : keysByKeyByte.entrySet()) {
                valuesByKeys.forEach((k, v) -> {
                    if (Arrays.equals((byte[])entry.getValue(), k)) {
                        V value = this.valueMapper.read((byte[])v);
                        keyToValue.put(entry.getKey(), value);
                    }
                });
            }
            telemetryContext.recordSuccess(keyToValue);
            return keyToValue;
        }).exceptionally(e -> {
            telemetryContext.recordFailure((Throwable)e);
            return Collections.emptyMap();
        });
    }

    @Nonnull
    public CompletionStage<V> putAsync(@Nonnull K key, @Nonnull V value) {
        if (key == null) {
            return CompletableFuture.completedFuture(value);
        }
        RedisCacheTelemetry.TelemetryContext telemetryContext = this.telemetry.create("PUT", this.name);
        byte[] keyAsBytes = this.mapKey(key);
        byte[] valueAsBytes = this.valueMapper.write(value);
        CompletionStage<Boolean> responseCompletionStage = this.expireAfterWriteMillis == null ? this.redisClient.set(keyAsBytes, valueAsBytes) : this.redisClient.psetex(keyAsBytes, valueAsBytes, this.expireAfterWriteMillis);
        return responseCompletionStage.thenApply(r -> {
            telemetryContext.recordSuccess();
            return value;
        }).exceptionally(e -> {
            telemetryContext.recordFailure((Throwable)e);
            return value;
        });
    }

    @Nonnull
    public CompletionStage<Map<K, V>> putAsync(@Nonnull Map<K, V> keyAndValues) {
        if (keyAndValues == null || keyAndValues.isEmpty()) {
            return CompletableFuture.completedFuture(Collections.emptyMap());
        }
        RedisCacheTelemetry.TelemetryContext telemetryContext = this.telemetry.create("PUT_MANY", this.name);
        HashMap<byte[], byte[]> keyAndValuesAsBytes = new HashMap<byte[], byte[]>();
        keyAndValues.forEach((k, v) -> {
            byte[] keyAsBytes = this.mapKey(k);
            byte[] valueAsBytes = this.valueMapper.write(v);
            keyAndValuesAsBytes.put(keyAsBytes, valueAsBytes);
        });
        CompletionStage<Boolean> responseCompletionStage = this.expireAfterWriteMillis == null ? this.redisClient.mset(keyAndValuesAsBytes) : this.redisClient.psetex(keyAndValuesAsBytes, this.expireAfterAccessMillis);
        return responseCompletionStage.thenApply(r -> {
            telemetryContext.recordSuccess();
            return keyAndValues;
        }).exceptionally(e -> {
            telemetryContext.recordFailure((Throwable)e);
            return keyAndValues;
        });
    }

    public CompletionStage<V> computeIfAbsentAsync(@Nonnull K key, @Nonnull Function<K, CompletionStage<V>> mappingFunction) {
        if (key == null) {
            return CompletableFuture.completedFuture(null);
        }
        RedisCacheTelemetry.TelemetryContext telemetryContext = this.telemetry.create("COMPUTE_IF_ABSENT", this.name);
        byte[] keyAsBytes = this.mapKey(key);
        CompletionStage<byte[]> responseCompletionStage = this.expireAfterAccessMillis == null ? this.redisClient.get(keyAsBytes) : this.redisClient.getex(keyAsBytes, (long)this.expireAfterAccessMillis);
        return responseCompletionStage.thenApply(this.valueMapper::read).exceptionally(e -> null).thenCompose(fromCache -> {
            if (fromCache != null) {
                return CompletableFuture.completedFuture(fromCache);
            }
            return ((CompletionStage)mappingFunction.apply(key)).thenCompose(value -> {
                if (value == null) {
                    return CompletableFuture.completedFuture(null);
                }
                byte[] valueAsBytes = this.valueMapper.write(value);
                CompletionStage<Boolean> putFutureResponse = this.expireAfterWriteMillis == null ? this.redisClient.set(keyAsBytes, valueAsBytes) : this.redisClient.psetex(keyAsBytes, valueAsBytes, this.expireAfterWriteMillis);
                return putFutureResponse.thenApply(v -> {
                    telemetryContext.recordSuccess();
                    return value;
                });
            }).exceptionally(e -> {
                telemetryContext.recordFailure((Throwable)e);
                return null;
            });
        });
    }

    @Nonnull
    public CompletionStage<Map<K, V>> computeIfAbsentAsync(@Nonnull Collection<K> keys, @Nonnull Function<Set<K>, CompletionStage<Map<K, V>>> mappingFunction) {
        if (keys == null || keys.isEmpty()) {
            return CompletableFuture.completedFuture(Collections.emptyMap());
        }
        RedisCacheTelemetry.TelemetryContext telemetryContext = this.telemetry.create("COMPUTE_IF_ABSENT_MANY", this.name);
        Map<Object, byte[]> keysByKeyBytes = keys.stream().collect(Collectors.toMap(k -> k, this::mapKey, (v1, v2) -> v2));
        byte[][] keysByBytes = (byte[][])keysByKeyBytes.values().toArray(x$0 -> new byte[x$0][]);
        CompletionStage<Map<byte[], byte[]>> responseCompletionStage = this.expireAfterAccessMillis == null ? this.redisClient.mget(keysByBytes) : this.redisClient.getex(keysByBytes, (long)this.expireAfterAccessMillis);
        return responseCompletionStage.thenApply(valueByKeys -> {
            HashMap fromCache = new HashMap();
            for (Map.Entry entry : keysByKeyBytes.entrySet()) {
                valueByKeys.forEach((k, v) -> {
                    if (Arrays.equals((byte[])entry.getValue(), k)) {
                        V value = this.valueMapper.read((byte[])v);
                        fromCache.put(entry.getKey(), value);
                    }
                });
            }
            return fromCache;
        }).exceptionally(e -> null).thenCompose(fromCache -> {
            if (fromCache.size() == keys.size()) {
                return CompletableFuture.completedFuture(fromCache);
            }
            Set missingKeys = keys.stream().filter(k -> !fromCache.containsKey(k)).collect(Collectors.toSet());
            return ((CompletionStage)mappingFunction.apply(missingKeys)).thenCompose(values -> {
                if (values.isEmpty()) {
                    return CompletableFuture.completedFuture(fromCache);
                }
                HashMap<byte[], byte[]> keyAndValuesAsBytes = new HashMap<byte[], byte[]>();
                values.forEach((k, v) -> {
                    byte[] keyAsBytes = this.mapKey(k);
                    byte[] valueAsBytes = this.valueMapper.write(v);
                    keyAndValuesAsBytes.put(keyAsBytes, valueAsBytes);
                });
                CompletionStage<Boolean> putCompletionStage = this.expireAfterAccessMillis == null ? this.redisClient.mset(keyAndValuesAsBytes) : this.redisClient.psetex(keyAndValuesAsBytes, this.expireAfterAccessMillis);
                return putCompletionStage.thenApply(v -> {
                    telemetryContext.recordSuccess();
                    fromCache.putAll(values);
                    return fromCache;
                });
            }).exceptionally(e -> {
                telemetryContext.recordFailure((Throwable)e);
                return null;
            });
        });
    }

    @Nonnull
    public CompletionStage<Boolean> invalidateAsync(@Nonnull K key) {
        if (key == null) {
            return CompletableFuture.completedFuture(false);
        }
        RedisCacheTelemetry.TelemetryContext telemetryContext = this.telemetry.create("INVALIDATE", this.name);
        byte[] keyAsBytes = this.mapKey(key);
        return this.redisClient.del(keyAsBytes).thenApply(r -> {
            telemetryContext.recordSuccess();
            return true;
        }).exceptionally(e -> {
            telemetryContext.recordFailure((Throwable)e);
            return false;
        });
    }

    public CompletionStage<Boolean> invalidateAsync(@Nonnull Collection<K> keys) {
        if (keys == null || keys.isEmpty()) {
            return CompletableFuture.completedFuture(false);
        }
        RedisCacheTelemetry.TelemetryContext telemetryContext = this.telemetry.create("INVALIDATE_MANY", this.name);
        byte[][] keyAsBytes = (byte[][])keys.stream().distinct().map(this::mapKey).toArray(x$0 -> new byte[x$0][]);
        return this.redisClient.del(keyAsBytes).thenApply(r -> {
            telemetryContext.recordSuccess();
            return true;
        }).exceptionally(e -> {
            telemetryContext.recordFailure((Throwable)e);
            return false;
        });
    }

    @Nonnull
    public CompletionStage<Boolean> invalidateAllAsync() {
        RedisCacheTelemetry.TelemetryContext telemetryContext = this.telemetry.create("INVALIDATE_ALL", this.name);
        return this.redisClient.flushAll().thenApply(r -> {
            telemetryContext.recordSuccess();
            return r;
        }).exceptionally(e -> {
            telemetryContext.recordFailure((Throwable)e);
            return false;
        });
    }

    private byte[] mapKey(K key) {
        byte[] suffixAsBytes = (byte[])this.keyMapper.apply(key);
        if (this.keyPrefix == null) {
            return suffixAsBytes;
        }
        byte[] keyAsBytes = new byte[this.keyPrefix.length + suffixAsBytes.length];
        System.arraycopy(this.keyPrefix, 0, keyAsBytes, 0, this.keyPrefix.length);
        System.arraycopy(suffixAsBytes, 0, keyAsBytes, this.keyPrefix.length, suffixAsBytes.length);
        return keyAsBytes;
    }
}

