/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.cache.redis;

import jakarta.annotation.Nonnull;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import ru.tinkoff.kora.application.graph.Lifecycle;

public interface RedisCacheClient
extends Lifecycle {
    @Nonnull
    public CompletionStage<byte[]> get(byte[] var1);

    @Nonnull
    public CompletionStage<Map<byte[], byte[]>> mget(byte[][] var1);

    @Nonnull
    public CompletionStage<byte[]> getex(byte[] var1, long var2);

    @Nonnull
    default public CompletionStage<Map<byte[], byte[]>> getex(byte[][] keys, long expireAfterMillis) {
        CompletableFuture[] values = (CompletableFuture[])Arrays.stream(keys).map(k -> this.getex((byte[])k, expireAfterMillis).thenApply(v -> Map.entry(k, v)).toCompletableFuture()).toArray(CompletableFuture[]::new);
        return CompletableFuture.allOf(values).thenApply(v -> Arrays.stream(values).map(f -> (Map.Entry)f.join()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
    }

    @Nonnull
    public CompletionStage<Boolean> set(byte[] var1, byte[] var2);

    @Nonnull
    public CompletionStage<Boolean> mset(Map<byte[], byte[]> var1);

    @Nonnull
    public CompletionStage<Boolean> psetex(byte[] var1, byte[] var2, long var3);

    @Nonnull
    default public CompletionStage<Boolean> psetex(Map<byte[], byte[]> keyAndValue, long expireAfterMillis) {
        CompletableFuture[] values = (CompletableFuture[])keyAndValue.entrySet().stream().map(e -> this.psetex((byte[])e.getKey(), (byte[])e.getValue(), expireAfterMillis).toCompletableFuture()).toArray(CompletableFuture[]::new);
        return CompletableFuture.allOf(values).thenApply(v -> true);
    }

    @Nonnull
    public CompletionStage<Long> del(byte[] var1);

    @Nonnull
    public CompletionStage<Long> del(byte[][] var1);

    @Nonnull
    public CompletionStage<Boolean> flushAll();
}

