/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.cache.redis;

import jakarta.annotation.Nullable;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import ru.tinkoff.kora.cache.redis.RedisCacheKeyMapper;
import ru.tinkoff.kora.cache.redis.RedisCacheTelemetry;
import ru.tinkoff.kora.cache.redis.RedisCacheValueMapper;
import ru.tinkoff.kora.cache.telemetry.CacheMetrics;
import ru.tinkoff.kora.cache.telemetry.CacheTracer;
import ru.tinkoff.kora.common.DefaultComponent;
import ru.tinkoff.kora.json.common.JsonCommonModule;
import ru.tinkoff.kora.json.common.JsonReader;
import ru.tinkoff.kora.json.common.JsonWriter;
import ru.tinkoff.kora.json.common.annotation.Json;

public interface RedisCacheMapperModule
extends JsonCommonModule {
    @DefaultComponent
    default public RedisCacheTelemetry redisCacheTelemetry(@Nullable CacheMetrics metrics, @Nullable CacheTracer tracer) {
        return new RedisCacheTelemetry(metrics, tracer);
    }

    @Json
    @DefaultComponent
    default public <V> RedisCacheValueMapper<V> jsonRedisValueMapper(final JsonWriter<V> jsonWriter, final JsonReader<V> jsonReader) {
        return new RedisCacheValueMapper<V>(){

            @Override
            public byte[] write(V value) {
                try {
                    return jsonWriter.toByteArray(value);
                }
                catch (IOException e) {
                    throw new IllegalStateException(e.getMessage());
                }
            }

            @Override
            public V read(byte[] serializedValue) {
                try {
                    return serializedValue == null ? null : jsonReader.read(serializedValue);
                }
                catch (IOException e) {
                    throw new IllegalStateException(e.getMessage());
                }
            }
        };
    }

    @DefaultComponent
    default public RedisCacheValueMapper<String> stringRedisValueMapper() {
        return new RedisCacheValueMapper<String>(){

            @Override
            public byte[] write(String value) {
                return value.getBytes(StandardCharsets.UTF_8);
            }

            @Override
            public String read(byte[] serializedValue) {
                return serializedValue == null ? null : new String(serializedValue, StandardCharsets.UTF_8);
            }
        };
    }

    @DefaultComponent
    default public RedisCacheValueMapper<byte[]> bytesRedisValueMapper() {
        return new RedisCacheValueMapper<byte[]>(){

            @Override
            public byte[] write(byte[] value) {
                return value;
            }

            @Override
            public byte[] read(byte[] serializedValue) {
                return serializedValue;
            }
        };
    }

    @DefaultComponent
    default public RedisCacheValueMapper<Integer> intRedisValueMapper(final RedisCacheKeyMapper<Integer> keyMapper) {
        return new RedisCacheValueMapper<Integer>(){

            @Override
            public byte[] write(Integer value) {
                return (byte[])keyMapper.apply(value);
            }

            @Override
            public Integer read(byte[] serializedValue) {
                if (serializedValue == null) {
                    return null;
                }
                return Integer.valueOf(new String(serializedValue, StandardCharsets.UTF_8));
            }
        };
    }

    @DefaultComponent
    default public RedisCacheValueMapper<Long> longRedisValueMapper(final RedisCacheKeyMapper<Long> keyMapper) {
        return new RedisCacheValueMapper<Long>(){

            @Override
            public byte[] write(Long value) {
                return (byte[])keyMapper.apply(value);
            }

            @Override
            public Long read(byte[] serializedValue) {
                if (serializedValue == null) {
                    return null;
                }
                return Long.valueOf(new String(serializedValue, StandardCharsets.UTF_8));
            }
        };
    }

    @DefaultComponent
    default public RedisCacheValueMapper<BigInteger> bigIntRedisValueMapper(final RedisCacheKeyMapper<BigInteger> keyMapper) {
        return new RedisCacheValueMapper<BigInteger>(){

            @Override
            public byte[] write(BigInteger value) {
                return (byte[])keyMapper.apply(value);
            }

            @Override
            public BigInteger read(byte[] serializedValue) {
                if (serializedValue == null) {
                    return null;
                }
                return new BigInteger(new String(serializedValue, StandardCharsets.UTF_8));
            }
        };
    }

    @DefaultComponent
    default public RedisCacheValueMapper<UUID> uuidRedisValueMapper(final RedisCacheKeyMapper<UUID> keyMapper) {
        return new RedisCacheValueMapper<UUID>(){

            @Override
            public byte[] write(UUID value) {
                return (byte[])keyMapper.apply(value);
            }

            @Override
            public UUID read(byte[] serializedValue) {
                return UUID.fromString(new String(serializedValue, StandardCharsets.UTF_8));
            }
        };
    }

    @DefaultComponent
    default public RedisCacheKeyMapper<Integer> intRedisKeyMapper() {
        return c -> String.valueOf(c).getBytes(StandardCharsets.UTF_8);
    }

    @DefaultComponent
    default public RedisCacheKeyMapper<Long> longRedisKeyMapper() {
        return c -> String.valueOf(c).getBytes(StandardCharsets.UTF_8);
    }

    @DefaultComponent
    default public RedisCacheKeyMapper<BigInteger> bigIntRedisKeyMapper() {
        return c -> c.toString().getBytes(StandardCharsets.UTF_8);
    }

    @DefaultComponent
    default public RedisCacheKeyMapper<UUID> uuidRedisKeyMapper() {
        return c -> c.toString().getBytes(StandardCharsets.UTF_8);
    }

    @DefaultComponent
    default public RedisCacheKeyMapper<String> stringRedisKeyMapper() {
        return c -> c.getBytes(StandardCharsets.UTF_8);
    }
}

