/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.cache.redis.lettuce;

import io.lettuce.core.protocol.ProtocolVersion;
import jakarta.annotation.Nullable;
import java.time.Duration;
import java.util.Arrays;

public record LettuceClientConfig(String uri, @Nullable Integer database, @Nullable String user, @Nullable String password, @Nullable String protocol, @Nullable Duration socketTimeout, @Nullable Duration commandTimeout) {
    public LettuceClientConfig(String uri, @Nullable Integer database, @Nullable String user, @Nullable String password, @Nullable String protocol, @Nullable Duration socketTimeout, @Nullable Duration commandTimeout) {
        this.uri = uri;
        this.database = database;
        this.user = user;
        this.password = password;
        this.protocol = protocol == null ? ProtocolVersion.RESP3.name() : protocol;
        this.commandTimeout = commandTimeout == null ? Duration.ofSeconds(60L) : commandTimeout;
        this.socketTimeout = socketTimeout == null ? Duration.ofSeconds(10L) : socketTimeout;
    }

    public ProtocolVersion protocolVersion() {
        if (ProtocolVersion.RESP3.name().equals(this.protocol)) {
            return ProtocolVersion.RESP3;
        }
        if (ProtocolVersion.RESP2.name().equals(this.protocol)) {
            return ProtocolVersion.RESP2;
        }
        throw new IllegalArgumentException("Unknown protocol value '" + this.protocol + "', expected value one of: " + Arrays.toString(ProtocolVersion.values()));
    }
}

