/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.cache.redis.lettuce;

import io.lettuce.core.AbstractRedisClient;
import io.lettuce.core.ClientOptions;
import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisURI;
import io.lettuce.core.SocketOptions;
import io.lettuce.core.TimeoutOptions;
import io.lettuce.core.cluster.ClusterClientOptions;
import io.lettuce.core.cluster.RedisClusterClient;
import io.lettuce.core.cluster.RedisClusterURIUtil;
import io.lettuce.core.protocol.ProtocolVersion;
import jakarta.annotation.Nonnull;
import java.net.URI;
import java.time.Duration;
import java.util.List;
import ru.tinkoff.kora.cache.redis.lettuce.LettuceClientConfig;

public final class LettuceClientFactory {
    @Nonnull
    public AbstractRedisClient build(LettuceClientConfig config) {
        Duration commandTimeout = config.commandTimeout();
        Duration socketTimeout = config.socketTimeout();
        ProtocolVersion protocolVersion = config.protocolVersion();
        List<RedisURI> mappedRedisUris = LettuceClientFactory.buildRedisURI(config);
        return mappedRedisUris.size() == 1 ? LettuceClientFactory.buildRedisClientInternal(mappedRedisUris.get(0), commandTimeout, socketTimeout, protocolVersion) : LettuceClientFactory.buildRedisClusterClientInternal(mappedRedisUris, commandTimeout, socketTimeout, protocolVersion);
    }

    @Nonnull
    public RedisClusterClient buildRedisClusterClient(LettuceClientConfig config) {
        Duration commandTimeout = config.commandTimeout();
        Duration socketTimeout = config.socketTimeout();
        ProtocolVersion protocolVersion = config.protocolVersion();
        List<RedisURI> mappedRedisUris = LettuceClientFactory.buildRedisURI(config);
        return LettuceClientFactory.buildRedisClusterClientInternal(mappedRedisUris, commandTimeout, socketTimeout, protocolVersion);
    }

    @Nonnull
    public RedisClient buildRedisClient(LettuceClientConfig config) {
        Duration commandTimeout = config.commandTimeout();
        Duration socketTimeout = config.socketTimeout();
        ProtocolVersion protocolVersion = config.protocolVersion();
        List<RedisURI> mappedRedisUris = LettuceClientFactory.buildRedisURI(config);
        return LettuceClientFactory.buildRedisClientInternal(mappedRedisUris.get(0), commandTimeout, socketTimeout, protocolVersion);
    }

    @Nonnull
    private static RedisClusterClient buildRedisClusterClientInternal(List<RedisURI> redisURIs, Duration commandTimeout, Duration socketTimeout, ProtocolVersion protocolVersion) {
        RedisClusterClient client = RedisClusterClient.create(redisURIs);
        client.setOptions(ClusterClientOptions.builder().autoReconnect(true).publishOnScheduler(true).suspendReconnectOnProtocolFailure(false).disconnectedBehavior(ClientOptions.DisconnectedBehavior.DEFAULT).protocolVersion(protocolVersion).timeoutOptions(TimeoutOptions.builder().connectionTimeout().fixedTimeout(commandTimeout).timeoutCommands(true).build()).socketOptions(SocketOptions.builder().keepAlive(true).connectTimeout(socketTimeout).build()).build());
        return client;
    }

    @Nonnull
    private static RedisClient buildRedisClientInternal(RedisURI redisURI, Duration commandTimeout, Duration socketTimeout, ProtocolVersion protocolVersion) {
        RedisClient client = RedisClient.create((RedisURI)redisURI);
        client.setOptions(ClientOptions.builder().autoReconnect(true).publishOnScheduler(true).suspendReconnectOnProtocolFailure(false).disconnectedBehavior(ClientOptions.DisconnectedBehavior.REJECT_COMMANDS).protocolVersion(protocolVersion).timeoutOptions(TimeoutOptions.builder().connectionTimeout().fixedTimeout(commandTimeout).timeoutCommands(true).build()).socketOptions(SocketOptions.builder().keepAlive(true).connectTimeout(socketTimeout).build()).build());
        return client;
    }

    private static List<RedisURI> buildRedisURI(LettuceClientConfig config) {
        String uri = config.uri();
        Integer database = config.database();
        String user = config.user();
        String password = config.password();
        List redisURIS = RedisClusterURIUtil.toRedisURIs((URI)URI.create(uri));
        return redisURIS.stream().map(redisURI -> {
            RedisURI.Builder builder = RedisURI.builder((RedisURI)redisURI);
            if (database != null) {
                builder = builder.withDatabase(database.intValue());
            }
            if (user != null && password != null) {
                builder = builder.withAuthentication(user, (CharSequence)password);
            } else if (password != null) {
                builder = builder.withPassword((CharSequence)password);
            }
            return builder.build();
        }).toList();
    }
}

