/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.cache.redis.lettuce;

import io.lettuce.core.AbstractRedisClient;
import io.lettuce.core.FlushMode;
import io.lettuce.core.GetExArgs;
import io.lettuce.core.KeyValue;
import io.lettuce.core.RedisClient;
import io.lettuce.core.Value;
import io.lettuce.core.api.StatefulConnection;
import io.lettuce.core.api.async.RedisAsyncCommands;
import io.lettuce.core.api.async.RedisKeyAsyncCommands;
import io.lettuce.core.api.async.RedisServerAsyncCommands;
import io.lettuce.core.api.async.RedisStringAsyncCommands;
import io.lettuce.core.cluster.RedisClusterClient;
import io.lettuce.core.cluster.api.StatefulRedisClusterConnection;
import io.lettuce.core.cluster.api.async.RedisAdvancedClusterAsyncCommands;
import io.lettuce.core.codec.ByteArrayCodec;
import io.lettuce.core.codec.RedisCodec;
import jakarta.annotation.Nonnull;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.tinkoff.kora.cache.redis.RedisCacheClient;
import ru.tinkoff.kora.common.util.TimeUtils;

final class LettuceRedisCacheClient
implements RedisCacheClient {
    private static final Logger logger = LoggerFactory.getLogger(LettuceRedisCacheClient.class);
    private final AbstractRedisClient redisClient;
    private StatefulConnection<byte[], byte[]> connection;
    private RedisStringAsyncCommands<byte[], byte[]> stringCommands;
    private RedisServerAsyncCommands<byte[], byte[]> serverCommands;
    private RedisKeyAsyncCommands<byte[], byte[]> keyCommands;

    LettuceRedisCacheClient(AbstractRedisClient redisClient) {
        this.redisClient = redisClient;
    }

    @Override
    @Nonnull
    public CompletionStage<byte[]> get(byte[] key) {
        return this.stringCommands.get((Object)key);
    }

    @Override
    @Nonnull
    public CompletionStage<Map<byte[], byte[]>> mget(byte[][] keys) {
        return this.stringCommands.mget((Object[])keys).thenApply(r -> r.stream().collect(Collectors.toMap(KeyValue::getKey, Value::getValue)));
    }

    @Override
    @Nonnull
    public CompletionStage<byte[]> getex(byte[] key, long expireAfterMillis) {
        return this.stringCommands.getex((Object)key, GetExArgs.Builder.ex((Duration)Duration.ofMillis(expireAfterMillis)));
    }

    @Override
    @Nonnull
    public CompletionStage<Boolean> set(byte[] key, byte[] value) {
        return this.stringCommands.set((Object)key, (Object)value).thenApply(r -> true);
    }

    @Override
    public CompletionStage<Boolean> mset(Map<byte[], byte[]> keyAndValue) {
        return this.stringCommands.mset(keyAndValue).thenApply(r -> true);
    }

    @Override
    @Nonnull
    public CompletionStage<Boolean> psetex(byte[] key, byte[] value, long expireAfterMillis) {
        return this.stringCommands.psetex((Object)key, expireAfterMillis, (Object)value).thenApply(r -> true);
    }

    @Override
    @Nonnull
    public CompletionStage<Long> del(byte[] key) {
        return this.keyCommands.del((Object[])new byte[][]{key});
    }

    @Override
    @Nonnull
    public CompletionStage<Long> del(byte[][] keys) {
        return this.keyCommands.del((Object[])keys);
    }

    @Override
    @Nonnull
    public CompletionStage<Boolean> flushAll() {
        return this.serverCommands.flushall(FlushMode.SYNC).thenApply(r -> true);
    }

    public void init() {
        logger.debug("Redis Client (Lettuce) starting...");
        long started = TimeUtils.started();
        AbstractRedisClient abstractRedisClient = this.redisClient;
        if (abstractRedisClient instanceof RedisClient) {
            RedisAsyncCommands asyncCommands;
            RedisClient rc = (RedisClient)abstractRedisClient;
            this.connection = redisConnection = rc.connect((RedisCodec)new ByteArrayCodec());
            this.keyCommands = asyncCommands = redisConnection.async();
            this.serverCommands = asyncCommands;
            this.stringCommands = asyncCommands;
        } else {
            redisConnection = this.redisClient;
            if (redisConnection instanceof RedisClusterClient) {
                RedisAdvancedClusterAsyncCommands asyncCommands;
                StatefulRedisClusterConnection clusterConnection;
                RedisClusterClient rcc = (RedisClusterClient)redisConnection;
                this.connection = clusterConnection = rcc.connect((RedisCodec)new ByteArrayCodec());
                this.keyCommands = asyncCommands = clusterConnection.async();
                this.serverCommands = asyncCommands;
                this.stringCommands = asyncCommands;
            } else {
                throw new UnsupportedOperationException("Unknown Redis Client: " + this.redisClient.getClass());
            }
        }
        logger.info("Redis Client (Lettuce) started in {}", (Object)TimeUtils.tookForLogging((long)started));
    }

    public void release() {
        logger.debug("Redis Client (Lettuce) stopping...");
        long started = TimeUtils.started();
        this.connection.close();
        logger.info("Redis Client (Lettuce) stopped in {}", (Object)TimeUtils.tookForLogging((long)started));
    }
}

