/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.config.annotation.processor;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import com.squareup.javapoet.WildcardTypeName;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.JavaFileObject;
import ru.tinkoff.kora.annotation.processor.common.AnnotationUtils;
import ru.tinkoff.kora.annotation.processor.common.CommonUtils;
import ru.tinkoff.kora.annotation.processor.common.FieldFactory;
import ru.tinkoff.kora.annotation.processor.common.NameUtils;
import ru.tinkoff.kora.annotation.processor.common.ProcessingError;
import ru.tinkoff.kora.annotation.processor.common.RecordClassBuilder;
import ru.tinkoff.kora.common.util.Either;
import ru.tinkoff.kora.config.annotation.processor.ConfigClassNames;
import ru.tinkoff.kora.config.annotation.processor.ConfigUtils;

public class ConfigParserGenerator {
    private final Types types;
    private final Elements elements;
    private final ProcessingEnvironment processingEnv;
    private static final Map<TypeName, CodeBlock> supportedTypes = Map.ofEntries(Map.entry(TypeName.INT, CodeBlock.of((String)"value.asNumber().intValue()", (Object[])new Object[0])), Map.entry(TypeName.INT.box(), CodeBlock.of((String)"value.asNumber().intValue()", (Object[])new Object[0])), Map.entry(TypeName.LONG, CodeBlock.of((String)"value.asNumber().longValue()", (Object[])new Object[0])), Map.entry(TypeName.LONG.box(), CodeBlock.of((String)"value.asNumber().longValue()", (Object[])new Object[0])), Map.entry(TypeName.DOUBLE, CodeBlock.of((String)"value.asNumber().doubleValue()", (Object[])new Object[0])), Map.entry(TypeName.DOUBLE.box(), CodeBlock.of((String)"value.asNumber().doubleValue()", (Object[])new Object[0])), Map.entry(TypeName.BOOLEAN, CodeBlock.of((String)"value.asBoolean()", (Object[])new Object[0])), Map.entry(TypeName.BOOLEAN.box(), CodeBlock.of((String)"value.asBoolean()", (Object[])new Object[0])), Map.entry(ClassName.get(String.class), CodeBlock.of((String)"value.asString()", (Object[])new Object[0])));

    public ConfigParserGenerator(ProcessingEnvironment processingEnv) {
        this.types = processingEnv.getTypeUtils();
        this.elements = processingEnv.getElementUtils();
        this.processingEnv = processingEnv;
    }

    public Either<Void, List<ProcessingError>> generateForInterface(RoundEnvironment roundEnv, DeclaredType targetType) {
        TypeElement element = (TypeElement)targetType.asElement();
        Either<List<ConfigUtils.ConfigField>, List<ProcessingError>> f = ConfigUtils.parseFields(this.types, element);
        if (f.isRight()) {
            return Either.right((Object)((List)f.right()));
        }
        String typeName = NameUtils.generatedType((Element)element, (ClassName)ConfigClassNames.configValueExtractor);
        TypeSpec.Builder typeBuilder = TypeSpec.classBuilder((String)typeName).addOriginatingElement((Element)element).addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)ConfigClassNames.configValueExtractor, (TypeName[])new TypeName[]{TypeName.get((TypeMirror)targetType)})).addAnnotation(AnnotationUtils.generated(ConfigParserGenerator.class)).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
        List fields = Objects.requireNonNull((List)f.left());
        TypeSpec defaultsType = this.buildDefaultsType(targetType, element, fields);
        String packageName = this.elements.getPackageOf(element).getQualifiedName().toString();
        ClassName implClassName = ClassName.get((String)packageName, (String)typeName, (String[])new String[]{element.getSimpleName().toString() + "_Impl"});
        if (defaultsType != null) {
            typeBuilder.addType(defaultsType);
            ClassName defaultImplClassName = ClassName.get((String)packageName, (String)typeName, (String[])new String[]{element.getSimpleName().toString() + "_Defaults"});
            FieldSpec.Builder field = FieldSpec.builder((TypeName)defaultImplClassName, (String)"DEFAULTS", (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("new $T()", new Object[]{defaultImplClassName});
            typeBuilder.addField(field.build());
        }
        MethodSpec constructor = this.buildConstructor(typeBuilder, fields);
        typeBuilder.addMethod(constructor);
        typeBuilder.addMethod(this.buildExtractMethod(element, TypeName.get((TypeMirror)targetType), implClassName, fields));
        for (ConfigUtils.ConfigField field : fields) {
            typeBuilder.addField(FieldSpec.builder((TypeName)ConfigClassNames.pathElementKey, (String)("_" + field.name() + "_path"), (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer(CodeBlock.of((String)"$T.get($S)", (Object[])new Object[]{ConfigClassNames.pathElement, field.name()})).build());
            MethodSpec parseFieldMethod = this.buildParseField(element, field);
            typeBuilder.addMethod(parseFieldMethod);
        }
        TypeSpec parserType = typeBuilder.build();
        JavaFile javaFile = JavaFile.builder((String)packageName, (TypeSpec)typeBuilder.build()).build();
        String fileName = packageName.isEmpty() ? parserType.name : packageName + "." + parserType.name;
        try {
            StringWriter sw = new StringWriter();
            javaFile.writeTo((Appendable)sw);
            Object content = sw.toString();
            int i = ((String)content).lastIndexOf(125);
            content = ((String)content).substring(0, i);
            content = (String)content + "\n" + this.buildConfigInterfaceImplementation(element, fields) + "\n}\n";
            JavaFileObject filerSourceFile = this.processingEnv.getFiler().createSourceFile(fileName, element);
            try (Writer writer = filerSourceFile.openWriter();){
                writer.write((String)content);
            }
            catch (Exception e) {
                try {
                    filerSourceFile.delete();
                }
                catch (Exception e1) {
                    e.addSuppressed(e1);
                }
                throw e;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return Either.left(null);
    }

    private MethodSpec buildExtractMethod(TypeElement element, TypeName typeName, ClassName implClassName, List<ConfigUtils.ConfigField> fields) {
        List constructors = CommonUtils.findConstructors((TypeElement)element, m -> m.contains((Object)Modifier.PUBLIC));
        ExecutableElement emptyConstructor = constructors.stream().filter(e -> e.getParameters().isEmpty()).findFirst().orElse(null);
        ExecutableElement nonEmptyConstructor = constructors.stream().filter(e -> !e.getParameters().isEmpty()).findFirst().orElse(null);
        Set constructorParams = nonEmptyConstructor == null ? Set.of() : nonEmptyConstructor.getParameters().stream().map(VariableElement::getSimpleName).map(Objects::toString).collect(Collectors.toSet());
        MethodSpec.Builder rootParse = MethodSpec.methodBuilder((String)"extract").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(typeName);
        rootParse.addParameter((TypeName)ParameterizedTypeName.get((ClassName)ConfigClassNames.configValue, (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf((TypeName)TypeName.OBJECT)}), "_sourceValue", new Modifier[0]);
        rootParse.beginControlFlow("if (_sourceValue instanceof $T.NullValue _nullValue)", new Object[]{ConfigClassNames.configValue});
        AnnotationMirror annotation = AnnotationUtils.findAnnotation((Element)element, (ClassName)ConfigClassNames.configValueExtractorAnnotation);
        if (annotation == null || Boolean.TRUE.equals(Objects.requireNonNullElse((Boolean)AnnotationUtils.parseAnnotationValueWithoutDefault((AnnotationMirror)annotation, (String)"mapNullAsEmptyObject"), true))) {
            rootParse.addStatement("_sourceValue = new $T.ObjectValue(_sourceValue.origin(), $T.of())", new Object[]{ConfigClassNames.configValue, Map.class});
        } else {
            rootParse.addStatement("return null", new Object[0]);
        }
        rootParse.endControlFlow();
        rootParse.addStatement("var _config = _sourceValue.asObject()", new Object[0]);
        for (ConfigUtils.ConfigField field : fields) {
            rootParse.addStatement("var $N = this.parse_$L(_config)", new Object[]{field.name(), field.name()});
        }
        if (element.getKind() == ElementKind.CLASS) {
            if (element.getTypeParameters().isEmpty()) {
                rootParse.addCode("var _result = new $T(", new Object[]{implClassName});
            } else {
                rootParse.addCode("var _result = new $T<>(", new Object[]{implClassName});
            }
            if (nonEmptyConstructor != null && emptyConstructor == null) {
                for (int i = 0; i < nonEmptyConstructor.getParameters().size(); ++i) {
                    if (i > 0) {
                        rootParse.addCode(", ", new Object[0]);
                    }
                    rootParse.addCode("$N", new Object[]{nonEmptyConstructor.getParameters().get(i).getSimpleName()});
                }
            }
            rootParse.addCode(");\n", new Object[0]);
            for (ConfigUtils.ConfigField field : fields) {
                if (constructorParams.contains(field.name()) && emptyConstructor == null) continue;
                rootParse.addStatement("_result.set$N($N)", new Object[]{CommonUtils.capitalize((String)field.name()), field.name()});
            }
            rootParse.addStatement("return _result", new Object[0]);
        } else {
            CodeBlock.Builder returnCodeBlock = CodeBlock.builder();
            if (element.getTypeParameters().isEmpty()) {
                returnCodeBlock.add("return new $T(\n", new Object[]{implClassName});
            } else {
                returnCodeBlock.add("return new $T<>(\n", new Object[]{implClassName});
            }
            for (int i = 0; i < fields.size(); ++i) {
                ConfigUtils.ConfigField field = fields.get(i);
                if (i > 0) {
                    returnCodeBlock.add(",\n", new Object[0]);
                }
                returnCodeBlock.add("  $N", new Object[]{field.name()});
            }
            rootParse.addCode(returnCodeBlock.add("\n);\n", new Object[0]).build());
        }
        return rootParse.build();
    }

    public Either<Void, List<ProcessingError>> generateForRecord(RoundEnvironment roundEnv, DeclaredType targetType) {
        TypeElement element = (TypeElement)targetType.asElement();
        Either<List<ConfigUtils.ConfigField>, List<ProcessingError>> f = ConfigUtils.parseFields(this.types, element);
        if (f.isRight()) {
            return Either.right((Object)((List)f.right()));
        }
        String typeName = NameUtils.generatedType((Element)element, (ClassName)ConfigClassNames.configValueExtractor);
        TypeSpec.Builder typeBuilder = TypeSpec.classBuilder((String)typeName).addOriginatingElement((Element)element).addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)ConfigClassNames.configValueExtractor, (TypeName[])new TypeName[]{TypeName.get((TypeMirror)targetType)})).addAnnotation(AnnotationUtils.generated(ConfigParserGenerator.class)).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
        List fields = Objects.requireNonNull((List)f.left());
        ClassName implClassName = ClassName.get((TypeElement)element);
        MethodSpec constructor = this.buildConstructor(typeBuilder, fields);
        typeBuilder.addMethod(constructor);
        typeBuilder.addMethod(this.buildExtractMethod(element, TypeName.get((TypeMirror)targetType), implClassName, fields));
        for (ConfigUtils.ConfigField field : fields) {
            typeBuilder.addField(FieldSpec.builder((TypeName)ConfigClassNames.pathElementKey, (String)("_" + field.name() + "_path"), (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer(CodeBlock.of((String)"$T.get($S)", (Object[])new Object[]{ConfigClassNames.pathElement, field.name()})).build());
            MethodSpec parseFieldMethod = this.buildParseField(element, field);
            typeBuilder.addMethod(parseFieldMethod);
        }
        String packageName = this.elements.getPackageOf(element).getQualifiedName().toString();
        JavaFile javaFile = JavaFile.builder((String)packageName, (TypeSpec)typeBuilder.build()).build();
        CommonUtils.safeWriteTo((ProcessingEnvironment)this.processingEnv, (JavaFile)javaFile);
        return Either.left(null);
    }

    public Either<Void, List<ProcessingError>> generateForPojo(RoundEnvironment roundEnv, DeclaredType targetType) {
        TypeElement element = (TypeElement)targetType.asElement();
        Either<List<ConfigUtils.ConfigField>, List<ProcessingError>> f = ConfigUtils.parseFields(this.types, element);
        if (f.isRight()) {
            return Either.right((Object)((List)f.right()));
        }
        String typeName = NameUtils.generatedType((Element)element, (ClassName)ConfigClassNames.configValueExtractor);
        TypeSpec.Builder typeBuilder = TypeSpec.classBuilder((String)typeName).addOriginatingElement((Element)element).addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)ConfigClassNames.configValueExtractor, (TypeName[])new TypeName[]{TypeName.get((TypeMirror)targetType)})).addAnnotation(AnnotationUtils.generated(ConfigParserGenerator.class)).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
        List fields = Objects.requireNonNull((List)f.left());
        ClassName implClassName = ClassName.get((TypeElement)element);
        boolean hasDefault = CommonUtils.findConstructors((TypeElement)element, m -> m.contains((Object)Modifier.PUBLIC)).stream().anyMatch(e -> e.getParameters().isEmpty());
        if (hasDefault) {
            FieldSpec.Builder defaults = FieldSpec.builder((TypeName)implClassName, (String)"DEFAULTS", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer(CodeBlock.of((String)"new $T()", (Object[])new Object[]{implClassName}));
            typeBuilder.addField(defaults.build());
        }
        MethodSpec constructor = this.buildConstructor(typeBuilder, fields);
        typeBuilder.addMethod(constructor);
        typeBuilder.addMethod(this.buildExtractMethod(element, TypeName.get((TypeMirror)targetType), implClassName, fields));
        for (ConfigUtils.ConfigField field : fields) {
            typeBuilder.addField(FieldSpec.builder((TypeName)ConfigClassNames.pathElementKey, (String)("_" + field.name() + "_path"), (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer(CodeBlock.of((String)"$T.get($S)", (Object[])new Object[]{ConfigClassNames.pathElement, field.name()})).build());
            MethodSpec parseFieldMethod = this.buildParseField(element, field);
            typeBuilder.addMethod(parseFieldMethod);
        }
        String packageName = this.elements.getPackageOf(element).getQualifiedName().toString();
        JavaFile javaFile = JavaFile.builder((String)packageName, (TypeSpec)typeBuilder.build()).build();
        CommonUtils.safeWriteTo((ProcessingEnvironment)this.processingEnv, (JavaFile)javaFile);
        return Either.left(null);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private MethodSpec buildParseField(TypeElement element, ConfigUtils.ConfigField field) {
        parse = MethodSpec.methodBuilder((String)("parse_" + field.name())).addModifiers(new Modifier[]{Modifier.PRIVATE}).returns(field.typeName());
        if (field.isNullable()) {
            parse.addAnnotation(Nullable.class);
        }
        parse.addParameter((TypeName)ConfigClassNames.objectValue, "config", new Modifier[0]);
        supportedType = field.mapping() == null && ConfigUtils.isSupportedType(field.typeName()) != false;
        var7_5 = field.typeName();
        if (!(var7_5 instanceof ParameterizedTypeName)) ** GOTO lbl-1000
        ptn = (ParameterizedTypeName)var7_5;
        if (ptn.rawType.equals((Object)ConfigClassNames.optional)) {
            v0 /* !! */  = Optional.of((TypeName)ptn.typeArguments.get(0));
        } else lbl-1000:
        // 2 sources

        {
            v0 /* !! */  = Optional.empty();
        }
        optionalType = v0 /* !! */ ;
        supportedOptional = optionalType.map((Function<TypeName, Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, isSupportedType(com.squareup.javapoet.TypeName ), (Lcom/squareup/javapoet/TypeName;)Ljava/lang/Boolean;)()).orElse(false);
        parse.addStatement("var value = config.get($N)", new Object[]{"_" + field.name() + "_path"});
        if (supportedType || supportedOptional.booleanValue()) {
            parse.beginControlFlow("if (value instanceof $T.NullValue nullValue)", new Object[]{ConfigClassNames.configValue});
            if (field.hasDefault()) {
                if (element.getKind().isInterface()) {
                    parse.addStatement("var defaultValue = DEFAULTS.$L()", new Object[]{field.name()});
                } else {
                    parse.addStatement("var defaultValue = DEFAULTS.get$L()", new Object[]{CommonUtils.capitalize((String)field.name())});
                }
                if (field.typeName().isPrimitive()) {
                    parse.addStatement("return defaultValue", new Object[0]);
                } else {
                    parse.beginControlFlow("if (defaultValue == null)", new Object[0]);
                    if (field.isNullable()) {
                        parse.addStatement("return null", new Object[0]);
                    } else if (optionalType.isPresent()) {
                        parse.addStatement("return $T.empty()", new Object[]{ConfigClassNames.optional});
                    } else {
                        parse.addStatement("throw $T.missingValue(nullValue)", new Object[]{ConfigClassNames.configValueExtractionException});
                    }
                    parse.nextControlFlow("else", new Object[0]);
                    parse.addStatement("return defaultValue", new Object[0]);
                    parse.endControlFlow();
                }
            } else if (field.isNullable()) {
                parse.addStatement("return null", new Object[0]);
            } else if (optionalType.isPresent()) {
                parse.addStatement("return $T.empty()", new Object[]{ConfigClassNames.optional});
            } else {
                parse.addStatement("throw $T.missingValue(nullValue)", new Object[]{ConfigClassNames.configValueExtractionException});
            }
            parse.endControlFlow();
            if (supportedOptional.booleanValue()) {
                parse.addStatement("return $T.ofNullable($L)", new Object[]{Optional.class, this.parseSupportedType((TypeName)optionalType.get())});
            } else {
                parse.addStatement("return $L", new Object[]{this.parseSupportedType(field.typeName())});
            }
        } else {
            if (field.hasDefault()) {
                parse.beginControlFlow("if (value instanceof $T.NullValue nullValue)", new Object[]{ConfigClassNames.configValue});
                if (element.getKind().isInterface()) {
                    parse.addStatement("var defaultValue = DEFAULTS.$L()", new Object[]{field.name()});
                } else {
                    parse.addStatement("var defaultValue = DEFAULTS.get$L()", new Object[]{CommonUtils.capitalize((String)field.name())});
                }
                if (field.typeName().isPrimitive()) {
                    parse.addStatement("return defaultValue", new Object[0]);
                } else {
                    parse.beginControlFlow("if (defaultValue == null)", new Object[0]);
                    if (field.isNullable()) {
                        parse.addStatement("return null", new Object[0]);
                    } else if (optionalType.isPresent()) {
                        parse.addStatement("return $T.empty()", new Object[]{ConfigClassNames.optional});
                    } else {
                        parse.addStatement("throw $T.missingValue(value)", new Object[]{ConfigClassNames.configValueExtractionException});
                    }
                    parse.nextControlFlow("else", new Object[0]);
                    parse.addStatement("return defaultValue", new Object[0]);
                    parse.endControlFlow();
                }
                parse.endControlFlow();
            } else if (field.isNullable()) {
                parse.beginControlFlow("if (value instanceof $T.NullValue nullValue)", new Object[]{ConfigClassNames.configValue});
                parse.addStatement("return null", new Object[0]);
                parse.endControlFlow();
            }
            if (field.isNullable()) {
                parse.addStatement("return $L_parser.extract(value)", new Object[]{field.name()});
            } else {
                parse.addStatement("var parsed = $L_parser.extract(value)", new Object[]{field.name()});
                parse.beginControlFlow("if (parsed == null)", new Object[0]);
                parse.addStatement("throw $T.missingValueAfterParse(value)", new Object[]{ConfigClassNames.configValueExtractionException});
                parse.endControlFlow();
                parse.addStatement("return parsed", new Object[0]);
            }
        }
        return parse.build();
    }

    /*
     * Unable to fully structure code
     */
    private MethodSpec buildConstructor(TypeSpec.Builder parser, List<ConfigUtils.ConfigField> fields) {
        constructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC});
        fieldFactory = new FieldFactory(this.types, this.elements, parser, constructor, "extractor");
        for (ConfigUtils.ConfigField field : fields) {
            if (field.mapping() != null) ** GOTO lbl-1000
            if (ConfigUtils.isSupportedType(field.typeName())) ** GOTO lbl-1000
            var9_9 = field.typeName();
            if (var9_9 instanceof ParameterizedTypeName) {
                ptn = (ParameterizedTypeName)var9_9;
                ** if (!ptn.rawType.equals((Object)ConfigClassNames.optional) || !ConfigUtils.isSupportedType((TypeName)((TypeName)ptn.typeArguments.get((int)0)))) goto lbl-1000
            }
            ** GOTO lbl-1000
lbl-1000:
            // 2 sources

            {
                v0 = true;
                ** GOTO lbl14
            }
lbl-1000:
            // 3 sources

            {
                v0 = isSupported = false;
            }
lbl14:
            // 2 sources

            if (isSupported) continue;
            fieldParserType = ParameterizedTypeName.get((ClassName)ConfigClassNames.configValueExtractor, (TypeName[])new TypeName[]{field.typeName().box()});
            constructorParameterName = fieldFactory.add(field.mapping(), (TypeName)fieldParserType);
            fieldParserName = field.name() + "_parser";
            parser.addField((TypeName)fieldParserType, fieldParserName, new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
            constructor.addStatement("this.$L = $L", new Object[]{fieldParserName, constructorParameterName});
        }
        return constructor.build();
    }

    @Nullable
    private TypeSpec buildDefaultsType(DeclaredType type, TypeElement typeElement, List<ConfigUtils.ConfigField> fields) {
        boolean hasDefaults = false;
        TypeSpec.Builder defaults = TypeSpec.classBuilder((String)(typeElement.getSimpleName().toString() + "_Defaults")).addOriginatingElement((Element)typeElement).addAnnotation(AnnotationUtils.generated(ConfigParserGenerator.class)).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).addSuperinterface((TypeMirror)type);
        for (TypeParameterElement typeParameterElement : typeElement.getTypeParameters()) {
            defaults.addTypeVariable(TypeVariableName.get((TypeParameterElement)typeParameterElement));
        }
        for (ConfigUtils.ConfigField configField : fields) {
            if (configField.hasDefault()) {
                hasDefaults = true;
                continue;
            }
            MethodSpec.Builder m = MethodSpec.methodBuilder((String)configField.name()).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(configField.typeName());
            if (configField.typeName() == TypeName.BOOLEAN) {
                m.addStatement("return false", new Object[0]);
            } else if (configField.typeName().isPrimitive()) {
                m.addStatement("return 0", new Object[0]);
            } else {
                m.addStatement("return null", new Object[0]);
            }
            defaults.addMethod(m.build());
        }
        if (hasDefaults) {
            return defaults.build();
        }
        return null;
    }

    private String buildConfigInterfaceImplementation(TypeElement typeElement, List<ConfigUtils.ConfigField> fields) {
        RecordClassBuilder recordBuilder = new RecordClassBuilder(typeElement.getSimpleName() + "_Impl", ConfigParserGenerator.class).addModifier(Modifier.PUBLIC).enforceEquals();
        for (ConfigUtils.ConfigField field : fields) {
            boolean requireCheck = !field.isNullable() && !field.typeName().isPrimitive();
            recordBuilder.addComponent(field.name(), field.typeName(), requireCheck);
        }
        recordBuilder.superinterface(TypeName.get((TypeMirror)typeElement.asType()));
        return recordBuilder.render().indent(2);
    }

    private CodeBlock parseSupportedType(TypeName typeName) {
        return Objects.requireNonNull(supportedTypes.get(typeName));
    }
}

