/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.config.annotation.processor;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import jakarta.annotation.Nullable;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.RecordComponentElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import ru.tinkoff.kora.annotation.processor.common.CommonUtils;
import ru.tinkoff.kora.annotation.processor.common.ProcessingError;
import ru.tinkoff.kora.common.util.Either;
import ru.tinkoff.kora.config.annotation.processor.ConfigClassNames;

public class ConfigUtils {
    public static final Set<TypeName> SUPPORTED_TYPES = Set.of(TypeName.INT, TypeName.INT.box(), TypeName.LONG, TypeName.LONG.box(), TypeName.DOUBLE, TypeName.DOUBLE.box(), TypeName.BOOLEAN, TypeName.BOOLEAN.box(), ClassName.get(String.class));

    public static boolean isSupportedType(TypeName typeName) {
        return SUPPORTED_TYPES.contains(typeName);
    }

    public static Either<List<ConfigField>, List<ProcessingError>> parseFields(Types types, TypeElement typeElement) {
        DeclaredType type = (DeclaredType)typeElement.asType();
        if (typeElement.getKind() == ElementKind.RECORD) {
            return ConfigUtils.parseRecord(types, type, typeElement);
        }
        if (typeElement.getKind() == ElementKind.INTERFACE) {
            return ConfigUtils.parseInterface(types, type, typeElement);
        }
        if (typeElement.getKind() == ElementKind.CLASS) {
            return ConfigUtils.parseClass(types, type, typeElement);
        }
        return Either.right(List.of(new ProcessingError("typeElement should be interface, class or record, got " + typeElement.getKind(), (Element)typeElement)));
    }

    private static Either<List<ConfigField>, List<ProcessingError>> parseRecord(Types types, DeclaredType typeMirror, TypeElement te) {
        if (te.getKind() != ElementKind.RECORD) {
            throw new IllegalArgumentException("Method expecting record");
        }
        ArrayList<ConfigField> fields = new ArrayList<ConfigField>();
        for (RecordComponentElement recordComponentElement : te.getRecordComponents()) {
            TypeMirror recordComponentType = types.asMemberOf(typeMirror, recordComponentElement);
            String name = recordComponentElement.getSimpleName().toString();
            CommonUtils.MappingData mapping = CommonUtils.parseMapping((Element)recordComponentElement).getMapping(ConfigClassNames.configValueExtractor);
            boolean isNullable = CommonUtils.isNullable((AnnotatedConstruct)recordComponentElement) && !recordComponentType.getKind().isPrimitive();
            fields.add(new ConfigField(name, TypeName.get((TypeMirror)recordComponentType), isNullable, false, mapping));
        }
        return Either.left(fields);
    }

    private static Either<List<ConfigField>, List<ProcessingError>> parseInterface(Types types, DeclaredType typeMirror, TypeElement te) {
        if (te.getKind() != ElementKind.INTERFACE) {
            throw new IllegalArgumentException("Method expecting interface");
        }
        HashSet<String> seen = new HashSet<String>();
        ArrayList<ProcessingError> errors = new ArrayList<ProcessingError>();
        ArrayList<ConfigField> fields = new ArrayList<ConfigField>();
        ConfigUtils.parseInterface(types, typeMirror, te, fields, errors, seen);
        if (errors.isEmpty()) {
            return Either.left(fields);
        }
        return Either.right(errors);
    }

    private static void parseInterface(Types types, DeclaredType typeMirror, TypeElement te, List<ConfigField> fields, List<ProcessingError> errors, Set<String> seen) {
        if (te.getKind() != ElementKind.INTERFACE) {
            throw new IllegalArgumentException("Method expecting interface");
        }
        for (Element element : te.getEnclosedElements()) {
            if (element.getKind() != ElementKind.METHOD || element.getModifiers().contains((Object)Modifier.STATIC) || element.getModifiers().contains((Object)Modifier.PRIVATE)) continue;
            ExecutableElement method = (ExecutableElement)element;
            if (!method.getParameters().isEmpty()) {
                if (method.getModifiers().contains((Object)Modifier.DEFAULT)) continue;
                errors.add(new ProcessingError("Config has non default method with arguments", (Element)method));
            }
            if (method.getReturnType().getKind() == TypeKind.VOID) {
                if (method.getModifiers().contains((Object)Modifier.DEFAULT)) continue;
                errors.add(new ProcessingError("Config has non default method returning void", (Element)method));
            }
            if (!method.getTypeParameters().isEmpty()) {
                errors.add(new ProcessingError("Config has method with type parameters", (Element)method));
            }
            ExecutableType methodType = (ExecutableType)types.asMemberOf(typeMirror, method);
            String name = method.getSimpleName().toString();
            if (seen.add(name)) {
                boolean isNullable = CommonUtils.isNullable((AnnotatedConstruct)method) && !methodType.getReturnType().getKind().isPrimitive();
                CommonUtils.MappingData mappingData = CommonUtils.parseMapping((Element)method).getMapping(ConfigClassNames.configValueExtractor);
                fields.add(new ConfigField(name, TypeName.get((TypeMirror)methodType.getReturnType()), isNullable, method.getModifiers().contains((Object)Modifier.DEFAULT), mappingData));
            }
            for (TypeMirror typeMirror2 : te.getInterfaces()) {
                TypeElement superinterfaceElement = (TypeElement)types.asElement(typeMirror2);
                ConfigUtils.parseInterface(types, (DeclaredType)typeMirror2, superinterfaceElement, fields, errors, seen);
            }
        }
    }

    private static Either<List<ConfigField>, List<ProcessingError>> parseClass(Types types, DeclaredType typeMirror, TypeElement te) {
        ArrayList<ProcessingError> errors = new ArrayList<ProcessingError>();
        if (te.getKind() != ElementKind.CLASS) {
            throw new IllegalArgumentException("Method expecting record");
        }
        if (te.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            errors.add(new ProcessingError("Config annotated class can't be abstract", (Element)te));
            return Either.right(errors);
        }
        ExecutableElement equals = null;
        ExecutableElement hashCode = null;
        class FieldAndAccessors {
            VariableElement field;
            ExecutableElement getter;
            ExecutableElement setter;

            FieldAndAccessors() {
            }
        }
        HashMap<String, FieldAndAccessors> fieldsWithAccessors = new HashMap<String, FieldAndAccessors>();
        for (Element element : te.getEnclosedElements()) {
            String name = element.getSimpleName().toString();
            if (element.getKind() == ElementKind.FIELD) {
                fieldsWithAccessors.computeIfAbsent(name, (Function<String, FieldAndAccessors>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$parseClass$0(java.lang.String ), (Ljava/lang/String;)Lru/tinkoff/kora/config/annotation/processor/ConfigUtils$1FieldAndAccessors;)()).field = (VariableElement)element;
            }
            if (element.getKind() != ElementKind.METHOD || element.getModifiers().contains((Object)Modifier.PRIVATE) || element.getModifiers().contains((Object)Modifier.STATIC)) continue;
            ExecutableElement method = (ExecutableElement)element;
            if (name.equals("equals") && method.getParameters().size() == 1) {
                equals = method;
                continue;
            }
            if (name.equals("hashCode") && method.getParameters().isEmpty()) {
                hashCode = method;
                continue;
            }
            if (method.getParameters().isEmpty()) {
                if (name.startsWith("get")) {
                    fieldsWithAccessors.computeIfAbsent(CommonUtils.decapitalize((String)name.substring((int)3)), (Function<String, FieldAndAccessors>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$parseClass$1(java.lang.String ), (Ljava/lang/String;)Lru/tinkoff/kora/config/annotation/processor/ConfigUtils$1FieldAndAccessors;)()).getter = method;
                    continue;
                }
                fieldsWithAccessors.computeIfAbsent(name, (Function<String, FieldAndAccessors>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$parseClass$2(java.lang.String ), (Ljava/lang/String;)Lru/tinkoff/kora/config/annotation/processor/ConfigUtils$1FieldAndAccessors;)()).getter = method;
                continue;
            }
            if (method.getParameters().size() != 1 || !name.startsWith("set")) continue;
            fieldsWithAccessors.computeIfAbsent(CommonUtils.decapitalize((String)name.substring((int)3)), (Function<String, FieldAndAccessors>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$parseClass$3(java.lang.String ), (Ljava/lang/String;)Lru/tinkoff/kora/config/annotation/processor/ConfigUtils$1FieldAndAccessors;)()).setter = method;
        }
        if (equals == null || hashCode == null) {
            errors.add(new ProcessingError("Config annotated class must override equals and hashCode methods", (Element)te));
            return Either.right(errors);
        }
        List constructors = CommonUtils.findConstructors((TypeElement)te, m -> m.contains((Object)Modifier.PUBLIC));
        ExecutableElement executableElement = constructors.stream().filter(e -> e.getParameters().isEmpty()).findFirst().orElse(null);
        ExecutableElement nonEmptyConstructor = constructors.stream().filter(e -> !e.getParameters().isEmpty()).findFirst().orElse(null);
        Map constructorParams = nonEmptyConstructor == null ? Map.of() : nonEmptyConstructor.getParameters().stream().collect(Collectors.toMap(p -> p.getSimpleName().toString(), p -> p));
        HashSet<String> seen = new HashSet<String>();
        ArrayList<ConfigField> fields = new ArrayList<ConfigField>();
        for (Map.Entry fieldWithAccessors : fieldsWithAccessors.entrySet()) {
            String name = (String)fieldWithAccessors.getKey();
            FieldAndAccessors value = (FieldAndAccessors)fieldWithAccessors.getValue();
            if (value.getter == null || value.field == null || value.setter == null && !constructorParams.containsKey(value.field.getSimpleName().toString())) continue;
            TypeMirror fieldType = types.asMemberOf(typeMirror, value.field);
            if (!seen.add(name)) continue;
            boolean isNullable = CommonUtils.isNullable((AnnotatedConstruct)value.field) && !fieldType.getKind().isPrimitive();
            CommonUtils.MappingData mapping = CommonUtils.parseMapping((Element)value.field).getMapping(ConfigClassNames.configValueExtractor);
            VariableElement constructorParam = (VariableElement)constructorParams.get(name);
            if (constructorParam != null) {
                if (mapping == null) {
                    mapping = CommonUtils.parseMapping((Element)constructorParam).getMapping(ConfigClassNames.configValueExtractor);
                }
                isNullable = CommonUtils.isNullable((AnnotatedConstruct)constructorParam) && !fieldType.getKind().isPrimitive();
            }
            boolean hasDefault = executableElement != null || !constructorParams.containsKey(value.field.getSimpleName().toString());
            fields.add(new ConfigField(name, TypeName.get((TypeMirror)fieldType), isNullable, hasDefault, mapping));
        }
        return Either.left(fields);
    }

    private static /* synthetic */ 1FieldAndAccessors lambda$parseClass$3(String n) {
        return new FieldAndAccessors();
    }

    private static /* synthetic */ 1FieldAndAccessors lambda$parseClass$2(String n) {
        return new FieldAndAccessors();
    }

    private static /* synthetic */ 1FieldAndAccessors lambda$parseClass$1(String n) {
        return new FieldAndAccessors();
    }

    private static /* synthetic */ 1FieldAndAccessors lambda$parseClass$0(String n) {
        return new FieldAndAccessors();
    }

    public record ConfigField(String name, TypeName typeName, boolean isNullable, boolean hasDefault, @Nullable CommonUtils.MappingData mapping) {
    }
}

