/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.config.annotation.processor.extension;

import com.squareup.javapoet.ClassName;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import ru.tinkoff.kora.annotation.processor.common.AnnotationUtils;
import ru.tinkoff.kora.annotation.processor.common.CommonUtils;
import ru.tinkoff.kora.annotation.processor.common.NameUtils;
import ru.tinkoff.kora.annotation.processor.common.ProcessingError;
import ru.tinkoff.kora.common.util.Either;
import ru.tinkoff.kora.config.annotation.processor.ConfigClassNames;
import ru.tinkoff.kora.config.annotation.processor.ConfigParserGenerator;
import ru.tinkoff.kora.config.annotation.processor.ConfigUtils;
import ru.tinkoff.kora.kora.app.annotation.processor.extension.ExtensionResult;
import ru.tinkoff.kora.kora.app.annotation.processor.extension.KoraExtension;

public final class ConfigKoraExtension
implements KoraExtension {
    private final Elements elements;
    private final Types types;
    private final TypeMirror configValueExtractorTypeErasure;
    private final ConfigParserGenerator configParserGenerator;
    private final ProcessingEnvironment processingEnv;

    public ConfigKoraExtension(ProcessingEnvironment processingEnv) {
        this.processingEnv = processingEnv;
        this.configParserGenerator = new ConfigParserGenerator(processingEnv);
        this.elements = processingEnv.getElementUtils();
        this.types = processingEnv.getTypeUtils();
        this.configValueExtractorTypeErasure = this.types.erasure(this.elements.getTypeElement(ConfigClassNames.configValueExtractor.canonicalName()).asType());
    }

    @Nullable
    public KoraExtension.KoraExtensionDependencyGenerator getDependencyGenerator(RoundEnvironment roundEnvironment, TypeMirror typeMirror, Set<String> tags) {
        if (!tags.isEmpty()) {
            return null;
        }
        if (!this.types.isSameType(this.types.erasure(typeMirror), this.configValueExtractorTypeErasure)) {
            return null;
        }
        TypeMirror paramType = ((DeclaredType)typeMirror).getTypeArguments().get(0);
        if (paramType.getKind() != TypeKind.DECLARED) {
            return null;
        }
        TypeElement element = (TypeElement)this.types.asElement(paramType);
        PackageElement packageElement = this.elements.getPackageOf(element);
        String mapperName = NameUtils.generatedType((Element)element, (ClassName)ConfigClassNames.configValueExtractor);
        if (AnnotationUtils.isAnnotationPresent((Element)element, (ClassName)ConfigClassNames.configValueExtractorAnnotation) || AnnotationUtils.isAnnotationPresent((Element)element, (ClassName)ConfigClassNames.configSourceAnnotation)) {
            return () -> {
                TypeElement maybeGenerated = this.elements.getTypeElement(packageElement.getQualifiedName() + "." + mapperName);
                if (maybeGenerated == null) {
                    return ExtensionResult.nextRound();
                }
                List constructors = CommonUtils.findConstructors((TypeElement)maybeGenerated, m -> m.contains((Object)Modifier.PUBLIC));
                if (constructors.size() != 1) {
                    throw new IllegalStateException();
                }
                return ExtensionResult.fromExecutable((ExecutableElement)((ExecutableElement)constructors.get(0)));
            };
        }
        KoraExtension.KoraExtensionDependencyGenerator generator = () -> {
            TypeElement maybeGenerated = this.elements.getTypeElement(packageElement.getQualifiedName() + "." + mapperName);
            if (maybeGenerated != null) {
                List constructors = CommonUtils.findConstructors((TypeElement)maybeGenerated, m -> m.contains((Object)Modifier.PUBLIC));
                if (constructors.size() != 1) {
                    throw new IllegalStateException();
                }
                return ExtensionResult.fromExecutable((ExecutableElement)((ExecutableElement)constructors.get(0)));
            }
            Either<Void, List<ProcessingError>> result = switch (element.getKind()) {
                case ElementKind.CLASS -> this.configParserGenerator.generateForPojo(roundEnvironment, (DeclaredType)paramType);
                case ElementKind.INTERFACE -> this.configParserGenerator.generateForInterface(roundEnvironment, (DeclaredType)paramType);
                case ElementKind.RECORD -> this.configParserGenerator.generateForRecord(roundEnvironment, (DeclaredType)paramType);
                default -> throw new IllegalStateException();
            };
            assert (result.isLeft());
            return ExtensionResult.nextRound();
        };
        if (element.getKind() == ElementKind.INTERFACE || element.getKind() == ElementKind.RECORD || element.getKind() == ElementKind.CLASS) {
            Either<List<ConfigUtils.ConfigField>, List<ProcessingError>> fields = ConfigUtils.parseFields(this.types, element);
            if (fields.isLeft()) {
                return generator;
            }
            ProcessingError firstError = (ProcessingError)((List)fields.right()).get(0);
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Extension tried to generate dependency but failed: " + firstError.message(), firstError.element(), firstError.a(), firstError.v());
            return null;
        }
        return null;
    }
}

