/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.config.annotation.processor.processor;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.tools.Diagnostic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;
import ru.tinkoff.kora.annotation.processor.common.AbstractKoraProcessor;
import ru.tinkoff.kora.annotation.processor.common.LogUtils;
import ru.tinkoff.kora.annotation.processor.common.ProcessingError;
import ru.tinkoff.kora.common.util.Either;
import ru.tinkoff.kora.config.annotation.processor.ConfigClassNames;
import ru.tinkoff.kora.config.annotation.processor.ConfigParserGenerator;

public class ConfigParserAnnotationProcessor
extends AbstractKoraProcessor {
    private static final Logger log = LoggerFactory.getLogger(ConfigParserAnnotationProcessor.class);
    private TypeElement configValueExtractorAnnotation;
    private TypeElement configSourceAnnotation;
    private ConfigParserGenerator configParserGenerator;

    public Set<String> getSupportedAnnotationTypes() {
        return Set.of(ConfigClassNames.configValueExtractorAnnotation.canonicalName(), ConfigClassNames.configSourceAnnotation.canonicalName());
    }

    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.configValueExtractorAnnotation = processingEnv.getElementUtils().getTypeElement(ConfigClassNames.configValueExtractorAnnotation.canonicalName());
        this.configSourceAnnotation = processingEnv.getElementUtils().getTypeElement(ConfigClassNames.configSourceAnnotation.canonicalName());
        this.configParserGenerator = new ConfigParserGenerator(processingEnv);
    }

    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (this.configValueExtractorAnnotation == null) {
            return false;
        }
        Set<? extends Element> elements = roundEnv.getElementsAnnotatedWithAny(this.configValueExtractorAnnotation, this.configSourceAnnotation);
        LogUtils.logElementsFull((Logger)log, (Level)Level.DEBUG, (String)"Generating ConfigValueExtractor for", elements);
        for (Element element : elements) {
            Either<Void, List<ProcessingError>> result;
            if (element.getKind() == ElementKind.INTERFACE) {
                result = this.configParserGenerator.generateForInterface(roundEnv, (DeclaredType)element.asType());
                if (!result.isRight()) continue;
                for (ProcessingError processingError : Objects.requireNonNull((List)result.right())) {
                    processingError.print(this.processingEnv);
                }
                continue;
            }
            if (element.getKind() == ElementKind.RECORD) {
                this.configParserGenerator.generateForRecord(roundEnv, (DeclaredType)element.asType());
                continue;
            }
            if (element.getKind() == ElementKind.CLASS) {
                result = this.configParserGenerator.generateForPojo(roundEnv, (DeclaredType)element.asType());
                if (!result.isRight()) continue;
                for (ProcessingError processingError : Objects.requireNonNull((List)result.right())) {
                    processingError.print(this.processingEnv);
                }
                continue;
            }
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "@" + ConfigClassNames.configValueExtractorAnnotation.simpleName() + " is applicable only to records, classes or interfaces");
        }
        return false;
    }
}

