/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.config.annotation.processor.processor;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.Optional;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import ru.tinkoff.kora.annotation.processor.common.AbstractKoraProcessor;
import ru.tinkoff.kora.annotation.processor.common.AnnotationUtils;
import ru.tinkoff.kora.annotation.processor.common.CommonClassNames;
import ru.tinkoff.kora.annotation.processor.common.CommonUtils;
import ru.tinkoff.kora.config.annotation.processor.ConfigClassNames;

public class ConfigSourceAnnotationProcessor
extends AbstractKoraProcessor {
    public Set<String> getSupportedAnnotationTypes() {
        return Set.of(ConfigClassNames.configSourceAnnotation.canonicalName());
    }

    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (Element element : roundEnv.getElementsAnnotatedWith(this.elements.getTypeElement(ConfigClassNames.configSourceAnnotation.canonicalName()))) {
            TypeSpec.Builder typeBuilder = TypeSpec.interfaceBuilder((String)(element.getSimpleName().toString() + "Module"));
            String path = (String)AnnotationUtils.parseAnnotationValueWithoutDefault((AnnotationMirror)AnnotationUtils.findAnnotation((Element)element, (ClassName)ConfigClassNames.configSourceAnnotation), (String)"value");
            StringBuilder name = new StringBuilder(element.getSimpleName().toString());
            Element parent = element.getEnclosingElement();
            while (parent.getKind() != ElementKind.PACKAGE) {
                name.insert(0, parent.getSimpleName());
                parent = parent.getEnclosingElement();
            }
            name.replace(0, 1, String.valueOf(Character.toLowerCase(name.charAt(0))));
            MethodSpec.Builder method = MethodSpec.methodBuilder((String)name.toString()).returns(TypeName.get((TypeMirror)element.asType())).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.DEFAULT}).addParameter((TypeName)ConfigClassNames.config, "config", new Modifier[0]).addParameter((TypeName)ParameterizedTypeName.get((ClassName)ConfigClassNames.configValueExtractor, (TypeName[])new TypeName[]{TypeName.get((TypeMirror)element.asType())}), "extractor", new Modifier[0]).addStatement("var configValue = config.get($S)", new Object[]{path}).addStatement("return $T.ofNullable(extractor.extract(configValue)).orElseThrow(() -> $T.missingValueAfterParse(configValue))", new Object[]{Optional.class, CommonClassNames.configValueExtractionException});
            TypeSpec type = typeBuilder.addMethod(method.build()).addAnnotation(CommonClassNames.module).addAnnotation(AnnotationSpec.builder((ClassName)CommonClassNames.koraGenerated).addMember("value", CodeBlock.of((String)"$S", (Object[])new Object[]{ConfigSourceAnnotationProcessor.class.getCanonicalName()})).build()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addOriginatingElement(element).build();
            PackageElement packageElement = this.elements.getPackageOf(element);
            JavaFile javaFile = JavaFile.builder((String)packageElement.getQualifiedName().toString(), (TypeSpec)type).build();
            CommonUtils.safeWriteTo((ProcessingEnvironment)this.processingEnv, (JavaFile)javaFile);
        }
        return false;
    }
}

