/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.config.hocon;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigResolveOptions;
import com.typesafe.config.impl.ConfigImpl;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import ru.tinkoff.kora.config.common.CommonConfigModule;
import ru.tinkoff.kora.config.common.annotation.ApplicationConfig;
import ru.tinkoff.kora.config.common.origin.ConfigOrigin;
import ru.tinkoff.kora.config.common.origin.FileConfigOrigin;
import ru.tinkoff.kora.config.common.origin.ResourceConfigOrigin;
import ru.tinkoff.kora.config.common.origin.SimpleConfigOrigin;
import ru.tinkoff.kora.config.hocon.HoconConfigFactory;

public interface HoconConfigModule
extends CommonConfigModule {
    @ApplicationConfig
    default public ConfigOrigin applicationConfigOrigin() throws URISyntaxException {
        String file;
        String resource = System.getProperty("config.resource");
        int specified = 0;
        if (resource != null) {
            ++specified;
        }
        if ((file = System.getProperty("config.file")) != null) {
            ++specified;
        }
        if (specified == 0) {
            resource = "application.conf";
        } else if (specified > 1) {
            throw new RuntimeException("You set more than one of config.file='%s', config.resource='%s'; don't know which one to use!".formatted(file, resource));
        }
        if (resource != null) {
            ClassLoader loader;
            URL resourceUrl;
            if (resource.startsWith("/")) {
                resource = resource.substring(1);
            }
            if ((resourceUrl = (loader = Thread.currentThread().getContextClassLoader()).getResource(resource)) == null) {
                return new SimpleConfigOrigin("empty");
            }
            if (resourceUrl.getProtocol().equals("file")) {
                return new FileConfigOrigin(Path.of(resourceUrl.toURI()));
            }
            return new ResourceConfigOrigin(resourceUrl);
        }
        return new FileConfigOrigin(Path.of(file, new String[0]));
    }

    @ApplicationConfig
    default public Config applicationUnresolved(@ApplicationConfig ConfigOrigin origin) throws Exception {
        if (origin instanceof FileConfigOrigin) {
            FileConfigOrigin file = (FileConfigOrigin)origin;
            try (BufferedReader reader = Files.newBufferedReader(file.path(), StandardCharsets.UTF_8);){
                Config config = ConfigFactory.parseReader((Reader)reader);
                return config;
            }
        }
        if (origin instanceof ResourceConfigOrigin) {
            ResourceConfigOrigin resource = (ResourceConfigOrigin)origin;
            URLConnection connection = resource.url().openConnection();
            connection.connect();
            try {
                Config config;
                try (InputStreamReader reader = new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8);){
                    config = ConfigFactory.parseReader((Reader)reader);
                }
                return config;
            }
            finally {
                if (connection instanceof AutoCloseable) {
                    AutoCloseable closeable = (AutoCloseable)((Object)connection);
                    closeable.close();
                }
            }
        }
        return ConfigFactory.empty();
    }

    default public Config hoconConfig(@ApplicationConfig Config config) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        ConfigFactory.invalidateCaches();
        return ConfigFactory.defaultOverrides((ClassLoader)loader).withFallback((ConfigMergeable)config).withFallback((ConfigMergeable)ConfigImpl.defaultReferenceUnresolved((ClassLoader)loader)).resolve(ConfigResolveOptions.defaults());
    }

    @ApplicationConfig
    default public ru.tinkoff.kora.config.common.Config config(@ApplicationConfig ConfigOrigin origin, Config hoconConfig) {
        return HoconConfigFactory.fromHocon(origin, hoconConfig);
    }
}

