/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.config.yaml;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.snakeyaml.engine.v2.api.Load;
import org.snakeyaml.engine.v2.api.LoadSettings;
import ru.tinkoff.kora.config.common.Config;
import ru.tinkoff.kora.config.common.ConfigValue;
import ru.tinkoff.kora.config.common.ConfigValueOrigin;
import ru.tinkoff.kora.config.common.ConfigValuePath;
import ru.tinkoff.kora.config.common.factory.MapConfigFactory;
import ru.tinkoff.kora.config.common.impl.SimpleConfig;
import ru.tinkoff.kora.config.common.impl.SimpleConfigValueOrigin;
import ru.tinkoff.kora.config.common.origin.ConfigOrigin;

public class YamlConfigFactory {
    public static Config fromYaml(ConfigOrigin origin, InputStream is) {
        LoadSettings settings = LoadSettings.builder().setAllowRecursiveKeys(false).build();
        Load load = new Load(settings);
        Map document = (Map)load.loadFromInputStream(is);
        ConfigValuePath path = ConfigValuePath.root();
        if (document == null) {
            return MapConfigFactory.fromMap((ConfigOrigin)origin, Map.of());
        }
        ConfigValue.ObjectValue root = YamlConfigFactory.toObject(origin, path, document);
        return new SimpleConfig(origin, root);
    }

    private static ConfigValue.ObjectValue toObject(ConfigOrigin origin, ConfigValuePath path, Map<String, ?> document) {
        LinkedHashMap object = new LinkedHashMap(document.size());
        for (Map.Entry<String, ?> entry : document.entrySet()) {
            if (entry.getValue() == null) continue;
            String key = entry.getKey();
            ConfigValuePath valuePath = path.child(key);
            ConfigValue<?> value = YamlConfigFactory.toValue(origin, valuePath, entry.getValue());
            object.put(key, value);
        }
        return new ConfigValue.ObjectValue((ConfigValueOrigin)new SimpleConfigValueOrigin(origin, path), object);
    }

    private static ConfigValue.ArrayValue toArray(ConfigOrigin origin, ConfigValuePath path, List<?> list) {
        ArrayList array = new ArrayList(list.size());
        for (int i = 0; i < list.size(); ++i) {
            Object item = list.get(i);
            if (item == null) {
                array.add(null);
                continue;
            }
            ConfigValuePath valuePath = path.child(i);
            ConfigValue<?> value = YamlConfigFactory.toValue(origin, valuePath, item);
            array.add(value);
        }
        return new ConfigValue.ArrayValue((ConfigValueOrigin)new SimpleConfigValueOrigin(origin, path), array);
    }

    private static ConfigValue<?> toValue(ConfigOrigin origin, ConfigValuePath path, Object value) {
        Objects.requireNonNull(value);
        if (value instanceof Map) {
            Map map;
            Map object = map = (Map)value;
            return YamlConfigFactory.toObject(origin, path, object);
        }
        if (value instanceof List) {
            List list = (List)value;
            return YamlConfigFactory.toArray(origin, path, list);
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return new ConfigValue.NumberValue((ConfigValueOrigin)new SimpleConfigValueOrigin(origin, path), number);
        }
        if (value instanceof String) {
            String str = (String)value;
            return new ConfigValue.StringValue((ConfigValueOrigin)new SimpleConfigValueOrigin(origin, path), str);
        }
        if (value instanceof Boolean) {
            Boolean bool = (Boolean)value;
            return new ConfigValue.BooleanValue((ConfigValueOrigin)new SimpleConfigValueOrigin(origin, path), bool);
        }
        throw new IllegalArgumentException("Unknown type %s for path %s".formatted(value.getClass(), path));
    }
}

