/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.config.yaml;

import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Enumeration;
import java.util.Map;
import ru.tinkoff.kora.common.Tag;
import ru.tinkoff.kora.config.common.CommonConfigModule;
import ru.tinkoff.kora.config.common.Config;
import ru.tinkoff.kora.config.common.annotation.ApplicationConfig;
import ru.tinkoff.kora.config.common.factory.MapConfigFactory;
import ru.tinkoff.kora.config.common.factory.MergeConfigFactory;
import ru.tinkoff.kora.config.common.origin.ConfigOrigin;
import ru.tinkoff.kora.config.common.origin.FileConfigOrigin;
import ru.tinkoff.kora.config.common.origin.ResourceConfigOrigin;
import ru.tinkoff.kora.config.common.origin.SimpleConfigOrigin;
import ru.tinkoff.kora.config.yaml.YamlConfigFactory;

public interface YamlConfigModule
extends CommonConfigModule {
    @ApplicationConfig
    default public ConfigOrigin applicationConfigOrigin() throws URISyntaxException {
        String file;
        String resource = System.getProperty("config.resource");
        int specified = 0;
        if (resource != null) {
            ++specified;
        }
        if ((file = System.getProperty("config.file")) != null) {
            ++specified;
        }
        if (specified == 0) {
            resource = "application.yaml";
        } else if (specified > 1) {
            throw new RuntimeException("You set more than one of config.file='%s', config.resource='%s'; don't know which one to use!".formatted(file, resource));
        }
        if (resource != null) {
            ClassLoader loader;
            URL resourceUrl;
            if (resource.startsWith("/")) {
                resource = resource.substring(1);
            }
            if ((resourceUrl = (loader = Thread.currentThread().getContextClassLoader()).getResource(resource)) == null) {
                return new SimpleConfigOrigin("empty");
            }
            if (resourceUrl.getProtocol().equals("file")) {
                return new FileConfigOrigin(Path.of(resourceUrl.toURI()));
            }
            return new ResourceConfigOrigin(resourceUrl);
        }
        return new FileConfigOrigin(Path.of(file, new String[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Tag(value={YamlConfigModule.class})
    default public Config referenceConfig() throws Exception {
        Enumeration<URL> references = Thread.currentThread().getContextClassLoader().getResources("reference.yaml");
        Config config = MapConfigFactory.fromMap((String)"empty", Map.of());
        while (references.hasMoreElements()) {
            URL referenceUrl = references.nextElement();
            ResourceConfigOrigin origin = new ResourceConfigOrigin(referenceUrl);
            URLConnection connection = referenceUrl.openConnection();
            try {
                InputStream is = connection.getInputStream();
                try {
                    Config yamlConfig = YamlConfigFactory.fromYaml((ConfigOrigin)origin, is);
                    try {
                        yamlConfig.resolve();
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Reference config must be resolvable without external configs", e);
                    }
                    config = MergeConfigFactory.merge((Config)yamlConfig, (Config)config);
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            finally {
                if (!(connection instanceof AutoCloseable)) continue;
                AutoCloseable closeable = (AutoCloseable)((Object)connection);
                closeable.close();
            }
        }
        return config;
    }

    @ApplicationConfig
    default public Config yamlConfig(@ApplicationConfig ConfigOrigin configOrigin, @Tag(value={YamlConfigModule.class}) Config reference) throws Exception {
        if (configOrigin instanceof FileConfigOrigin) {
            FileConfigOrigin fileConfigOrigin = (FileConfigOrigin)configOrigin;
            try (InputStream is = Files.newInputStream(fileConfigOrigin.path(), StandardOpenOption.READ);){
                Config config = YamlConfigFactory.fromYaml(configOrigin, is);
                Config config2 = MergeConfigFactory.merge((Config)config, (Config)reference);
                return config2;
            }
        }
        if (configOrigin instanceof ResourceConfigOrigin) {
            ResourceConfigOrigin resourceConfigOrigin = (ResourceConfigOrigin)configOrigin;
            URLConnection connection = resourceConfigOrigin.url().openConnection();
            connection.connect();
            try {
                Config config;
                block18: {
                    InputStream is = connection.getInputStream();
                    try {
                        Config config3 = YamlConfigFactory.fromYaml(configOrigin, is);
                        config = MergeConfigFactory.merge((Config)config3, (Config)reference);
                        if (is == null) break block18;
                    }
                    catch (Throwable throwable) {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    is.close();
                }
                return config;
            }
            finally {
                if (connection instanceof AutoCloseable) {
                    AutoCloseable closeable = (AutoCloseable)((Object)connection);
                    closeable.close();
                }
            }
        }
        return reference;
    }
}

