/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.database.annotation.processor;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import ru.tinkoff.kora.annotation.processor.common.CommonUtils;
import ru.tinkoff.kora.database.annotation.processor.entity.DbEntity;

public class DbEntityReadHelper {
    private final ClassName fieldMapperName;
    private final Types types;
    private final Function<FieldData, CodeBlock> mapperCallGenerator;
    private final Function<FieldData, CodeBlock> nativeTypeExtractGenerator;
    private final Function<FieldData, CodeBlock> nullCheckGenerator;

    public DbEntityReadHelper(ClassName fieldMapperName, Types types, Function<FieldData, CodeBlock> mapperCallGenerator, Function<FieldData, CodeBlock> nativeTypeExtractGenerator, Function<FieldData, CodeBlock> nullCheckGenerator) {
        this.fieldMapperName = fieldMapperName;
        this.types = types;
        this.mapperCallGenerator = mapperCallGenerator;
        this.nativeTypeExtractGenerator = nativeTypeExtractGenerator;
        this.nullCheckGenerator = nullCheckGenerator;
    }

    public ReadEntityCodeBlock readEntity(String variableName, DbEntity entity) {
        CodeBlock.Builder b = CodeBlock.builder();
        ArrayList<RequiredField> fields = new ArrayList<RequiredField>();
        for (DbEntity.Column entityField : entity.columns()) {
            TypeName type;
            CommonUtils.MappersData mapping = CommonUtils.parseMapping((Element)entityField.element());
            CommonUtils.MappingData mapper = mapping.getMapping(this.fieldMapperName);
            String fieldName = entityField.variableName();
            String mapperFieldName = "_" + fieldName + "Mapper";
            FieldData fieldData = new FieldData(entityField.type(), mapperFieldName, entityField.columnName(), fieldName, entityField.isNullable());
            TypeName mapperTypeParameter = TypeName.get((TypeMirror)entityField.type()).box();
            TypeName typeName = type = entityField.isNullable() ? TypeName.get((TypeMirror)fieldData.type()).box() : TypeName.get((TypeMirror)fieldData.type());
            if (mapper != null) {
                TypeName mapperType = mapper.mapperClass() != null ? TypeName.get((TypeMirror)mapper.mapperClass()) : ParameterizedTypeName.get((ClassName)this.fieldMapperName, (TypeName[])new TypeName[]{mapperTypeParameter});
                AnnotationSpec tag = mapper.toTagAnnotation();
                if (mapper.mapperClass() != null && tag == null && CommonUtils.hasDefaultConstructorAndFinal((Types)this.types, (TypeMirror)mapper.mapperClass())) {
                    fields.add(new RequiredField(FieldSpec.builder((TypeName)TypeName.get((TypeMirror)mapper.mapperClass()), (String)mapperFieldName, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("new $T()", new Object[]{mapper.mapperClass()}).build(), null));
                } else {
                    ParameterSpec.Builder param = ParameterSpec.builder((TypeName)mapperType, (String)mapperFieldName, (Modifier[])new Modifier[0]);
                    if (tag != null) {
                        param.addAnnotation(tag);
                    }
                    fields.add(new RequiredField(FieldSpec.builder((TypeName)mapperType, (String)mapperFieldName, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build(), param.build()));
                }
                b.add("$T $L = $L;\n", new Object[]{type, fieldName, this.mapperCallGenerator.apply(fieldData)});
            } else {
                CodeBlock extractNative = this.nativeTypeExtractGenerator.apply(fieldData);
                if (extractNative != null) {
                    b.add("$T $L = $L;\n", new Object[]{type, fieldName, extractNative});
                } else {
                    ParameterizedTypeName mapperType = ParameterizedTypeName.get((ClassName)this.fieldMapperName, (TypeName[])new TypeName[]{mapperTypeParameter});
                    fields.add(new RequiredField(FieldSpec.builder((TypeName)mapperType, (String)mapperFieldName, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build(), ParameterSpec.builder((TypeName)mapperType, (String)mapperFieldName, (Modifier[])new Modifier[0]).build()));
                    b.add("$T $L = $L;\n", new Object[]{type, fieldName, this.mapperCallGenerator.apply(fieldData)});
                }
            }
            b.add(this.nullCheckGenerator.apply(fieldData));
        }
        b.add(entity.buildEmbeddedFields());
        b.add(entity.buildInstance(variableName));
        return new ReadEntityCodeBlock(b.build(), fields);
    }

    public record FieldData(TypeMirror type, String mapperFieldName, String columnName, String fieldName, boolean nullable) {
    }

    public record RequiredField(FieldSpec field, @Nullable ParameterSpec constructorParam) {
    }

    public record ReadEntityCodeBlock(CodeBlock block, List<RequiredField> requiredFields) {
        public void enrich(TypeSpec.Builder type, MethodSpec.Builder constructor) {
            for (RequiredField requiredField : this.requiredFields) {
                type.addField(requiredField.field);
                if (requiredField.constructorParam() == null) continue;
                constructor.addParameter(requiredField.constructorParam);
                constructor.addCode("this.$L = $L;\n", new Object[]{requiredField.field.name, requiredField.constructorParam().name});
            }
        }
    }
}

