/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.database.annotation.processor;

import com.squareup.javapoet.ClassName;
import jakarta.annotation.Nullable;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import ru.tinkoff.kora.annotation.processor.common.AnnotationUtils;
import ru.tinkoff.kora.annotation.processor.common.ProcessingError;
import ru.tinkoff.kora.annotation.processor.common.ProcessingErrorException;
import ru.tinkoff.kora.common.naming.NameConverter;
import ru.tinkoff.kora.common.naming.SnakeCaseNameConverter;
import ru.tinkoff.kora.database.annotation.processor.DbUtils;

public class EntityUtils {
    private static final SnakeCaseNameConverter defaultColumnNameConverter = new SnakeCaseNameConverter();

    public static String parseColumnName(VariableElement element, @Nullable NameConverter columnsNameConverter) {
        AnnotationMirror column = AnnotationUtils.findAnnotation((Element)element, (ClassName)DbUtils.COLUMN_ANNOTATION);
        String fieldName = element.getSimpleName().toString();
        if (column != null) {
            return (String)AnnotationUtils.parseAnnotationValueWithoutDefault((AnnotationMirror)column, (String)"value");
        }
        return columnsNameConverter == null ? defaultColumnNameConverter.convert(fieldName) : columnsNameConverter.convert(fieldName);
    }

    public static ExecutableElement findEntityConstructor(TypeElement type) throws ProcessingErrorException {
        List<ExecutableElement> constructors = type.getEnclosedElements().stream().filter(e -> e.getKind() == ElementKind.CONSTRUCTOR).map(ExecutableElement.class::cast).filter(e -> e.getModifiers().contains((Object)Modifier.PUBLIC)).toList();
        if (constructors.isEmpty()) {
            throw new ProcessingErrorException(List.of(new ProcessingError("Entity type " + type + " has no public constructors", (Element)type)));
        }
        if (constructors.size() == 1) {
            return constructors.get(0);
        }
        List<ExecutableElement> entityConstructors = constructors.stream().filter(c -> AnnotationUtils.findAnnotation((Element)c, (ClassName)DbUtils.ENTITY_CONSTRUCTOR_ANNOTATION) != null).toList();
        if (entityConstructors.isEmpty()) {
            throw new ProcessingErrorException(List.of(new ProcessingError("Entity type " + type + " has more than one public constructor and none of them is marked with @EntityConstructor", (Element)type)));
        }
        if (entityConstructors.size() != 1) {
            throw new ProcessingErrorException(List.of(new ProcessingError("Entity type " + type + " has more than one public constructor and more then one of them is marked with @EntityConstructor", (Element)type)));
        }
        return entityConstructors.get(0);
    }
}

