/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.database.annotation.processor;

import com.squareup.javapoet.ClassName;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.RecordComponentElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import ru.tinkoff.kora.annotation.processor.common.AnnotationUtils;
import ru.tinkoff.kora.annotation.processor.common.CommonUtils;
import ru.tinkoff.kora.annotation.processor.common.MethodUtils;
import ru.tinkoff.kora.annotation.processor.common.ProcessingErrorException;
import ru.tinkoff.kora.common.naming.NameConverter;
import ru.tinkoff.kora.common.naming.SnakeCaseNameConverter;
import ru.tinkoff.kora.database.annotation.processor.DbUtils;

final class QueryMacrosParser {
    private static final String MACROS_START = "%{";
    private static final String MACROS_END = "}";
    private static final String TARGET_RETURN = "return";
    private static final String SPECIAL_ID = "@id";
    private final Types types;

    QueryMacrosParser(Types types) {
        this.types = types;
    }

    public String parse(String sqlWithSyntax, DeclaredType repositoryType, ExecutableElement method) {
        StringBuilder sqlBuilder = new StringBuilder();
        int prevCmdIndex = 0;
        int cmdIndexStart;
        while ((cmdIndexStart = sqlWithSyntax.indexOf(MACROS_START, prevCmdIndex)) != -1) {
            int cmdIndexEnd = sqlWithSyntax.indexOf(MACROS_END, cmdIndexStart);
            String targetAndCmdAsStr = sqlWithSyntax.substring(cmdIndexStart + 2, cmdIndexEnd);
            String substitution = this.getSubstitution(targetAndCmdAsStr, repositoryType, method);
            sqlBuilder.append(sqlWithSyntax, prevCmdIndex, cmdIndexStart).append(substitution);
            prevCmdIndex = cmdIndexEnd + 1;
        }
        return sqlBuilder.append(sqlWithSyntax.substring(prevCmdIndex)).toString();
    }

    private List<Field> getPathField(DeclaredType target, String rootPath, String columnPrefix) {
        ArrayList<Field> result = new ArrayList<Field>();
        for (Element field : this.getFields(target)) {
            String path = rootPath.isEmpty() ? field.getSimpleName().toString() : rootPath + "." + field.getSimpleName().toString();
            boolean isId = AnnotationUtils.isAnnotationPresent((Element)field, (ClassName)DbUtils.ID_ANNOTATION);
            AnnotationMirror embedded = AnnotationUtils.findAnnotation((Element)field, (ClassName)DbUtils.EMBEDDED_ANNOTATION);
            if (embedded != null) {
                TypeMirror typeMirror = field.asType();
                if (typeMirror instanceof DeclaredType) {
                    DeclaredType dt = (DeclaredType)typeMirror;
                    String prefix = Objects.requireNonNullElse((String)AnnotationUtils.parseAnnotationValueWithoutDefault((AnnotationMirror)embedded, (String)"value"), "");
                    for (Field f : this.getPathField(dt, path, prefix)) {
                        result.add(new Field(f.field(), f.column(), f.path(), isId));
                    }
                    continue;
                }
                throw new IllegalArgumentException("@Embedded annotation placed on field that can't be embedded: " + target);
            }
            String columnName = this.getColumnName(target, field, columnPrefix);
            result.add(new Field(field, columnName, path, isId));
        }
        return result;
    }

    private String getColumnName(DeclaredType target, Element field, String columnPrefix) {
        AnnotationMirror column = AnnotationUtils.findAnnotation((Element)field, (ClassName)DbUtils.COLUMN_ANNOTATION);
        String columnName = (String)AnnotationUtils.parseAnnotationValueWithoutDefault((AnnotationMirror)column, (String)"value");
        if (columnName == null || columnName.isEmpty()) {
            NameConverter nameConverter = CommonUtils.getNameConverter((NameConverter)SnakeCaseNameConverter.INSTANCE, (TypeElement)((TypeElement)target.asElement()));
            return columnPrefix.isBlank() ? nameConverter.convert(field.getSimpleName().toString()) : columnPrefix + nameConverter.convert(field.getSimpleName().toString());
        }
        return columnPrefix.isBlank() ? columnName : columnPrefix + columnName;
    }

    private Set<String> getCommandSelectorPaths(DeclaredType type, String rootPath, String selects) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        List<Element> fields = this.getFields(type);
        for (String fieldName : selects.strip().split(",")) {
            boolean isEmbedded;
            fieldName = fieldName.strip();
            Element field = null;
            if (fieldName.equals(SPECIAL_ID)) {
                for (Element f : fields) {
                    if (!AnnotationUtils.isAnnotationPresent((Element)f, (ClassName)DbUtils.ID_ANNOTATION)) continue;
                    field = f;
                }
                if (field == null) {
                    throw new IllegalArgumentException("@Id annotated field not found, but was present in query marcos: " + selects.strip());
                }
            } else {
                for (Element f : fields) {
                    if (!f.getSimpleName().contentEquals(fieldName)) continue;
                    field = f;
                }
                if (field == null) {
                    throw new IllegalArgumentException("Field '" + fieldName + "' not found, but was present in query marcos: " + selects.strip());
                }
            }
            if (isEmbedded = AnnotationUtils.isAnnotationPresent((Element)field, (ClassName)DbUtils.EMBEDDED_ANNOTATION)) {
                TypeMirror typeMirror = field.asType();
                if (typeMirror instanceof DeclaredType) {
                    DeclaredType dt = (DeclaredType)typeMirror;
                    for (Element embeddedField : this.getFields(dt)) {
                        result.add(rootPath + "." + field.getSimpleName() + "." + embeddedField.getSimpleName());
                    }
                } else {
                    throw new IllegalArgumentException("@Id @Embedded annotated illegal field in query marcos: " + selects.strip());
                }
            }
            result.add(rootPath + "." + field.getSimpleName());
        }
        return result;
    }

    private List<Element> getFields(DeclaredType type) {
        if (type.asElement().getKind() == ElementKind.RECORD) {
            return type.asElement().getEnclosedElements().stream().filter(e -> e instanceof RecordComponentElement).map(e -> e).toList();
        }
        return type.asElement().getEnclosedElements().stream().filter(e -> e instanceof VariableElement).map(e -> e).toList();
    }

    private String getSubstitution(String targetAndCommand, DeclaredType repositoryType, ExecutableElement method) {
        try {
            boolean include;
            String[] targetAndCmd = targetAndCommand.split("#");
            if (targetAndCmd.length == 1) {
                throw new ProcessingErrorException("Can't extract query marcos and target from: " + targetAndCommand, (Element)method);
            }
            Target target = this.getTarget(targetAndCmd[0].strip(), repositoryType, method);
            String[] selectors = targetAndCmd[1].split("-=");
            if (selectors.length == 1) {
                include = true;
                selectors = targetAndCmd[1].split("=");
            } else {
                include = false;
            }
            String commandAsStr = selectors[0].strip().toLowerCase();
            Set paths = selectors.length != 1 ? this.getCommandSelectorPaths(target.type(), target.name(), selectors[1]) : Set.of();
            List<Field> fields = paths.isEmpty() ? this.getPathField(target.type(), target.name(), "") : this.getPathField(target.type(), target.name(), "").stream().filter(f -> include == paths.contains(f.path())).toList();
            String tableName = target.type().asElement().getAnnotationMirrors().stream().filter(a -> DbUtils.TABLE_ANNOTATION.equals((Object)ClassName.get((TypeMirror)a.getAnnotationType()))).findFirst().map(a -> (String)AnnotationUtils.parseAnnotationValueWithoutDefault((AnnotationMirror)a, (String)"value")).orElseGet(() -> {
                NameConverter nameConverter = Optional.ofNullable(CommonUtils.getNameConverter((TypeElement)((TypeElement)target.type().asElement()))).orElseGet(SnakeCaseNameConverter::new);
                return nameConverter.convert(target.type().asElement().getSimpleName().toString());
            });
            return switch (commandAsStr) {
                case "table" -> tableName;
                case "selects" -> fields.stream().map(Field::column).collect(Collectors.joining(", "));
                case "inserts" -> {
                    String tableAndColumnPrefix = fields.stream().map(Field::column).collect(Collectors.joining(", ", tableName + "(", ")"));
                    String inserts = fields.stream().map(f -> ":" + f.path()).collect(Collectors.joining(", ", "VALUES (", ")"));
                    yield tableAndColumnPrefix + " " + inserts;
                }
                case "updates" -> fields.stream().filter(f -> !f.isId()).map(f -> f.column() + " = :" + f.path()).collect(Collectors.joining(", "));
                case "where" -> fields.stream().map(f -> f.column() + " = :" + f.path()).collect(Collectors.joining(" AND "));
                default -> throw new ProcessingErrorException("Unknown query marcos specified: " + targetAndCommand, (Element)method);
            };
        }
        catch (IllegalArgumentException e) {
            throw new ProcessingErrorException(e.getMessage(), (Element)method);
        }
    }

    private Target getTarget(String targetName, DeclaredType repositoryType, ExecutableElement method) {
        ExecutableType methodType = (ExecutableType)this.types.asMemberOf(repositoryType, method);
        TypeMirror targetMirror = null;
        if (TARGET_RETURN.equals(targetName)) {
            if (MethodUtils.isVoid((ExecutableElement)method)) {
                throw new ProcessingErrorException("Macros command specified 'return' target, but return value is type Void", (Element)method);
            }
            if (method.getReturnType().toString().equals(DbUtils.UPDATE_COUNT.canonicalName())) {
                throw new ProcessingErrorException("Macros command specified 'return' target, but return value is type UpdateCount", (Element)method);
            }
            if (CommonUtils.isFuture((TypeMirror)methodType.getReturnType()) || CommonUtils.isMono((TypeMirror)methodType.getReturnType()) || CommonUtils.isFlux((TypeMirror)methodType.getReturnType()) || CommonUtils.isOptional((TypeMirror)methodType.getReturnType()) || CommonUtils.isCollection((TypeMirror)methodType.getReturnType())) {
                targetMirror = (TypeMirror)MethodUtils.getGenericType((TypeMirror)methodType.getReturnType()).orElseThrow();
                if (CommonUtils.isOptional((TypeMirror)targetMirror) || CommonUtils.isCollection((TypeMirror)targetMirror)) {
                    targetMirror = (TypeMirror)MethodUtils.getGenericType((TypeMirror)targetMirror).orElseThrow();
                }
            } else {
                targetMirror = methodType.getReturnType();
            }
        } else {
            List<? extends VariableElement> parameters = method.getParameters();
            for (int i = 0; i < parameters.size(); ++i) {
                VariableElement parameter = parameters.get(i);
                if (!parameter.getSimpleName().contentEquals(targetName)) continue;
                targetMirror = methodType.getParameterTypes().get(i);
            }
            if (targetMirror == null) {
                throw new ProcessingErrorException("Macros command unspecified target received: " + targetName, (Element)method);
            }
            if ((CommonUtils.isCollection(targetMirror) || CommonUtils.isOptional(targetMirror)) && (CommonUtils.isOptional((TypeMirror)(targetMirror = (TypeMirror)MethodUtils.getGenericType(targetMirror).orElseThrow())) || CommonUtils.isCollection((TypeMirror)targetMirror))) {
                targetMirror = (TypeMirror)MethodUtils.getGenericType((TypeMirror)targetMirror).orElseThrow();
            }
        }
        if (targetMirror instanceof DeclaredType) {
            DeclaredType dt = (DeclaredType)targetMirror;
            return new Target(dt, targetName);
        }
        throw new ProcessingErrorException("Macros command unprocessable target type: " + targetName, (Element)method);
    }

    record Field(Element field, String column, String path, boolean isId) {
    }

    record Target(DeclaredType type, String name) {
    }
}

