/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.database.annotation.processor;

import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;
import ru.tinkoff.kora.annotation.processor.common.AbstractKoraProcessor;
import ru.tinkoff.kora.annotation.processor.common.CommonUtils;
import ru.tinkoff.kora.annotation.processor.common.LogUtils;
import ru.tinkoff.kora.annotation.processor.common.ProcessingError;
import ru.tinkoff.kora.annotation.processor.common.ProcessingErrorException;
import ru.tinkoff.kora.database.annotation.processor.DbUtils;
import ru.tinkoff.kora.database.annotation.processor.RepositoryBuilder;

public class RepositoryAnnotationProcessor
extends AbstractKoraProcessor {
    private static final Logger log = LoggerFactory.getLogger(RepositoryAnnotationProcessor.class);
    private RepositoryBuilder repositoryBuilder;
    private boolean initialized = false;
    private TypeElement repositoryAnnotation;

    public Set<String> getSupportedAnnotationTypes() {
        return Set.of(DbUtils.REPOSITORY_ANNOTATION.canonicalName());
    }

    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.repositoryAnnotation = processingEnv.getElementUtils().getTypeElement(DbUtils.REPOSITORY_ANNOTATION.canonicalName());
        if (this.repositoryAnnotation == null) {
            return;
        }
        this.initialized = true;
        this.repositoryBuilder = new RepositoryBuilder(processingEnv);
    }

    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (!this.initialized) {
            return false;
        }
        Set<? extends Element> elements = roundEnv.getElementsAnnotatedWith(this.repositoryAnnotation);
        LogUtils.logElementsFull((Logger)log, (Level)Level.DEBUG, (String)"Generating Repository for", elements);
        for (Element element : elements) {
            try {
                this.processClass(element);
            }
            catch (ProcessingErrorException e) {
                e.printError(this.processingEnv);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return false;
    }

    private void processClass(Element classElement) throws IOException {
        if (classElement.getKind() != ElementKind.INTERFACE && classElement.getKind() == ElementKind.CLASS && !classElement.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            throw new ProcessingErrorException(List.of(new ProcessingError("@Repository is only applicable to interfaces and abstract classes", classElement)));
        }
        TypeSpec typeSpec = this.repositoryBuilder.build((TypeElement)classElement);
        if (typeSpec == null) {
            return;
        }
        PackageElement packageElement = this.processingEnv.getElementUtils().getPackageOf(classElement);
        String packageName = packageElement.getQualifiedName().toString();
        JavaFile javaFile = JavaFile.builder((String)packageName, (TypeSpec)typeSpec).build();
        CommonUtils.safeWriteTo((ProcessingEnvironment)this.processingEnv, (JavaFile)javaFile);
    }
}

