/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.database.annotation.processor.cassandra;

import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import ru.tinkoff.kora.annotation.processor.common.AbstractKoraProcessor;
import ru.tinkoff.kora.database.annotation.processor.cassandra.CassandraTypes;
import ru.tinkoff.kora.database.annotation.processor.cassandra.UserDefinedTypeResultExtractorGenerator;
import ru.tinkoff.kora.database.annotation.processor.cassandra.UserDefinedTypeStatementSetterGenerator;

public class CassandraUdtAnnotationProcessor
extends AbstractKoraProcessor {
    private UserDefinedTypeResultExtractorGenerator resultExtractorGenerator;
    private UserDefinedTypeStatementSetterGenerator statementSetterGenerator;

    public Set<String> getSupportedAnnotationTypes() {
        return Set.of(CassandraTypes.UDT_ANNOTATION.canonicalName());
    }

    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.resultExtractorGenerator = new UserDefinedTypeResultExtractorGenerator(processingEnv);
        this.statementSetterGenerator = new UserDefinedTypeStatementSetterGenerator(processingEnv);
    }

    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (TypeElement typeElement : annotations) {
            for (Element element : roundEnv.getElementsAnnotatedWith(typeElement)) {
                TypeMirror type = element.asType();
                this.statementSetterGenerator.generate(type);
                this.resultExtractorGenerator.generate(type);
            }
        }
        return false;
    }
}

