/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.database.annotation.processor.cassandra;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Objects;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeMirror;
import ru.tinkoff.kora.annotation.processor.common.CommonUtils;
import ru.tinkoff.kora.annotation.processor.common.FieldFactory;
import ru.tinkoff.kora.database.annotation.processor.QueryWithParameters;
import ru.tinkoff.kora.database.annotation.processor.cassandra.CassandraNativeType;
import ru.tinkoff.kora.database.annotation.processor.cassandra.CassandraNativeTypes;
import ru.tinkoff.kora.database.annotation.processor.cassandra.CassandraTypes;
import ru.tinkoff.kora.database.annotation.processor.entity.DbEntity;
import ru.tinkoff.kora.database.annotation.processor.model.QueryParameter;

public class StatementSetterGenerator {
    public static void generate(MethodSpec.Builder b, ExecutableElement method, QueryWithParameters sqlWithParameters, List<QueryParameter> parameters, @Nullable QueryParameter batchParam, FieldFactory parameterMappers) {
        if (batchParam != null) {
            b.addCode("var _batch = $T.builder($T.UNLOGGED);\n", new Object[]{CassandraTypes.BATCH_STATEMENT, CassandraTypes.DEFAULT_BATCH_TYPE});
            b.addCode("for (var _param_$L : $L) {$>\n", new Object[]{batchParam.name(), batchParam.name()});
        }
        for (int i = 0; i < parameters.size(); ++i) {
            QueryParameter parameter = parameters.get(i);
            if (parameter instanceof QueryParameter.ConnectionParameter) continue;
            Object parameterName = parameter.name();
            if (parameter instanceof QueryParameter.BatchParameter) {
                QueryParameter.BatchParameter batchParameter = (QueryParameter.BatchParameter)parameter;
                parameter = batchParameter.parameter();
                parameterName = "_param_" + parameter.name();
            }
            if (parameter instanceof QueryParameter.SimpleParameter) {
                QueryParameter.SimpleParameter nativeParameter = (QueryParameter.SimpleParameter)parameter;
                boolean isNullable = CommonUtils.isNullable((AnnotatedConstruct)parameter.variable());
                QueryWithParameters.QueryParameter sqlParameter = Objects.requireNonNull(sqlWithParameters.find(i));
                if (isNullable) {
                    b.addCode("if ($L == null) {\n", new Object[]{parameter.variable()});
                    for (Integer idx : sqlParameter.sqlIndexes()) {
                        b.addCode("  _stmt.setToNull($L);\n", new Object[]{idx});
                    }
                    b.addCode("} else {$>\n", new Object[0]);
                }
                CassandraNativeType nativeType = CassandraNativeTypes.findNativeType(ClassName.get((TypeMirror)parameter.type()));
                CommonUtils.MappingData mapping = CommonUtils.parseMapping((Element)parameter.variable()).getMapping(CassandraTypes.PARAMETER_COLUMN_MAPPER);
                if (nativeType != null && mapping == null) {
                    for (Integer n : sqlParameter.sqlIndexes()) {
                        b.addCode(nativeType.bind("_stmt", (String)parameterName, n)).addCode(";\n", new Object[0]);
                    }
                } else if (mapping != null && mapping.mapperClass() != null) {
                    for (Integer n : sqlParameter.sqlIndexes()) {
                        mapper = parameterMappers.get(CassandraTypes.PARAMETER_COLUMN_MAPPER, mapping, parameter.type());
                        b.addCode("$L.apply(_stmt, $L, $L);\n", new Object[]{mapper, n, parameter.variable()});
                    }
                } else {
                    for (Integer n : sqlParameter.sqlIndexes()) {
                        mapper = parameterMappers.get(CassandraTypes.PARAMETER_COLUMN_MAPPER, parameter.type(), (Element)parameter.variable());
                        b.addCode("$L.apply(_stmt, $L, $L);\n", new Object[]{mapper, n, parameter.variable()});
                    }
                }
                if (isNullable) {
                    b.addCode("$<\n}\n", new Object[0]);
                }
            }
            if (!(parameter instanceof QueryParameter.EntityParameter)) continue;
            QueryParameter.EntityParameter dtoParameter = (QueryParameter.EntityParameter)parameter;
            for (DbEntity.Column field : dtoParameter.entity().columns()) {
                boolean isNullable = field.isNullable();
                QueryWithParameters.QueryParameter sqlParameter = sqlWithParameters.find(field.queryParameterName(dtoParameter.name()));
                if (sqlParameter == null || sqlParameter.sqlIndexes().isEmpty()) continue;
                String fieldAccessor = CodeBlock.of((String)"$N.$N()", (Object[])new Object[]{parameterName, field.accessor()}).toString();
                if (isNullable) {
                    b.addCode("if ($L == null) {\n", new Object[]{fieldAccessor});
                    for (Integer idx2 : sqlParameter.sqlIndexes()) {
                        b.addCode("  _stmt.setToNull($L);\n", new Object[]{idx2});
                    }
                    b.addCode("} else {$>\n", new Object[0]);
                }
                CassandraNativeType cassandraNativeType = CassandraNativeTypes.findNativeType(TypeName.get((TypeMirror)field.type()));
                CommonUtils.MappingData mapping = CommonUtils.parseMapping((Element)field.element()).getMapping(CassandraTypes.PARAMETER_COLUMN_MAPPER);
                if (cassandraNativeType != null && mapping == null) {
                    for (Integer idx : sqlParameter.sqlIndexes()) {
                        b.addCode(cassandraNativeType.bind("_stmt", fieldAccessor, idx)).addCode(";\n", new Object[0]);
                    }
                } else if (mapping != null && mapping.mapperClass() != null) {
                    for (Integer idx : sqlParameter.sqlIndexes()) {
                        mapper = parameterMappers.get(CassandraTypes.PARAMETER_COLUMN_MAPPER, mapping, field.type());
                        b.addCode("$L.apply(_stmt, $L, $L);\n", new Object[]{mapper, idx, fieldAccessor});
                    }
                } else {
                    for (Integer idx : sqlParameter.sqlIndexes()) {
                        mapper = parameterMappers.get(CassandraTypes.PARAMETER_COLUMN_MAPPER, field.type(), (Element)field.element());
                        b.addCode("$L.apply(_stmt, $L, $L);\n", new Object[]{mapper, idx, fieldAccessor});
                    }
                }
                if (!isNullable) continue;
                b.addCode("$<\n}\n", new Object[0]);
            }
        }
        if (batchParam != null) {
            b.addStatement("var _builtStatement = _stmt.build()", new Object[0]);
            b.addStatement("_batch.addStatement(_builtStatement)", new Object[0]);
            b.addCode("_stmt = new $T(_builtStatement);$<\n}\n", new Object[]{ClassName.get((String)"com.datastax.oss.driver.api.core.cql", (String)"BoundStatementBuilder", (String[])new String[0])});
            b.addCode("var _s = _batch.build();\n", new Object[0]);
        } else {
            b.addCode("var _s = _stmt.build();\n", new Object[0]);
        }
    }
}

