/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.database.annotation.processor.cassandra;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import ru.tinkoff.kora.annotation.processor.common.CommonClassNames;
import ru.tinkoff.kora.annotation.processor.common.CommonUtils;
import ru.tinkoff.kora.annotation.processor.common.NameUtils;
import ru.tinkoff.kora.database.annotation.processor.cassandra.CassandraNativeType;
import ru.tinkoff.kora.database.annotation.processor.cassandra.CassandraNativeTypes;
import ru.tinkoff.kora.database.annotation.processor.cassandra.CassandraTypes;
import ru.tinkoff.kora.database.annotation.processor.entity.DbEntity;

public class UserDefinedTypeResultExtractorGenerator {
    private final ProcessingEnvironment processingEnv;
    private final Elements elements;
    private final Types types;

    public UserDefinedTypeResultExtractorGenerator(ProcessingEnvironment processingEnvironment) {
        this.processingEnv = processingEnvironment;
        this.elements = processingEnvironment.getElementUtils();
        this.types = processingEnvironment.getTypeUtils();
    }

    public void generate(TypeMirror type) {
        this.generateMapper(type);
        this.generateListMapper(type);
    }

    public void generateMapper(TypeMirror type) {
        Element element = this.types.asElement(type);
        TypeName typeName = TypeName.get((TypeMirror)type);
        PackageElement packageName = this.elements.getPackageOf(element);
        TypeSpec.Builder typeSpec = TypeSpec.classBuilder((String)NameUtils.generatedType((Element)element, (ClassName)CassandraTypes.RESULT_COLUMN_MAPPER)).addAnnotation(AnnotationSpec.builder((ClassName)CommonClassNames.koraGenerated).addMember("value", CodeBlock.of((String)"$S", (Object[])new Object[]{UserDefinedTypeResultExtractorGenerator.class.getCanonicalName()})).build()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)CassandraTypes.RESULT_COLUMN_MAPPER, (TypeName[])new TypeName[]{typeName}));
        MethodSpec.Builder constructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC});
        DbEntity entity = Objects.requireNonNull(DbEntity.parseEntity(this.types, type));
        this.addMappers(typeSpec, constructor, entity);
        MethodSpec.Builder apply = MethodSpec.methodBuilder((String)"apply").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter((TypeName)CassandraTypes.GETTABLE_BY_NAME, "_row", new Modifier[0]).addParameter(Integer.TYPE, "_index", new Modifier[0]).returns(typeName);
        apply.addStatement("var _object = _row.getUdtValue(_index)", new Object[0]);
        apply.beginControlFlow("if (_object == null)", new Object[0]).addStatement("return null", new Object[0]).endControlFlow();
        apply.addStatement("var _type = ($T) _row.getType(_index)", new Object[]{CassandraTypes.USER_DEFINED_TYPE});
        this.readIndexes(apply, entity);
        this.readFields(apply, entity);
        apply.addCode(entity.buildInstance("_result"));
        apply.addStatement("return _result", new Object[0]);
        typeSpec.addMethod(apply.build());
        typeSpec.addMethod(constructor.build());
        JavaFile javaFile = JavaFile.builder((String)packageName.getQualifiedName().toString(), (TypeSpec)typeSpec.build()).build();
        CommonUtils.safeWriteTo((ProcessingEnvironment)this.processingEnv, (JavaFile)javaFile);
    }

    public void generateListMapper(TypeMirror type) {
        Element element = this.types.asElement(type);
        TypeName typeName = TypeName.get((TypeMirror)type);
        PackageElement packageName = this.elements.getPackageOf(element);
        TypeSpec.Builder typeSpec = TypeSpec.classBuilder((String)NameUtils.generatedType((Element)element, (String)"List_CassandraRowColumnMapper")).addAnnotation(AnnotationSpec.builder((ClassName)CommonClassNames.koraGenerated).addMember("value", CodeBlock.of((String)"$S", (Object[])new Object[]{UserDefinedTypeResultExtractorGenerator.class.getCanonicalName()})).build()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)CassandraTypes.RESULT_COLUMN_MAPPER, (TypeName[])new TypeName[]{ParameterizedTypeName.get((ClassName)CommonClassNames.list, (TypeName[])new TypeName[]{typeName})}));
        MethodSpec.Builder constructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC});
        DbEntity entity = Objects.requireNonNull(DbEntity.parseEntity(this.types, type));
        this.addMappers(typeSpec, constructor, entity);
        MethodSpec.Builder apply = MethodSpec.methodBuilder((String)"apply").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter((TypeName)CassandraTypes.GETTABLE_BY_NAME, "_row", new Modifier[0]).addParameter(Integer.TYPE, "_index", new Modifier[0]).returns((TypeName)ParameterizedTypeName.get((ClassName)CommonClassNames.list, (TypeName[])new TypeName[]{typeName}));
        apply.addStatement("var _list = _row.getList(_index, $T.class)", new Object[]{CassandraTypes.UDT_VALUE});
        apply.beginControlFlow("if (_list == null)", new Object[0]).addStatement("return null", new Object[0]).endControlFlow();
        apply.addStatement("var _listType = ($T) _row.getType(_index)", new Object[]{CassandraTypes.LIST_TYPE});
        apply.addStatement("var _type = ($T) _listType.getElementType()", new Object[]{CassandraTypes.USER_DEFINED_TYPE});
        this.readIndexes(apply, entity);
        apply.addStatement("var _resultList = new $T<$T>(_list.size())", new Object[]{ArrayList.class, typeName});
        apply.beginControlFlow("for (var _object : _list)", new Object[0]);
        this.readFields(apply, entity);
        apply.addCode(entity.buildInstance("_result"));
        apply.addStatement("_resultList.add(_result)", new Object[0]);
        apply.endControlFlow();
        apply.addStatement("return _resultList", new Object[0]);
        typeSpec.addMethod(apply.build());
        typeSpec.addMethod(constructor.build());
        JavaFile javaFile = JavaFile.builder((String)packageName.getQualifiedName().toString(), (TypeSpec)typeSpec.build()).build();
        CommonUtils.safeWriteTo((ProcessingEnvironment)this.processingEnv, (JavaFile)javaFile);
    }

    private void readFields(MethodSpec.Builder apply, DbEntity entity) {
        for (DbEntity.Column entityField : entity.columns()) {
            String fieldName = entityField.element().getSimpleName().toString();
            CodeBlock index = CodeBlock.of((String)"$N", (Object[])new Object[]{"_index_of_" + entityField.element().getSimpleName()});
            CassandraNativeType nativeType = CassandraNativeTypes.findNativeType(TypeName.get((TypeMirror)entityField.type()));
            if (nativeType != null) {
                apply.addStatement("var $N = $L", new Object[]{fieldName, nativeType.extract("_object", index)});
                continue;
            }
            String mapperName = "_" + fieldName + "_mapper";
            apply.addStatement("var $N = this.$N.apply(_object, $L)", new Object[]{fieldName, mapperName, index});
        }
        apply.addCode("\n", new Object[0]);
    }

    private void addMappers(TypeSpec.Builder typeSpec, MethodSpec.Builder constructor, DbEntity entity) {
        for (DbEntity.Column entityField : entity.columns()) {
            CassandraNativeType nativeType = CassandraNativeTypes.findNativeType(TypeName.get((TypeMirror)entityField.type()));
            if (nativeType != null) continue;
            String mapperName = "_" + entityField.element().getSimpleName() + "_mapper";
            ParameterizedTypeName mapperType = ParameterizedTypeName.get((ClassName)CassandraTypes.RESULT_COLUMN_MAPPER, (TypeName[])new TypeName[]{TypeName.get((TypeMirror)entityField.type())});
            constructor.addParameter((TypeName)mapperType, mapperName, new Modifier[0]);
            constructor.addStatement("this.$N = $N", new Object[]{mapperName, mapperName});
            typeSpec.addField((TypeName)mapperType, mapperName, new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
        }
    }

    private void readIndexes(MethodSpec.Builder apply, DbEntity entity) {
        for (DbEntity.Column entityField : entity.columns()) {
            apply.addStatement("var $N = _type.firstIndexOf($S)", new Object[]{"_index_of_" + entityField.element().getSimpleName(), entityField.columnName()});
        }
        apply.addCode("\n", new Object[0]);
    }
}

