/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.database.annotation.processor.cassandra;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import ru.tinkoff.kora.annotation.processor.common.CommonClassNames;
import ru.tinkoff.kora.annotation.processor.common.CommonUtils;
import ru.tinkoff.kora.annotation.processor.common.NameUtils;
import ru.tinkoff.kora.database.annotation.processor.cassandra.CassandraNativeType;
import ru.tinkoff.kora.database.annotation.processor.cassandra.CassandraNativeTypes;
import ru.tinkoff.kora.database.annotation.processor.cassandra.CassandraTypes;
import ru.tinkoff.kora.database.annotation.processor.entity.DbEntity;

public class UserDefinedTypeStatementSetterGenerator {
    private final Elements elements;
    private final Types types;
    private final ProcessingEnvironment processingEnv;

    public UserDefinedTypeStatementSetterGenerator(ProcessingEnvironment processingEnv) {
        this.processingEnv = processingEnv;
        this.elements = processingEnv.getElementUtils();
        this.types = processingEnv.getTypeUtils();
    }

    public void generate(TypeMirror typeMirror) {
        this.generateMapper(typeMirror);
        this.generateListMapper(typeMirror);
    }

    public void generateMapper(TypeMirror typeMirror) {
        Element element = this.types.asElement(typeMirror);
        PackageElement packageName = this.elements.getPackageOf(element);
        TypeSpec.Builder typeSpec = TypeSpec.classBuilder((String)NameUtils.generatedType((Element)element, (ClassName)CassandraTypes.PARAMETER_COLUMN_MAPPER)).addAnnotation(AnnotationSpec.builder((ClassName)CommonClassNames.koraGenerated).addMember("value", CodeBlock.of((String)"$S", (Object[])new Object[]{UserDefinedTypeStatementSetterGenerator.class.getCanonicalName()})).build()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)CassandraTypes.PARAMETER_COLUMN_MAPPER, (TypeName[])new TypeName[]{TypeName.get((TypeMirror)typeMirror)}));
        DbEntity entity = Objects.requireNonNull(DbEntity.parseEntity(this.types, typeMirror));
        MethodSpec.Builder constructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC});
        this.addMappers(typeSpec, constructor, entity);
        MethodSpec.Builder apply = MethodSpec.methodBuilder((String)"apply").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter((TypeName)CassandraTypes.SETTABLE_BY_NAME, "_stmt", new Modifier[0]).addParameter(Integer.TYPE, "_index", new Modifier[0]).addParameter(TypeName.get((TypeMirror)typeMirror), "_value", new Modifier[0]);
        apply.beginControlFlow("if (_value == null)", new Object[0]).addStatement("_stmt.setToNull(_index)", new Object[0]).addStatement("return", new Object[0]).endControlFlow();
        apply.addStatement("var _type = ($T) _stmt.getType(_index)", new Object[]{CassandraTypes.USER_DEFINED_TYPE});
        this.readIndexes(apply, entity);
        apply.addStatement("var _object = _type.newValue()", new Object[0]);
        apply.addCode("\n", new Object[0]);
        this.setFields(apply, entity);
        apply.addCode("\n", new Object[0]);
        apply.addStatement("_stmt.setUdtValue(_index, _object)", new Object[0]);
        typeSpec.addMethod(apply.build());
        typeSpec.addMethod(constructor.build());
        JavaFile javaFile = JavaFile.builder((String)packageName.getQualifiedName().toString(), (TypeSpec)typeSpec.build()).build();
        CommonUtils.safeWriteTo((ProcessingEnvironment)this.processingEnv, (JavaFile)javaFile);
    }

    public void generateListMapper(TypeMirror typeMirror) {
        Element element = this.types.asElement(typeMirror);
        PackageElement packageName = this.elements.getPackageOf(element);
        ParameterizedTypeName listType = ParameterizedTypeName.get((ClassName)CommonClassNames.list, (TypeName[])new TypeName[]{TypeName.get((TypeMirror)typeMirror)});
        TypeSpec.Builder typeSpec = TypeSpec.classBuilder((String)NameUtils.generatedType((Element)element, (String)"List_CassandraParameterColumnMapper")).addAnnotation(AnnotationSpec.builder((ClassName)CommonClassNames.koraGenerated).addMember("value", CodeBlock.of((String)"$S", (Object[])new Object[]{UserDefinedTypeStatementSetterGenerator.class.getCanonicalName()})).build()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)CassandraTypes.PARAMETER_COLUMN_MAPPER, (TypeName[])new TypeName[]{listType}));
        DbEntity entity = Objects.requireNonNull(DbEntity.parseEntity(this.types, typeMirror));
        MethodSpec.Builder constructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC});
        this.addMappers(typeSpec, constructor, entity);
        MethodSpec.Builder apply = MethodSpec.methodBuilder((String)"apply").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter((TypeName)CassandraTypes.SETTABLE_BY_NAME, "_stmt", new Modifier[0]).addParameter(Integer.TYPE, "_index", new Modifier[0]).addParameter((TypeName)listType, "_listValue", new Modifier[0]);
        apply.beginControlFlow("if (_listValue == null)", new Object[0]).addStatement("_stmt.setToNull(_index)", new Object[0]).addStatement("return", new Object[0]).endControlFlow();
        apply.addStatement("var _listType = ($T) _stmt.getType(_index)", new Object[]{CassandraTypes.LIST_TYPE});
        apply.addStatement("var _type = ($T) _listType.getElementType()", new Object[]{CassandraTypes.USER_DEFINED_TYPE});
        this.readIndexes(apply, entity);
        apply.addStatement("var _listResult = new $T<$T>(_listValue.size())", new Object[]{ArrayList.class, CassandraTypes.UDT_VALUE});
        apply.beginControlFlow("for (var _value : _listValue)", new Object[0]);
        apply.addStatement("var _object = _type.newValue()", new Object[0]);
        this.setFields(apply, entity);
        apply.addStatement("_listResult.add(_object)", new Object[0]);
        apply.endControlFlow();
        apply.addCode("\n", new Object[0]);
        apply.addStatement("_stmt.setList(_index, _listResult, $T.class)", new Object[]{CassandraTypes.UDT_VALUE});
        typeSpec.addMethod(apply.build());
        typeSpec.addMethod(constructor.build());
        JavaFile javaFile = JavaFile.builder((String)packageName.getQualifiedName().toString(), (TypeSpec)typeSpec.build()).build();
        CommonUtils.safeWriteTo((ProcessingEnvironment)this.processingEnv, (JavaFile)javaFile);
    }

    private void readIndexes(MethodSpec.Builder apply, DbEntity entity) {
        for (DbEntity.Column entityField : entity.columns()) {
            String fieldName = entityField.element().getSimpleName().toString();
            apply.addStatement("var $N = _type.firstIndexOf($S)", new Object[]{"_index_of_" + fieldName, entityField.columnName()});
        }
    }

    private void setFields(MethodSpec.Builder apply, DbEntity entity) {
        for (DbEntity.Column entityField : entity.columns()) {
            String fieldName = entityField.element().getSimpleName().toString();
            CodeBlock index = CodeBlock.of((String)"$N", (Object[])new Object[]{"_index_of_" + fieldName});
            CassandraNativeType nativeType = CassandraNativeTypes.findNativeType(TypeName.get((TypeMirror)entityField.type()));
            if (nativeType != null) {
                apply.addStatement(nativeType.bind("_object", "_value.%s()".formatted(entityField.accessor()), index));
                continue;
            }
            String mapperName = "_" + fieldName + "_mapper";
            apply.addStatement("this.$N.apply(_object, $L, _value.$N())", new Object[]{mapperName, index, entityField.accessor()});
        }
    }

    private void addMappers(TypeSpec.Builder typeSpec, MethodSpec.Builder constructor, DbEntity entity) {
        for (DbEntity.Column entityField : entity.columns()) {
            String fieldName = entityField.element().getSimpleName().toString();
            CassandraNativeType nativeType = CassandraNativeTypes.findNativeType(TypeName.get((TypeMirror)entityField.type()));
            if (nativeType != null) continue;
            String mapperName = "_" + fieldName + "_mapper";
            ParameterizedTypeName mapperType = ParameterizedTypeName.get((ClassName)CassandraTypes.PARAMETER_COLUMN_MAPPER, (TypeName[])new TypeName[]{TypeName.get((TypeMirror)entityField.type())});
            constructor.addParameter((TypeName)mapperType, mapperName, new Modifier[0]);
            constructor.addStatement("this.$N = $N", new Object[]{mapperName, mapperName});
            typeSpec.addField((TypeName)mapperType, mapperName, new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
        }
    }
}

