/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.database.annotation.processor.cassandra.extension;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import ru.tinkoff.kora.annotation.processor.common.AnnotationUtils;
import ru.tinkoff.kora.annotation.processor.common.CommonClassNames;
import ru.tinkoff.kora.annotation.processor.common.CommonUtils;
import ru.tinkoff.kora.annotation.processor.common.GenericTypeResolver;
import ru.tinkoff.kora.annotation.processor.common.NameUtils;
import ru.tinkoff.kora.common.annotation.Generated;
import ru.tinkoff.kora.database.annotation.processor.DbEntityReadHelper;
import ru.tinkoff.kora.database.annotation.processor.cassandra.CassandraNativeType;
import ru.tinkoff.kora.database.annotation.processor.cassandra.CassandraNativeTypes;
import ru.tinkoff.kora.database.annotation.processor.cassandra.CassandraTypes;
import ru.tinkoff.kora.database.annotation.processor.entity.DbEntity;
import ru.tinkoff.kora.kora.app.annotation.processor.extension.ExtensionResult;
import ru.tinkoff.kora.kora.app.annotation.processor.extension.KoraExtension;

public class CassandraTypesExtension
implements KoraExtension {
    private final Types types;
    private final Elements elements;
    private final Filer filer;
    private final DbEntityReadHelper rowMapperGenerator;

    public CassandraTypesExtension(ProcessingEnvironment env) {
        this.types = env.getTypeUtils();
        this.elements = env.getElementUtils();
        this.filer = env.getFiler();
        this.rowMapperGenerator = new DbEntityReadHelper(CassandraTypes.RESULT_COLUMN_MAPPER, this.types, fd -> CodeBlock.of((String)"this.$L.apply(_row, _idx_$L)", (Object[])new Object[]{fd.mapperFieldName(), fd.fieldName()}), fd -> {
            CassandraNativeType nativeType = CassandraNativeTypes.findNativeType(TypeName.get((TypeMirror)fd.type()));
            if (nativeType != null) {
                return nativeType.extract("_row", CodeBlock.of((String)"_idx_$L", (Object[])new Object[]{fd.fieldName()}));
            }
            return null;
        }, fd -> CodeBlock.builder().beginControlFlow("if (_row.isNull(_idx_$L))", new Object[]{fd.fieldName()}).add(fd.nullable() ? CodeBlock.of((String)"$N = null;\n", (Object[])new Object[]{fd.fieldName()}) : CodeBlock.of((String)"throw new $T($S);\n", (Object[])new Object[]{NullPointerException.class, "Result field %s is not nullable but row %s has null".formatted(fd.fieldName(), fd.columnName())})).endControlFlow().build());
    }

    @Nullable
    public KoraExtension.KoraExtensionDependencyGenerator getDependencyGenerator(RoundEnvironment roundEnvironment, TypeMirror typeMirror, Set<String> tag) {
        ParameterizedTypeName ptn;
        block11: {
            block10: {
                if (!tag.isEmpty()) {
                    return null;
                }
                TypeName typeName = TypeName.get((TypeMirror)typeMirror).withoutAnnotations();
                if (!(typeName instanceof ParameterizedTypeName)) break block10;
                ptn = (ParameterizedTypeName)typeName;
                if (typeMirror instanceof DeclaredType) break block11;
            }
            return null;
        }
        DeclaredType dt = (DeclaredType)typeMirror;
        if (ptn.rawType.equals((Object)CassandraTypes.RESULT_SET_MAPPER)) {
            return this.generateResultSetMapper(roundEnvironment, dt);
        }
        if (ptn.rawType.equals((Object)CassandraTypes.ASYNC_RESULT_SET_MAPPER)) {
            return this.generateAsyncResultSetMapper(roundEnvironment, dt);
        }
        if (ptn.rawType.equals((Object)CassandraTypes.REACTIVE_RESULT_SET_MAPPER)) {
            return this.generateReactiveResultSetMapper(roundEnvironment, ptn, dt);
        }
        if (ptn.rawType.equals((Object)CassandraTypes.ROW_MAPPER)) {
            return this.generateResultRowMapper(roundEnvironment, dt);
        }
        if (ptn.rawType.equals((Object)CassandraTypes.PARAMETER_COLUMN_MAPPER)) {
            return this.generateParameterColumnMapper(roundEnvironment, dt);
        }
        if (ptn.rawType.equals((Object)CassandraTypes.RESULT_COLUMN_MAPPER)) {
            return this.generateRowColumnMapper(roundEnvironment, dt);
        }
        return null;
    }

    private KoraExtension.KoraExtensionDependencyGenerator generateRowColumnMapper(RoundEnvironment roundEnvironment, DeclaredType dt) {
        TypeMirror entityType = dt.getTypeArguments().get(0);
        TypeElement element = (TypeElement)this.types.asElement(entityType);
        if (AnnotationUtils.findAnnotation((Element)element, (ClassName)CassandraTypes.UDT_ANNOTATION) != null) {
            return KoraExtension.KoraExtensionDependencyGenerator.generatedFrom((Elements)this.elements, (Element)element, (ClassName)CassandraTypes.RESULT_COLUMN_MAPPER);
        }
        if (element.getQualifiedName().contentEquals("java.util.List") && AnnotationUtils.findAnnotation((Element)(element = (TypeElement)this.types.asElement(entityType = ((DeclaredType)entityType).getTypeArguments().get(0))), (ClassName)CassandraTypes.UDT_ANNOTATION) != null) {
            return KoraExtension.KoraExtensionDependencyGenerator.generatedFrom((Elements)this.elements, (Element)element, (ClassName)CassandraTypes.RESULT_COLUMN_MAPPER);
        }
        return null;
    }

    private KoraExtension.KoraExtensionDependencyGenerator generateParameterColumnMapper(RoundEnvironment roundEnvironment, DeclaredType dt) {
        TypeMirror entityType = dt.getTypeArguments().get(0);
        TypeElement element = (TypeElement)this.types.asElement(entityType);
        if (AnnotationUtils.findAnnotation((Element)element, (ClassName)CassandraTypes.UDT_ANNOTATION) != null) {
            return KoraExtension.KoraExtensionDependencyGenerator.generatedFrom((Elements)this.elements, (Element)element, (ClassName)CassandraTypes.PARAMETER_COLUMN_MAPPER);
        }
        if (element.getQualifiedName().contentEquals("java.util.List") && AnnotationUtils.findAnnotation((Element)(element = (TypeElement)this.types.asElement(entityType = ((DeclaredType)entityType).getTypeArguments().get(0))), (ClassName)CassandraTypes.UDT_ANNOTATION) != null) {
            return KoraExtension.KoraExtensionDependencyGenerator.generatedFrom((Elements)this.elements, (Element)element, (ClassName)CassandraTypes.PARAMETER_COLUMN_MAPPER);
        }
        return null;
    }

    @Nullable
    private KoraExtension.KoraExtensionDependencyGenerator generateResultRowMapper(RoundEnvironment roundEnvironment, DeclaredType typeMirror) {
        TypeMirror rowType = typeMirror.getTypeArguments().get(0);
        DbEntity entity = DbEntity.parseEntity(this.types, rowType);
        if (entity == null) {
            return null;
        }
        String mapperName = NameUtils.generatedType((Element)entity.typeElement(), (ClassName)CassandraTypes.ROW_MAPPER);
        PackageElement packageElement = this.elements.getPackageOf(entity.typeElement());
        return () -> {
            TypeElement maybeGenerated = this.elements.getTypeElement(packageElement.getQualifiedName() + "." + mapperName);
            if (maybeGenerated != null) {
                List constructors = CommonUtils.findConstructors((TypeElement)maybeGenerated, m -> m.contains((Object)Modifier.PUBLIC));
                if (constructors.size() != 1) {
                    throw new IllegalStateException();
                }
                return ExtensionResult.fromExecutable((ExecutableElement)((ExecutableElement)constructors.get(0)));
            }
            TypeSpec.Builder type = TypeSpec.classBuilder((String)mapperName).addAnnotation(AnnotationSpec.builder(Generated.class).addMember("value", "$S", new Object[]{CassandraTypesExtension.class.getCanonicalName()}).build()).addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)CassandraTypes.ROW_MAPPER, (TypeName[])new TypeName[]{TypeName.get((TypeMirror)entity.typeMirror())})).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
            MethodSpec.Builder constructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC});
            MethodSpec.Builder apply = MethodSpec.methodBuilder((String)"apply").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addParameter((TypeName)CassandraTypes.ROW, "_row", new Modifier[0]).returns(TypeName.get((TypeMirror)entity.typeMirror()));
            DbEntityReadHelper.ReadEntityCodeBlock read = this.rowMapperGenerator.readEntity("_result", entity);
            read.enrich(type, constructor);
            for (DbEntity.Column field : entity.columns()) {
                apply.addCode("var _idx_$L = _row.firstIndexOf($S);\n", new Object[]{field.variableName(), field.columnName()});
            }
            apply.addCode(read.block());
            apply.addCode("return _result;\n", new Object[0]);
            type.addMethod(constructor.build());
            type.addMethod(apply.build());
            JavaFile.builder((String)packageElement.getQualifiedName().toString(), (TypeSpec)type.build()).build().writeTo(this.filer);
            return ExtensionResult.nextRound();
        };
    }

    @Nullable
    private KoraExtension.KoraExtensionDependencyGenerator generateResultSetMapper(RoundEnvironment roundEnvironment, DeclaredType typeMirror) {
        TypeMirror listType = typeMirror.getTypeArguments().get(0);
        if (!(listType instanceof DeclaredType)) {
            return null;
        }
        DeclaredType dt = (DeclaredType)listType;
        if (CommonUtils.isList((TypeMirror)listType)) {
            ParameterizedTypeName tn = (ParameterizedTypeName)TypeName.get((TypeMirror)listType);
            TypeMirror rowType = dt.getTypeArguments().get(0);
            return this.listResultSetMapper(typeMirror, tn, (DeclaredType)rowType);
        }
        return () -> {
            ExecutableElement singleResultSetMapper = this.findStaticMethod(CassandraTypes.RESULT_SET_MAPPER, "singleResultSetMapper");
            TypeVariable tp = (TypeVariable)singleResultSetMapper.getTypeParameters().get(0).asType();
            ExecutableType executableType = (ExecutableType)GenericTypeResolver.resolve((Types)this.types, Map.of(tp, listType), (TypeMirror)singleResultSetMapper.asType());
            return ExtensionResult.fromExecutable((ExecutableElement)singleResultSetMapper, (ExecutableType)executableType);
        };
    }

    @Nullable
    private KoraExtension.KoraExtensionDependencyGenerator generateAsyncResultSetMapper(RoundEnvironment roundEnvironment, DeclaredType typeMirror) {
        TypeMirror listType = typeMirror.getTypeArguments().get(0);
        if (!(listType instanceof DeclaredType)) {
            return null;
        }
        DeclaredType dt = (DeclaredType)listType;
        if (CommonUtils.isList((TypeMirror)listType)) {
            return () -> {
                ParameterizedTypeName tn = (ParameterizedTypeName)TypeName.get((TypeMirror)listType);
                TypeMirror rowType = dt.getTypeArguments().get(0);
                ExecutableElement singleResultSetMapper = this.findStaticMethod(CassandraTypes.ASYNC_RESULT_SET_MAPPER, "list");
                TypeVariable tp = (TypeVariable)singleResultSetMapper.getTypeParameters().get(0).asType();
                ExecutableType executableType = (ExecutableType)GenericTypeResolver.resolve((Types)this.types, Map.of(tp, rowType), (TypeMirror)singleResultSetMapper.asType());
                return ExtensionResult.fromExecutable((ExecutableElement)singleResultSetMapper, (ExecutableType)executableType);
            };
        }
        return () -> {
            ExecutableElement singleResultSetMapper = this.findStaticMethod(CassandraTypes.ASYNC_RESULT_SET_MAPPER, "one");
            TypeVariable tp = (TypeVariable)singleResultSetMapper.getTypeParameters().get(0).asType();
            ExecutableType executableType = (ExecutableType)GenericTypeResolver.resolve((Types)this.types, Map.of(tp, listType), (TypeMirror)singleResultSetMapper.asType());
            return ExtensionResult.fromExecutable((ExecutableElement)singleResultSetMapper, (ExecutableType)executableType);
        };
    }

    @Nullable
    private KoraExtension.KoraExtensionDependencyGenerator generateReactiveResultSetMapper(RoundEnvironment roundEnvironment, ParameterizedTypeName ptn, DeclaredType typeMirror) {
        Object e;
        if (ptn.typeArguments.size() < 2 || !((e = ptn.typeArguments.get(1)) instanceof ParameterizedTypeName)) {
            return null;
        }
        ParameterizedTypeName publisherTypeName = (ParameterizedTypeName)e;
        if (publisherTypeName.rawType.equals((Object)CommonClassNames.flux)) {
            ExecutableElement fluxMapper = this.findStaticMethod(CassandraTypes.REACTIVE_RESULT_SET_MAPPER, "flux");
            TypeMirror rowType = typeMirror.getTypeArguments().get(0);
            TypeVariable tp = (TypeVariable)fluxMapper.getTypeParameters().get(0).asType();
            ExecutableType executableType = (ExecutableType)GenericTypeResolver.resolve((Types)this.types, Map.of(tp, rowType), (TypeMirror)fluxMapper.asType());
            return () -> ExtensionResult.fromExecutable((ExecutableElement)fluxMapper, (ExecutableType)executableType);
        }
        if (publisherTypeName.rawType.equals((Object)CommonClassNames.mono)) {
            TypeMirror monoParam = typeMirror.getTypeArguments().get(0);
            TypeName monoParamTypeName = TypeName.get((TypeMirror)monoParam);
            if (monoParam instanceof DeclaredType) {
                DeclaredType monoDt = (DeclaredType)monoParam;
                if (monoParamTypeName instanceof ParameterizedTypeName) {
                    ParameterizedTypeName monoPtn = (ParameterizedTypeName)monoParamTypeName;
                    if (monoPtn.rawType.equals((Object)CommonClassNames.list)) {
                        TypeMirror rowType = monoDt.getTypeArguments().get(0);
                        ExecutableElement monoList = this.findStaticMethod(CassandraTypes.REACTIVE_RESULT_SET_MAPPER, "monoList");
                        TypeVariable tp = (TypeVariable)monoList.getTypeParameters().get(0).asType();
                        ExecutableType executableType = (ExecutableType)GenericTypeResolver.resolve((Types)this.types, Map.of(tp, rowType), (TypeMirror)monoList.asType());
                        return () -> ExtensionResult.fromExecutable((ExecutableElement)monoList, (ExecutableType)executableType);
                    }
                }
            }
            if (monoParamTypeName.equals((Object)TypeName.VOID.box())) {
                ExecutableElement monoVoid = this.findStaticMethod(CassandraTypes.REACTIVE_RESULT_SET_MAPPER, "monoVoid");
                return () -> ExtensionResult.fromExecutable((ExecutableElement)monoVoid, (ExecutableType)((ExecutableType)monoVoid.asType()));
            }
            TypeMirror rowType = monoParam;
            ExecutableElement mono = this.findStaticMethod(CassandraTypes.REACTIVE_RESULT_SET_MAPPER, "mono");
            TypeVariable tp = (TypeVariable)mono.getTypeParameters().get(0).asType();
            ExecutableType executableType = (ExecutableType)GenericTypeResolver.resolve((Types)this.types, Map.of(tp, rowType), (TypeMirror)mono.asType());
            return () -> ExtensionResult.fromExecutable((ExecutableElement)mono, (ExecutableType)executableType);
        }
        return null;
    }

    private KoraExtension.KoraExtensionDependencyGenerator listResultSetMapper(DeclaredType typeMirror, ParameterizedTypeName listType, DeclaredType rowTypeMirror) {
        PackageElement packageElement = this.elements.getPackageOf(this.types.asElement(rowTypeMirror));
        TypeName rowType = TypeName.get((TypeMirror)rowTypeMirror);
        DbEntity entity = DbEntity.parseEntity(this.types, rowTypeMirror);
        if (entity == null) {
            return () -> {
                ExecutableElement listResultSetMapper = this.findStaticMethod(CassandraTypes.RESULT_SET_MAPPER, "listResultSetMapper");
                TypeVariable tp = (TypeVariable)listResultSetMapper.getTypeParameters().get(0).asType();
                ExecutableType executableType = (ExecutableType)GenericTypeResolver.resolve((Types)this.types, Map.of(tp, rowTypeMirror), (TypeMirror)listResultSetMapper.asType());
                return ExtensionResult.fromExecutable((ExecutableElement)listResultSetMapper, (ExecutableType)executableType);
            };
        }
        Element rowTypeElement = this.types.asElement(rowTypeMirror);
        String mapperName = NameUtils.generatedType((Element)rowTypeElement, (String)"ListCassandraResultSetMapper");
        return () -> {
            TypeElement maybeGenerated = this.elements.getTypeElement(packageElement.getQualifiedName() + "." + mapperName);
            if (maybeGenerated != null) {
                List constructors = CommonUtils.findConstructors((TypeElement)maybeGenerated, m -> m.contains((Object)Modifier.PUBLIC));
                if (constructors.size() != 1) {
                    throw new IllegalStateException();
                }
                return ExtensionResult.fromExecutable((ExecutableElement)((ExecutableElement)constructors.get(0)));
            }
            TypeSpec.Builder type = TypeSpec.classBuilder((String)mapperName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addAnnotation(AnnotationSpec.builder(Generated.class).addMember("value", "$S", new Object[]{CassandraTypesExtension.class.getCanonicalName()}).build()).addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)CassandraTypes.RESULT_SET_MAPPER, (TypeName[])new TypeName[]{listType}));
            MethodSpec.Builder constructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC});
            MethodSpec.Builder apply = MethodSpec.methodBuilder((String)"apply").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).returns((TypeName)listType).addParameter((TypeName)CassandraTypes.RESULT_SET, "_rs", new Modifier[0]);
            DbEntityReadHelper.ReadEntityCodeBlock read = this.rowMapperGenerator.readEntity("_rowValue", entity);
            read.enrich(type, constructor);
            for (DbEntity.Column field : entity.columns()) {
                apply.addCode("var _idx_$L = _rs.getColumnDefinitions().firstIndexOf($S);\n", new Object[]{field.variableName(), field.columnName()});
            }
            apply.addCode("var _result = new $T<$T>(_rs.getAvailableWithoutFetching());\n", new Object[]{ArrayList.class, rowTypeMirror});
            apply.beginControlFlow("for (var _row : _rs)", new Object[0]);
            apply.addCode(read.block());
            apply.addCode("_result.add(_rowValue);\n", new Object[0]);
            apply.endControlFlow();
            apply.addCode("return _result;\n", new Object[0]);
            TypeSpec typeSpec = type.addMethod(apply.build()).addMethod(constructor.build()).build();
            JavaFile.builder((String)packageElement.getQualifiedName().toString(), (TypeSpec)typeSpec).build().writeTo(this.filer);
            return ExtensionResult.nextRound();
        };
    }

    private ExecutableElement findStaticMethod(ClassName className, String methodName) {
        return this.elements.getTypeElement(className.canonicalName()).getEnclosedElements().stream().filter(e -> e.getKind() == ElementKind.METHOD && e.getModifiers().contains((Object)Modifier.STATIC)).map(ExecutableElement.class::cast).filter(m -> m.getSimpleName().contentEquals(methodName)).findFirst().orElseThrow();
    }
}

