/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.database.annotation.processor.jdbc;

import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.TypeName;
import java.util.function.BiFunction;

public interface JdbcNativeType {
    public TypeName type();

    public CodeBlock extract(String var1, CodeBlock var2);

    public CodeBlock bind(String var1, String var2, int var3);

    public CodeBlock bindNull(String var1, int var2);

    default public JdbcNativeType boxed() {
        return JdbcNativeType.of(this.type().box(), this::extract, this::bind, this::bindNull);
    }

    public static JdbcNativeType of(TypeName type, BiFunction<String, CodeBlock, CodeBlock> extract, TriFunction<String, String, Integer, CodeBlock> bind, BiFunction<String, Integer, CodeBlock> bindNull) {
        record Impl(TypeName type, BiFunction<String, CodeBlock, CodeBlock> extract, TriFunction<String, String, Integer, CodeBlock> bind, BiFunction<String, Integer, CodeBlock> bindNull) implements JdbcNativeType
        {
            @Override
            public CodeBlock extract(String rsName, CodeBlock index) {
                return this.extract.apply(rsName, index);
            }

            @Override
            public CodeBlock bind(String stmt, String variableName, int idx) {
                return this.bind.apply(stmt, variableName, idx);
            }

            @Override
            public CodeBlock bindNull(String stmt, int idx) {
                return this.bindNull.apply(stmt, idx);
            }

            @Override
            public JdbcNativeType boxed() {
                return JdbcNativeType.of(this.type.box(), this.extract, this.bind, this.bindNull);
            }
        }
        return new Impl(type, extract, bind, bindNull);
    }

    @FunctionalInterface
    public static interface TriFunction<P1, P2, P3, R> {
        public R apply(P1 var1, P2 var2, P3 var3);
    }
}

