/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.database.annotation.processor.jdbc;

import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.TypeName;
import jakarta.annotation.Nullable;
import java.math.BigDecimal;
import java.sql.Types;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import ru.tinkoff.kora.database.annotation.processor.jdbc.JdbcNativeType;

public class JdbcNativeTypes {
    private static final List<JdbcNativeType> nativeTypes;

    @Nullable
    public static JdbcNativeType findNativeType(TypeName typeName) {
        for (JdbcNativeType nativeParameterType : nativeTypes) {
            if (!Objects.equals(nativeParameterType.type(), typeName)) continue;
            return nativeParameterType;
        }
        return null;
    }

    static {
        JdbcNativeType booleanPrimitive = JdbcNativeType.of(TypeName.BOOLEAN, (rsName, i) -> CodeBlock.of((String)"$L.getBoolean($L)", (Object[])new Object[]{rsName, i}), (stmt, var, i) -> CodeBlock.of((String)"$L.setBoolean($L, $L)", (Object[])new Object[]{stmt, i, var}), (stmtName, i) -> CodeBlock.of((String)"$L.setNull($L, $T.BOOLEAN)", (Object[])new Object[]{stmtName, i, Types.class}));
        JdbcNativeType booleanBoxed = booleanPrimitive.boxed();
        JdbcNativeType shortPrimitive = JdbcNativeType.of(TypeName.SHORT, (rsName, i) -> CodeBlock.of((String)"$L.getShort($L)", (Object[])new Object[]{rsName, i}), (stmt, var, i) -> CodeBlock.of((String)"$L.setShort($L, $L)", (Object[])new Object[]{stmt, i, var}), (stmtName, i) -> CodeBlock.of((String)"$L.setNull($L, $T.SMALLINT)", (Object[])new Object[]{stmtName, i, Types.class}));
        JdbcNativeType shortBoxed = shortPrimitive.boxed();
        JdbcNativeType intPrimitive = JdbcNativeType.of(TypeName.INT, (rsName, i) -> CodeBlock.of((String)"$L.getInt($L)", (Object[])new Object[]{rsName, i}), (stmt, var, i) -> CodeBlock.of((String)"$L.setInt($L, $L)", (Object[])new Object[]{stmt, i, var}), (stmtName, i) -> CodeBlock.of((String)"$L.setNull($L, $T.INTEGER)", (Object[])new Object[]{stmtName, i, Types.class}));
        JdbcNativeType intBoxed = intPrimitive.boxed();
        JdbcNativeType longPrimitive = JdbcNativeType.of(TypeName.LONG, (rsName, i) -> CodeBlock.of((String)"$L.getLong($L)", (Object[])new Object[]{rsName, i}), (stmt, var, i) -> CodeBlock.of((String)"$L.setLong($L, $L)", (Object[])new Object[]{stmt, i, var}), (stmtName, i) -> CodeBlock.of((String)"$L.setNull($L, $T.BIGINT)", (Object[])new Object[]{stmtName, i, Types.class}));
        JdbcNativeType longBoxed = longPrimitive.boxed();
        JdbcNativeType doublePrimitive = JdbcNativeType.of(TypeName.DOUBLE, (rsName, i) -> CodeBlock.of((String)"$L.getDouble($L)", (Object[])new Object[]{rsName, i}), (stmt, var, i) -> CodeBlock.of((String)"$L.setDouble($L, $L)", (Object[])new Object[]{stmt, i, var}), (stmtName, i) -> CodeBlock.of((String)"$L.setNull($L, $T.DOUBLE)", (Object[])new Object[]{stmtName, i, Types.class}));
        JdbcNativeType doubleBoxed = doublePrimitive.boxed();
        JdbcNativeType floatPrimitive = JdbcNativeType.of(TypeName.FLOAT, (rsName, i) -> CodeBlock.of((String)"$L.getFloat($L)", (Object[])new Object[]{rsName, i}), (stmt, var, i) -> CodeBlock.of((String)"$L.setFloat($L, $L)", (Object[])new Object[]{stmt, i, var}), (stmtName, i) -> CodeBlock.of((String)"$L.setNull($L, $T.FLOAT)", (Object[])new Object[]{stmtName, i, Types.class}));
        JdbcNativeType floatBoxed = floatPrimitive.boxed();
        JdbcNativeType string = JdbcNativeType.of((TypeName)ClassName.get(String.class), (rsName, i) -> CodeBlock.of((String)"$L.getString($L)", (Object[])new Object[]{rsName, i}), (stmt, var, i) -> CodeBlock.of((String)"$L.setString($L, $L)", (Object[])new Object[]{stmt, i, var}), (stmtName, i) -> CodeBlock.of((String)"$L.setNull($L, $T.VARCHAR)", (Object[])new Object[]{stmtName, i, Types.class}));
        JdbcNativeType bigDecimal = JdbcNativeType.of((TypeName)ClassName.get(BigDecimal.class), (rsName, i) -> CodeBlock.of((String)"$L.getObject($L, $T.class)", (Object[])new Object[]{rsName, i, BigDecimal.class}), (stmt, var, i) -> CodeBlock.of((String)"$L.setObject($L, $L, $T.NUMERIC)", (Object[])new Object[]{stmt, i, var, Types.class}), (stmtName, i) -> CodeBlock.of((String)"$L.setNull($L, $T.NUMERIC)", (Object[])new Object[]{stmtName, i, Types.class}));
        JdbcNativeType byteArray = JdbcNativeType.of((TypeName)ArrayTypeName.of((TypeName)TypeName.BYTE), (rsName, i) -> CodeBlock.of((String)"$L.getBytes($L)", (Object[])new Object[]{rsName, i}), (stmt, var, i) -> CodeBlock.of((String)"$L.setBytes($L, $L)", (Object[])new Object[]{stmt, i, var}), (stmtName, i) -> CodeBlock.of((String)"$L.setNull($L, $T.BINARY)", (Object[])new Object[]{stmtName, i, Types.class}));
        JdbcNativeType localDateTime = JdbcNativeType.of(TypeName.get(LocalDateTime.class), (rsName, i) -> CodeBlock.of((String)"$L.getObject($L, $T.class)", (Object[])new Object[]{rsName, i, LocalDateTime.class}), (stmt, var, i) -> CodeBlock.of((String)"$L.setObject($L, $L, $T.TIMESTAMP)", (Object[])new Object[]{stmt, i, var, Types.class}), (stmtName, i) -> CodeBlock.of((String)"$L.setNull($L, $T.TIMESTAMP)", (Object[])new Object[]{stmtName, i, Types.class}));
        JdbcNativeType localDate = JdbcNativeType.of(TypeName.get(LocalDate.class), (rsName, i) -> CodeBlock.of((String)"$L.getObject($L, $T.class)", (Object[])new Object[]{rsName, i, LocalDate.class}), (stmt, var, i) -> CodeBlock.of((String)"$L.setObject($L, $L, $T.DATE)", (Object[])new Object[]{stmt, i, var, Types.class}), (stmtName, i) -> CodeBlock.of((String)"$L.setNull($L, $T.DATE)", (Object[])new Object[]{stmtName, i, Types.class}));
        nativeTypes = List.of(booleanPrimitive, booleanBoxed, shortPrimitive, shortBoxed, intPrimitive, intBoxed, longPrimitive, longBoxed, doublePrimitive, doubleBoxed, floatPrimitive, floatBoxed, string, bigDecimal, byteArray, localDateTime, localDate);
    }
}

