/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.database.annotation.processor.jdbc;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import jakarta.annotation.Nullable;
import java.sql.Statement;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.LongStream;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import ru.tinkoff.kora.annotation.processor.common.AnnotationUtils;
import ru.tinkoff.kora.annotation.processor.common.CommonClassNames;
import ru.tinkoff.kora.annotation.processor.common.CommonUtils;
import ru.tinkoff.kora.annotation.processor.common.FieldFactory;
import ru.tinkoff.kora.annotation.processor.common.MethodUtils;
import ru.tinkoff.kora.annotation.processor.common.TagUtils;
import ru.tinkoff.kora.annotation.processor.common.Visitors;
import ru.tinkoff.kora.common.Tag;
import ru.tinkoff.kora.database.annotation.processor.DbUtils;
import ru.tinkoff.kora.database.annotation.processor.QueryWithParameters;
import ru.tinkoff.kora.database.annotation.processor.RepositoryGenerator;
import ru.tinkoff.kora.database.annotation.processor.jdbc.JdbcNativeTypes;
import ru.tinkoff.kora.database.annotation.processor.jdbc.JdbcTypes;
import ru.tinkoff.kora.database.annotation.processor.jdbc.StatementSetterGenerator;
import ru.tinkoff.kora.database.annotation.processor.model.QueryParameter;
import ru.tinkoff.kora.database.annotation.processor.model.QueryParameterParser;

public final class JdbcRepositoryGenerator
implements RepositoryGenerator {
    private final TypeMirror repositoryInterface;
    private final Types types;
    private final Elements elements;
    private final Filer filer;

    public JdbcRepositoryGenerator(ProcessingEnvironment processingEnv) {
        TypeElement repository = processingEnv.getElementUtils().getTypeElement(JdbcTypes.JDBC_REPOSITORY.canonicalName());
        this.repositoryInterface = repository == null ? null : repository.asType();
        this.types = processingEnv.getTypeUtils();
        this.elements = processingEnv.getElementUtils();
        this.filer = processingEnv.getFiler();
    }

    @Override
    public TypeSpec generate(TypeElement repositoryElement, TypeSpec.Builder type, MethodSpec.Builder constructor) {
        DeclaredType repositoryType = (DeclaredType)repositoryElement.asType();
        List<ExecutableElement> queryMethods = DbUtils.findQueryMethods(this.types, this.elements, repositoryElement);
        this.enrichWithExecutor(repositoryElement, type, constructor, queryMethods);
        FieldFactory resultMappers = new FieldFactory(this.types, this.elements, type, constructor, "_result_mapper_");
        FieldFactory parameterMappers = new FieldFactory(this.types, this.elements, type, constructor, "_parameter_mapper_");
        for (ExecutableElement method : queryMethods) {
            ExecutableType methodType = (ExecutableType)this.types.asMemberOf(repositoryType, method);
            List<QueryParameter> parameters = QueryParameterParser.parse(this.types, JdbcTypes.CONNECTION, JdbcTypes.PARAMETER_COLUMN_MAPPER, method, methodType);
            AnnotationMirror queryAnnotation = AnnotationUtils.findAnnotation((Element)method, (ClassName)DbUtils.QUERY_ANNOTATION);
            String queryString = (String)AnnotationUtils.parseAnnotationValueWithoutDefault((AnnotationMirror)queryAnnotation, (String)"value");
            QueryWithParameters query = QueryWithParameters.parse(this.filer, this.types, queryString, parameters, repositoryType, method);
            String resultMapper = this.parseResultMapper(method, methodType, parameters).map(rm -> DbUtils.addMapper(resultMappers, rm)).orElse(null);
            DbUtils.addMappers(parameterMappers, DbUtils.parseParameterMappers(parameters, query, tn -> JdbcNativeTypes.findNativeType(tn) != null, JdbcTypes.PARAMETER_COLUMN_MAPPER));
            MethodSpec methodSpec = this.generate(repositoryElement, method, methodType, query, parameters, resultMapper, parameterMappers);
            type.addMethod(methodSpec);
        }
        return type.addMethod(constructor.build()).build();
    }

    private Optional<DbUtils.Mapper> parseResultMapper(ExecutableElement method, ExecutableType methodType, List<QueryParameter> parameters) {
        TypeMirror returnType = methodType.getReturnType();
        if (CommonUtils.isMono((TypeMirror)returnType)) {
            returnType = (TypeMirror)Visitors.visitDeclaredType((TypeMirror)returnType, dt -> dt.getTypeArguments().get(0));
        } else if (CommonUtils.isFuture((TypeMirror)returnType)) {
            returnType = (TypeMirror)Visitors.visitDeclaredType((TypeMirror)returnType, dt -> dt.getTypeArguments().get(0));
        }
        if (CommonUtils.isVoid((TypeMirror)returnType)) {
            return Optional.empty();
        }
        QueryParameter batchParam = parameters.stream().filter(QueryParameter.BatchParameter.class::isInstance).findFirst().orElse(null);
        boolean generatedKeys = AnnotationUtils.isAnnotationPresent((Element)method, (ClassName)DbUtils.ID_ANNOTATION);
        if (batchParam != null && !generatedKeys) {
            return Optional.empty();
        }
        if (returnType.toString().equals(DbUtils.UPDATE_COUNT.canonicalName())) {
            return Optional.empty();
        }
        CommonUtils.MappersData mappings = CommonUtils.parseMapping((Element)method);
        ParameterizedTypeName mapperType = ParameterizedTypeName.get((ClassName)JdbcTypes.RESULT_SET_MAPPER, (TypeName[])new TypeName[]{TypeName.get((TypeMirror)returnType).box()});
        CommonUtils.MappingData resultSetMapper = mappings.getMapping(JdbcTypes.RESULT_SET_MAPPER);
        if (resultSetMapper != null) {
            return Optional.of(new DbUtils.Mapper(resultSetMapper.mapperClass(), (TypeName)mapperType, mappings.mapperTags()));
        }
        CommonUtils.MappingData rowMapper = mappings.getMapping(JdbcTypes.ROW_MAPPER);
        if (rowMapper != null) {
            if (CommonUtils.isList((TypeMirror)returnType)) {
                return Optional.of(new DbUtils.Mapper(rowMapper.mapperClass(), (TypeName)mapperType, mappings.mapperTags(), c -> CodeBlock.of((String)"$T.listResultSetMapper($L)", (Object[])new Object[]{JdbcTypes.RESULT_SET_MAPPER, c})));
            }
            if (CommonUtils.isOptional((TypeMirror)returnType)) {
                return Optional.of(new DbUtils.Mapper(rowMapper.mapperClass(), (TypeName)mapperType, mappings.mapperTags(), c -> CodeBlock.of((String)"$T.optionalResultSetMapper($L)", (Object[])new Object[]{JdbcTypes.RESULT_SET_MAPPER, c})));
            }
            return Optional.of(new DbUtils.Mapper(rowMapper.mapperClass(), (TypeName)mapperType, mappings.mapperTags(), c -> CodeBlock.of((String)"$T.singleResultSetMapper($L)", (Object[])new Object[]{JdbcTypes.RESULT_SET_MAPPER, c})));
        }
        return Optional.of(new DbUtils.Mapper((TypeName)mapperType, mappings.mapperTags()));
    }

    @Override
    @Nullable
    public TypeMirror repositoryInterface() {
        return this.repositoryInterface;
    }

    public MethodSpec generate(TypeElement repositoryElement, ExecutableElement method, ExecutableType methodType, QueryWithParameters query, List<QueryParameter> parameters, @Nullable String resultMapperName, FieldFactory parameterMappers) {
        QueryParameter batchParam = parameters.stream().filter(QueryParameter.BatchParameter.class::isInstance).findFirst().orElse(null);
        String sql = query.rawQuery();
        for (QueryWithParameters.QueryParameter parameter : query.parameters().stream().sorted(Comparator.comparingInt(s -> s.sqlParameterName().length()).reversed()).toList()) {
            sql = sql.replace(":" + parameter.sqlParameterName(), "?");
        }
        MethodSpec.Builder b = DbUtils.queryMethodBuilder(method, methodType);
        TypeMirror returnType = methodType.getReturnType();
        boolean isMono = CommonUtils.isMono((TypeMirror)returnType);
        boolean isFuture = CommonUtils.isFuture((TypeMirror)returnType);
        if (isMono) {
            b.addCode("return $T.fromCompletionStage(() -> $T.supplyAsync(() -> {$>\n", new Object[]{CommonClassNames.mono, CompletableFuture.class});
            returnType = ((DeclaredType)returnType).getTypeArguments().get(0);
        } else if (isFuture) {
            b.addCode("return $T.supplyAsync(() -> {$>\n", new Object[]{CompletableFuture.class});
            returnType = ((DeclaredType)returnType).getTypeArguments().get(0);
        }
        CodeBlock connection = parameters.stream().filter(QueryParameter.ConnectionParameter.class::isInstance).findFirst().map(p -> CodeBlock.of((String)"$L", (Object[])new Object[]{p.variable()})).orElse(CodeBlock.of((String)"this._connectionFactory.currentConnection()", (Object[])new Object[0]));
        b.addCode("var _conToUse = $L;\n$T _conToClose;\nif (_conToUse == null) {\n    _conToUse = this._connectionFactory.newConnection();\n    _conToClose = _conToUse;\n} else {\n    _conToClose = null;\n}\nvar _query = new $T(\n  $S,\n  $S,\n  $S\n);\nvar _telemetry = this._connectionFactory.telemetry().createContext(ru.tinkoff.kora.common.Context.current(), _query);\n", new Object[]{connection, JdbcTypes.CONNECTION, DbUtils.QUERY_CONTEXT, query.rawQuery(), sql, DbUtils.operationName(method)});
        boolean generatedKeys = AnnotationUtils.isAnnotationPresent((Element)method, (ClassName)DbUtils.ID_ANNOTATION);
        if (generatedKeys) {
            b.addCode("try (_conToClose; var _stmt = _conToUse.prepareStatement(_query.sql(), $T.RETURN_GENERATED_KEYS)) {$>\n", new Object[]{Statement.class});
        } else {
            b.addCode("try (_conToClose; var _stmt = _conToUse.prepareStatement(_query.sql())) {$>\n", new Object[0]);
        }
        b.addCode(StatementSetterGenerator.generate(method, query, parameters, batchParam, parameterMappers));
        if (MethodUtils.isVoid((ExecutableElement)method) || isMono && MethodUtils.isVoidGeneric((TypeMirror)methodType.getReturnType()) || isFuture && MethodUtils.isVoidGeneric((TypeMirror)methodType.getReturnType())) {
            if (batchParam != null) {
                b.addStatement("var _batchResult = _stmt.executeBatch()", new Object[0]);
            } else {
                b.addStatement("_stmt.execute()", new Object[0]);
                b.addStatement("var updateCount = _stmt.getUpdateCount()", new Object[0]);
            }
            b.addStatement("_telemetry.close(null)", new Object[0]);
            if (isMono) {
                b.addStatement("return null", new Object[0]);
            } else if (isFuture) {
                b.addStatement("return null", new Object[0]);
            }
        } else if (batchParam != null) {
            if (returnType.toString().equals(DbUtils.UPDATE_COUNT.canonicalName())) {
                b.addStatement("var _batchResult = _stmt.executeLargeBatch()", new Object[0]);
                b.addStatement("_telemetry.close(null)", new Object[0]);
                b.addStatement("return new $T($T.of(_batchResult).sum())", new Object[]{DbUtils.UPDATE_COUNT, LongStream.class});
            } else if (returnType.toString().equals("long[]")) {
                b.addStatement("var _batchResult = _stmt.executeLargeBatch()", new Object[0]);
                b.addStatement("_telemetry.close(null)", new Object[0]);
                b.addStatement("return _batchResult", new Object[0]);
            } else if (returnType.toString().equals("int[]")) {
                b.addStatement("var _batchResult = _stmt.executeBatch()", new Object[0]);
                b.addStatement("_telemetry.close(null)", new Object[0]);
                b.addStatement("return _batchResult", new Object[0]);
            } else if (generatedKeys) {
                CodeBlock result = CommonUtils.isNullable((AnnotatedConstruct)method) || method.getReturnType().getKind().isPrimitive() || isMono ? CodeBlock.of((String)"_result", (Object[])new Object[0]) : CodeBlock.of((String)"$T.requireNonNull(_result)", (Object[])new Object[]{Objects.class});
                b.addStatement("var _batchResult = _stmt.executeBatch()", new Object[0]);
                b.addCode("try (var _rs = _stmt.getGeneratedKeys()) {$>\n", new Object[0]).addCode("var _result = $L.apply(_rs);\n", new Object[]{resultMapperName}).addCode("_telemetry.close(null);\n", new Object[0]).addCode("return $L;", new Object[]{result}).addCode("$<\n}\n", new Object[0]);
            } else {
                b.addStatement("var _batchResult = _stmt.executeBatch()", new Object[0]);
                b.addStatement("_telemetry.close(null)", new Object[0]);
            }
        } else if (returnType.toString().equals(DbUtils.UPDATE_COUNT.canonicalName())) {
            b.addStatement("var _updateCount = _stmt.executeLargeUpdate()", new Object[0]).addStatement("_telemetry.close(null)", new Object[0]).addStatement("return new $T(_updateCount)", new Object[]{DbUtils.UPDATE_COUNT});
        } else if (generatedKeys) {
            CodeBlock result = CommonUtils.isNullable((AnnotatedConstruct)method) || method.getReturnType().getKind().isPrimitive() || isMono ? CodeBlock.of((String)"_result", (Object[])new Object[0]) : CodeBlock.of((String)"$T.requireNonNull(_result)", (Object[])new Object[]{Objects.class});
            b.addCode("_stmt.execute();\n", new Object[0]);
            b.addCode("try (var _rs = _stmt.getGeneratedKeys()) {$>\n", new Object[0]).addCode("var _result = $L.apply(_rs);\n", new Object[]{resultMapperName}).addCode("_telemetry.close(null);\n", new Object[0]).addCode("return $L;", new Object[]{result}).addCode("$<\n}\n", new Object[0]);
        } else {
            CodeBlock result = CommonUtils.isNullable((AnnotatedConstruct)method) || method.getReturnType().getKind().isPrimitive() || isMono ? CodeBlock.of((String)"_result", (Object[])new Object[0]) : CodeBlock.of((String)"$T.requireNonNull(_result)", (Object[])new Object[]{Objects.class});
            Objects.requireNonNull(resultMapperName, () -> "Illegal State occurred when expected to get result mapper, but got null in " + method.getEnclosingElement().getSimpleName() + "#" + method.getSimpleName());
            b.addCode("try (var _rs = _stmt.executeQuery()) {$>\n", new Object[0]).addCode("var _result = $L.apply(_rs);\n", new Object[]{resultMapperName}).addCode("_telemetry.close(null);\n", new Object[0]).addCode("return $L;", new Object[]{result}).addCode("$<\n}\n", new Object[0]);
        }
        b.addCode("$<\n} catch (java.sql.SQLException e) {\n", new Object[0]).addCode("  _telemetry.close(e);\n", new Object[0]).addCode("  throw new ru.tinkoff.kora.database.jdbc.RuntimeSqlException(e);\n", new Object[0]).addCode("}  catch (Exception e) {\n", new Object[0]).addCode("  _telemetry.close(e);\n", new Object[0]).addCode("  throw e;\n", new Object[0]).addCode("}\n", new Object[0]);
        if (isMono) {
            b.addCode("$<\n}, _executor));\n", new Object[0]);
        } else if (isFuture) {
            b.addCode("$<\n}, _executor);\n", new Object[0]);
        }
        return b.build();
    }

    public void enrichWithExecutor(TypeElement repositoryElement, TypeSpec.Builder builder, MethodSpec.Builder constructorBuilder, List<ExecutableElement> queryMethods) {
        builder.addField((TypeName)JdbcTypes.CONNECTION_FACTORY, "_connectionFactory", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
        builder.addSuperinterface((TypeName)JdbcTypes.JDBC_REPOSITORY);
        builder.addMethod(MethodSpec.methodBuilder((String)"getJdbcConnectionFactory").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addAnnotation(Override.class).returns((TypeName)JdbcTypes.CONNECTION_FACTORY).addCode("return this._connectionFactory;", new Object[0]).build());
        CodeBlock executorTag = DbUtils.getTag(repositoryElement);
        if (executorTag != null) {
            constructorBuilder.addParameter(ParameterSpec.builder((TypeName)JdbcTypes.CONNECTION_FACTORY, (String)"_connectionFactory", (Modifier[])new Modifier[0]).addAnnotation(AnnotationSpec.builder(Tag.class).addMember("value", executorTag).build()).build());
        } else {
            constructorBuilder.addParameter((TypeName)JdbcTypes.CONNECTION_FACTORY, "_connectionFactory", new Modifier[0]);
        }
        constructorBuilder.addStatement("this._connectionFactory = _connectionFactory", new Object[0]);
        boolean needThreadPool = queryMethods.stream().anyMatch(e -> CommonUtils.isMono((TypeMirror)e.getReturnType()) || CommonUtils.isFuture((TypeMirror)e.getReturnType()));
        if (needThreadPool && executorTag != null) {
            builder.addField(TypeName.get(Executor.class), "_executor", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
            constructorBuilder.addStatement("this._executor = _executor", new Object[0]);
            constructorBuilder.addParameter(ParameterSpec.builder((TypeName)TypeName.get(Executor.class), (String)"_executor", (Modifier[])new Modifier[0]).addAnnotation(AnnotationSpec.builder(Tag.class).addMember("value", executorTag).build()).build());
        } else if (needThreadPool) {
            builder.addField(TypeName.get(Executor.class), "_executor", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
            constructorBuilder.addStatement("this._executor = _executor", new Object[0]);
            constructorBuilder.addParameter(ParameterSpec.builder((TypeName)TypeName.get(Executor.class), (String)"_executor", (Modifier[])new Modifier[0]).addAnnotation(TagUtils.makeAnnotationSpecForTypes((TypeName[])new TypeName[]{JdbcTypes.JDBC_DATABASE})).build());
        }
    }
}

