/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.database.annotation.processor.jdbc;

import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.TypeName;
import jakarta.annotation.Nullable;
import java.util.List;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeMirror;
import ru.tinkoff.kora.annotation.processor.common.CommonUtils;
import ru.tinkoff.kora.annotation.processor.common.FieldFactory;
import ru.tinkoff.kora.database.annotation.processor.QueryWithParameters;
import ru.tinkoff.kora.database.annotation.processor.entity.DbEntity;
import ru.tinkoff.kora.database.annotation.processor.jdbc.JdbcNativeType;
import ru.tinkoff.kora.database.annotation.processor.jdbc.JdbcNativeTypes;
import ru.tinkoff.kora.database.annotation.processor.jdbc.JdbcTypes;
import ru.tinkoff.kora.database.annotation.processor.model.QueryParameter;

public class StatementSetterGenerator {
    public static CodeBlock generate(ExecutableElement method, QueryWithParameters sqlWithParameters, List<QueryParameter> parameters, @Nullable QueryParameter batchParam, FieldFactory parameterMappers) {
        CodeBlock.Builder b = CodeBlock.builder();
        if (batchParam != null) {
            b.add("for (var _i : $L) {$>\n", new Object[]{batchParam.variable()});
        }
        for (int i = 0; i < parameters.size(); ++i) {
            QueryParameter parameter = parameters.get(i);
            if (parameter instanceof QueryParameter.ConnectionParameter) continue;
            int _i = i;
            String parameterName = parameter.name();
            if (parameter instanceof QueryParameter.BatchParameter) {
                QueryParameter.BatchParameter batchParameter = (QueryParameter.BatchParameter)parameter;
                parameterName = "_i";
                parameter = batchParameter.parameter();
            }
            if (parameter instanceof QueryParameter.SimpleParameter) {
                QueryParameter.SimpleParameter nativeParameter = (QueryParameter.SimpleParameter)parameter;
                QueryWithParameters.QueryParameter sqlParameter = sqlWithParameters.parameters().stream().filter(p -> p.methodIndex() == _i).findFirst().get();
                CommonUtils.MappersData mappingData = CommonUtils.parseMapping((Element)parameter.variable());
                CommonUtils.MappingData mapping = mappingData.getMapping(JdbcTypes.PARAMETER_COLUMN_MAPPER);
                JdbcNativeType nativeType = JdbcNativeTypes.findNativeType(TypeName.get((TypeMirror)parameter.type()));
                if (mapping == null && nativeType != null) {
                    if (CommonUtils.isNullable((AnnotatedConstruct)parameter.variable())) {
                        b.add("if ($L != null) {$>", new Object[]{parameterName});
                        for (Integer n : sqlParameter.sqlIndexes()) {
                            b.add("\n", new Object[0]).add(nativeType.bind("_stmt", parameterName, n + 1)).add(";", new Object[0]);
                        }
                        b.add("$<\n} else {$>", new Object[0]);
                        for (Integer n : sqlParameter.sqlIndexes()) {
                            b.add("\n", new Object[0]).add(nativeType.bindNull("_stmt", n + 1)).add(";", new Object[0]);
                        }
                        b.add("$<\n}\n", new Object[0]);
                    } else {
                        for (Integer n : sqlParameter.sqlIndexes()) {
                            b.add(nativeType.bind("_stmt", parameterName, n + 1)).add(";\n", new Object[0]);
                        }
                    }
                } else if (mapping != null && mapping.mapperClass() != null) {
                    mapper = parameterMappers.get(JdbcTypes.PARAMETER_COLUMN_MAPPER, mapping, parameter.type());
                    for (Integer idx : sqlParameter.sqlIndexes()) {
                        b.add("$L.set(_stmt, $L, $L);\n", new Object[]{mapper, idx + 1, parameterName});
                    }
                } else {
                    mapper = parameterMappers.get(JdbcTypes.PARAMETER_COLUMN_MAPPER, parameter.type(), (Element)parameter.variable());
                    for (Integer idx : sqlParameter.sqlIndexes()) {
                        b.add("$L.set(_stmt, $L, $L);\n", new Object[]{mapper, idx + 1, parameterName});
                    }
                }
            }
            if (!(parameter instanceof QueryParameter.EntityParameter)) continue;
            QueryParameter.EntityParameter entityParameter = (QueryParameter.EntityParameter)parameter;
            for (DbEntity.Column field : entityParameter.entity().columns()) {
                String mapper;
                QueryWithParameters.QueryParameter sqlParameter = sqlWithParameters.find(field.queryParameterName(entityParameter.name()));
                if (sqlParameter == null || sqlParameter.sqlIndexes().isEmpty()) continue;
                String accessor = CodeBlock.of((String)"$N.$N()", (Object[])new Object[]{parameterName, field.accessor()}).toString();
                CommonUtils.MappersData mappingData = CommonUtils.parseMapping((Element)field.element());
                CommonUtils.MappingData mappingData2 = mappingData.getMapping(JdbcTypes.PARAMETER_COLUMN_MAPPER);
                JdbcNativeType nativeType = JdbcNativeTypes.findNativeType(TypeName.get((TypeMirror)field.type()));
                if (mappingData2 == null && nativeType != null) {
                    if (CommonUtils.isNullable((AnnotatedConstruct)field.element())) {
                        b.add("if ($L != null) {$>", new Object[]{accessor});
                        for (Integer idx : sqlParameter.sqlIndexes()) {
                            b.add("\n", new Object[0]).add(nativeType.bind("_stmt", accessor, idx + 1)).add(";", new Object[0]);
                        }
                        b.add("$<\n} else {$>", new Object[0]);
                        for (Integer idx : sqlParameter.sqlIndexes()) {
                            b.add("\n", new Object[0]).add(nativeType.bindNull("_stmt", idx + 1)).add(";", new Object[0]);
                        }
                        b.add("$<\n}\n", new Object[0]);
                        continue;
                    }
                    for (Integer idx : sqlParameter.sqlIndexes()) {
                        b.add(nativeType.bind("_stmt", accessor, idx + 1)).add(";\n", new Object[0]);
                    }
                    continue;
                }
                if (mappingData2 == null) {
                    mapper = parameterMappers.get(JdbcTypes.PARAMETER_COLUMN_MAPPER, field.type(), (Element)field.element());
                    for (Integer idx : sqlParameter.sqlIndexes()) {
                        b.add("$L.set(_stmt, $L, $L);\n", new Object[]{mapper, idx + 1, accessor});
                    }
                    continue;
                }
                mapper = parameterMappers.get(JdbcTypes.PARAMETER_COLUMN_MAPPER, mappingData2, field.type());
                for (Integer idx : sqlParameter.sqlIndexes()) {
                    b.add("$L.set(_stmt, $L, $L);\n", new Object[]{mapper, idx + 1, accessor});
                }
            }
        }
        if (batchParam != null) {
            b.add("_stmt.addBatch();$<\n}\n", new Object[0]);
        }
        return b.build();
    }
}

