/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.database.annotation.processor.jdbc.extension;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import jakarta.annotation.Nullable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import ru.tinkoff.kora.annotation.processor.common.CommonUtils;
import ru.tinkoff.kora.annotation.processor.common.GenericTypeResolver;
import ru.tinkoff.kora.annotation.processor.common.NameUtils;
import ru.tinkoff.kora.common.annotation.Generated;
import ru.tinkoff.kora.database.annotation.processor.DbEntityReadHelper;
import ru.tinkoff.kora.database.annotation.processor.entity.DbEntity;
import ru.tinkoff.kora.database.annotation.processor.jdbc.JdbcNativeType;
import ru.tinkoff.kora.database.annotation.processor.jdbc.JdbcNativeTypes;
import ru.tinkoff.kora.database.annotation.processor.jdbc.JdbcTypes;
import ru.tinkoff.kora.kora.app.annotation.processor.extension.ExtensionResult;
import ru.tinkoff.kora.kora.app.annotation.processor.extension.KoraExtension;

public class JdbcTypesExtension
implements KoraExtension {
    private static final ClassName LIST_CLASS_NAME = ClassName.get(List.class);
    private final Types types;
    private final Elements elements;
    private final Filer filer;
    private final DbEntityReadHelper rowMapperGenerator;

    public JdbcTypesExtension(ProcessingEnvironment env) {
        this.types = env.getTypeUtils();
        this.elements = env.getElementUtils();
        this.filer = env.getFiler();
        this.rowMapperGenerator = new DbEntityReadHelper(JdbcTypes.RESULT_COLUMN_MAPPER, this.types, fd -> CodeBlock.of((String)"this.$L.apply(_rs, _$LColumn)", (Object[])new Object[]{fd.mapperFieldName(), fd.fieldName()}), fd -> {
            JdbcNativeType nativeType = JdbcNativeTypes.findNativeType(TypeName.get((TypeMirror)fd.type()));
            if (nativeType != null) {
                return nativeType.extract("_rs", CodeBlock.of((String)"_$LColumn", (Object[])new Object[]{fd.fieldName()}));
            }
            return null;
        }, fd -> CodeBlock.builder().beginControlFlow("if (_rs.wasNull())", new Object[0]).add(fd.nullable() ? CodeBlock.of((String)"$N = null;\n", (Object[])new Object[]{fd.fieldName()}) : CodeBlock.of((String)"throw new $T($S);\n", (Object[])new Object[]{NullPointerException.class, "Result field %s is not nullable but row %s has null".formatted(fd.fieldName(), fd.columnName())})).endControlFlow().build());
    }

    @Nullable
    public KoraExtension.KoraExtensionDependencyGenerator getDependencyGenerator(RoundEnvironment roundEnvironment, TypeMirror typeMirror, Set<String> tags) {
        if (!tags.isEmpty()) {
            return null;
        }
        if (!(typeMirror instanceof DeclaredType)) {
            return null;
        }
        DeclaredType declaredType = (DeclaredType)typeMirror;
        TypeName typeName = TypeName.get((TypeMirror)typeMirror);
        if (!(typeName instanceof ParameterizedTypeName)) {
            return null;
        }
        ParameterizedTypeName ptn = (ParameterizedTypeName)typeName;
        if (Objects.equals(ptn.rawType, JdbcTypes.ROW_MAPPER)) {
            TypeMirror rowTypeMirror = declaredType.getTypeArguments().get(0);
            DbEntity entity = DbEntity.parseEntity(this.types, rowTypeMirror);
            if (entity != null) {
                return this.entityRowMapper(entity);
            }
            return null;
        }
        if (Objects.equals(ptn.rawType, JdbcTypes.RESULT_SET_MAPPER)) {
            TypeName resultTypeName = (TypeName)ptn.typeArguments.get(0);
            TypeMirror resultTypeMirror = declaredType.getTypeArguments().get(0);
            if (resultTypeName instanceof ParameterizedTypeName) {
                ParameterizedTypeName rptn = (ParameterizedTypeName)resultTypeName;
                if (rptn.rawType.equals((Object)LIST_CLASS_NAME) && resultTypeMirror instanceof DeclaredType) {
                    DeclaredType resultDeclaredType = (DeclaredType)resultTypeMirror;
                    TypeMirror rowTypeMirror = resultDeclaredType.getTypeArguments().get(0);
                    DbEntity entity = DbEntity.parseEntity(this.types, rowTypeMirror);
                    if (entity != null) {
                        return this.entityResultListSetMapper(entity);
                    }
                    return () -> {
                        ExecutableElement listResultSetMapper = this.elements.getTypeElement(JdbcTypes.RESULT_SET_MAPPER.canonicalName()).getEnclosedElements().stream().filter(e -> e.getKind() == ElementKind.METHOD && e.getModifiers().contains((Object)Modifier.STATIC)).map(ExecutableElement.class::cast).filter(m -> m.getSimpleName().contentEquals("listResultSetMapper")).findFirst().orElseThrow();
                        TypeVariable tp = (TypeVariable)listResultSetMapper.getTypeParameters().get(0).asType();
                        ExecutableType executableType = (ExecutableType)GenericTypeResolver.resolve((Types)this.types, Map.of(tp, rowTypeMirror), (TypeMirror)listResultSetMapper.asType());
                        return ExtensionResult.fromExecutable((ExecutableElement)listResultSetMapper, (ExecutableType)executableType);
                    };
                }
            }
            return () -> {
                ExecutableElement singleResultSetMapper = this.elements.getTypeElement(JdbcTypes.RESULT_SET_MAPPER.canonicalName()).getEnclosedElements().stream().filter(e -> e.getKind() == ElementKind.METHOD && e.getModifiers().contains((Object)Modifier.STATIC)).map(ExecutableElement.class::cast).filter(m -> m.getSimpleName().contentEquals("singleResultSetMapper")).findFirst().orElseThrow();
                TypeVariable tp = (TypeVariable)singleResultSetMapper.getTypeParameters().get(0).asType();
                ExecutableType executableType = (ExecutableType)GenericTypeResolver.resolve((Types)this.types, Map.of(tp, resultTypeMirror), (TypeMirror)singleResultSetMapper.asType());
                return ExtensionResult.fromExecutable((ExecutableElement)singleResultSetMapper, (ExecutableType)executableType);
            };
        }
        return null;
    }

    private KoraExtension.KoraExtensionDependencyGenerator entityRowMapper(DbEntity entity) {
        return () -> {
            String mapperName = NameUtils.generatedType((Element)entity.typeElement(), (ClassName)JdbcTypes.ROW_MAPPER);
            PackageElement packageElement = this.elements.getPackageOf(entity.typeElement());
            TypeElement maybeGenerated = this.elements.getTypeElement(packageElement.getQualifiedName() + "." + mapperName);
            if (maybeGenerated != null) {
                List constructors = CommonUtils.findConstructors((TypeElement)maybeGenerated, m -> m.contains((Object)Modifier.PUBLIC));
                if (constructors.size() != 1) {
                    throw new IllegalStateException();
                }
                return ExtensionResult.fromExecutable((ExecutableElement)((ExecutableElement)constructors.get(0)));
            }
            TypeSpec.Builder type = TypeSpec.classBuilder((String)mapperName).addAnnotation(AnnotationSpec.builder(Generated.class).addMember("value", "$S", new Object[]{JdbcTypesExtension.class.getCanonicalName()}).build()).addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)JdbcTypes.ROW_MAPPER, (TypeName[])new TypeName[]{TypeName.get((TypeMirror)entity.typeMirror())})).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
            MethodSpec.Builder constructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC});
            MethodSpec.Builder apply = MethodSpec.methodBuilder((String)"apply").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addParameter(TypeName.get(ResultSet.class), "_rs", new Modifier[0]).addException(TypeName.get(SQLException.class)).returns(TypeName.get((TypeMirror)entity.typeMirror()));
            apply.addCode(this.readColumnIds(entity));
            DbEntityReadHelper.ReadEntityCodeBlock read = this.rowMapperGenerator.readEntity("_result", entity);
            read.enrich(type, constructor);
            apply.addCode(read.block());
            apply.addCode("return _result;\n", new Object[0]);
            type.addMethod(constructor.build());
            type.addMethod(apply.build());
            JavaFile.builder((String)packageElement.getQualifiedName().toString(), (TypeSpec)type.build()).build().writeTo(this.filer);
            return ExtensionResult.nextRound();
        };
    }

    private KoraExtension.KoraExtensionDependencyGenerator entityResultListSetMapper(DbEntity entity) {
        return () -> {
            String mapperName = NameUtils.generatedType((Element)entity.typeElement(), (String)"ListJdbcResultSetMapper");
            PackageElement packageElement = this.elements.getPackageOf(entity.typeElement());
            TypeElement maybeGenerated = this.elements.getTypeElement(packageElement.getQualifiedName() + "." + mapperName);
            if (maybeGenerated != null) {
                List constructors = CommonUtils.findConstructors((TypeElement)maybeGenerated, m -> m.contains((Object)Modifier.PUBLIC));
                if (constructors.size() != 1) {
                    throw new IllegalStateException();
                }
                return ExtensionResult.fromExecutable((ExecutableElement)((ExecutableElement)constructors.get(0)));
            }
            TypeSpec.Builder type = TypeSpec.classBuilder((String)mapperName).addAnnotation(AnnotationSpec.builder(Generated.class).addMember("value", "$S", new Object[]{JdbcTypesExtension.class.getCanonicalName()}).build()).addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)JdbcTypes.RESULT_SET_MAPPER, (TypeName[])new TypeName[]{ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{TypeName.get((TypeMirror)entity.typeMirror())})})).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
            MethodSpec.Builder constructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC});
            MethodSpec.Builder apply = MethodSpec.methodBuilder((String)"apply").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addParameter(TypeName.get(ResultSet.class), "_rs", new Modifier[0]).addException(TypeName.get(SQLException.class)).addAnnotation(Nullable.class).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{TypeName.get((TypeMirror)entity.typeMirror())}));
            apply.addCode("if (!_rs.next()) {\n  return $T.of();\n}\n", new Object[]{List.class});
            apply.addCode(this.readColumnIds(entity));
            DbEntityReadHelper.ReadEntityCodeBlock row = this.rowMapperGenerator.readEntity("_row", entity);
            row.enrich(type, constructor);
            apply.addCode("var _result = new $T<$T>();\n", new Object[]{ArrayList.class, entity.typeMirror()});
            apply.addCode("do {$>\n", new Object[0]);
            apply.addCode(row.block());
            apply.addCode("_result.add(_row);\n", new Object[0]);
            apply.addCode("$<\n} while (_rs.next());\n", new Object[0]);
            apply.addCode("return _result;\n", new Object[0]);
            type.addMethod(constructor.build());
            type.addMethod(apply.build());
            JavaFile.builder((String)packageElement.getQualifiedName().toString(), (TypeSpec)type.build()).build().writeTo(this.filer);
            return ExtensionResult.nextRound();
        };
    }

    private CodeBlock readColumnIds(DbEntity entity) {
        CodeBlock.Builder b = CodeBlock.builder();
        for (DbEntity.Column entityField : entity.columns()) {
            String fieldName = entityField.variableName();
            b.add("var _$LColumn = _rs.findColumn($S);\n", new Object[]{fieldName, entityField.columnName()});
        }
        return b.build();
    }
}

