/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.database.annotation.processor.model;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import ru.tinkoff.kora.annotation.processor.common.AnnotationUtils;
import ru.tinkoff.kora.annotation.processor.common.CommonUtils;
import ru.tinkoff.kora.annotation.processor.common.ProcessingErrorException;
import ru.tinkoff.kora.database.annotation.processor.DbUtils;
import ru.tinkoff.kora.database.annotation.processor.entity.DbEntity;
import ru.tinkoff.kora.database.annotation.processor.model.QueryParameter;

public final class QueryParameterParser {
    public static List<QueryParameter> parse(Types types, ClassName connectionType, ClassName parameterMapper, ExecutableElement method, ExecutableType methodType) {
        return QueryParameterParser.parse(types, List.of(connectionType), parameterMapper, method, methodType);
    }

    public static List<QueryParameter> parse(Types types, List<ClassName> connectionTypes, ClassName parameterMapper, ExecutableElement method, ExecutableType methodType) {
        ArrayList<QueryParameter> result = new ArrayList<QueryParameter>(method.getParameters().size());
        for (int i = 0; i < method.getParameters().size(); ++i) {
            QueryParameter parameter = QueryParameterParser.parse(types, method.getParameters().get(i), methodType.getParameterTypes().get(i), connectionTypes, parameterMapper);
            result.add(parameter);
        }
        return result;
    }

    public static QueryParameter parse(Types types, VariableElement parameter, TypeMirror type, List<ClassName> connectionTypes, ClassName parameterMapper) {
        CommonUtils.MappingData mapping;
        String name;
        block6: {
            DbEntity entity;
            block8: {
                block7: {
                    name = parameter.getSimpleName().toString();
                    TypeName typeName = TypeName.get((TypeMirror)type);
                    for (ClassName connectionType : connectionTypes) {
                        if (!connectionType.equals((Object)typeName)) continue;
                        return new QueryParameter.ConnectionParameter(name, type, parameter);
                    }
                    mapping = CommonUtils.parseMapping((Element)parameter).getMapping(parameterMapper);
                    AnnotationMirror batch = AnnotationUtils.findAnnotation((Element)parameter, (ClassName)DbUtils.BATCH_ANNOTATION);
                    if (batch == null) break block6;
                    if (!(typeName instanceof ParameterizedTypeName)) break block7;
                    ParameterizedTypeName ptn = (ParameterizedTypeName)typeName;
                    if (ptn.rawType.canonicalName().equals("java.util.List")) break block8;
                }
                throw new ProcessingErrorException("@Batch parameter must be a list", (Element)parameter);
            }
            TypeMirror batchType = ((DeclaredType)type).getTypeArguments().get(0);
            Record param = mapping != null ? new QueryParameter.SimpleParameter(name, batchType, parameter) : ((entity = DbEntity.parseEntity(types, batchType)) != null ? new QueryParameter.EntityParameter(name, entity, parameter) : new QueryParameter.SimpleParameter(name, batchType, parameter));
            return new QueryParameter.BatchParameter(name, type, parameter, (QueryParameter)((Object)param));
        }
        if (mapping != null) {
            return new QueryParameter.SimpleParameter(name, type, parameter);
        }
        DbEntity entity = DbEntity.parseEntity(types, type);
        if (entity != null) {
            return new QueryParameter.EntityParameter(name, entity, parameter);
        }
        return new QueryParameter.SimpleParameter(name, type, parameter);
    }
}

