/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.database.annotation.processor.r2dbc;

import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Objects;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeMirror;
import ru.tinkoff.kora.annotation.processor.common.CommonUtils;
import ru.tinkoff.kora.annotation.processor.common.FieldFactory;
import ru.tinkoff.kora.database.annotation.processor.QueryWithParameters;
import ru.tinkoff.kora.database.annotation.processor.entity.DbEntity;
import ru.tinkoff.kora.database.annotation.processor.model.QueryParameter;
import ru.tinkoff.kora.database.annotation.processor.r2dbc.R2dbcNativeTypes;
import ru.tinkoff.kora.database.annotation.processor.r2dbc.R2dbcTypes;

public class R2dbcStatementSetterGenerator {
    public static void generate(MethodSpec.Builder b, ExecutableElement method, QueryWithParameters sqlWithParameters, List<QueryParameter> parameters, @Nullable QueryParameter batchParam, FieldFactory parameterMappers) {
        if (batchParam != null) {
            b.addCode("for (int i = 0; i < $L.size(); i++) {\n  var _batch_$L = $L.get(i);$>\n", new Object[]{batchParam.name(), batchParam.name(), batchParam.name()});
        }
        int i = 0;
        int sqlIndex = 1;
        while (i < parameters.size()) {
            QueryParameter parameter = parameters.get(i);
            if (!(parameter instanceof QueryParameter.ConnectionParameter)) {
                Object parameterName = parameter.name();
                if (parameter instanceof QueryParameter.BatchParameter) {
                    QueryParameter.BatchParameter batchParameter = (QueryParameter.BatchParameter)parameter;
                    parameter = batchParameter.parameter();
                    parameterName = "_batch_" + parameter.name();
                }
                if (parameter instanceof QueryParameter.SimpleParameter) {
                    QueryParameter.SimpleParameter simpleParameter = (QueryParameter.SimpleParameter)parameter;
                    QueryWithParameters.QueryParameter sqlParameter = Objects.requireNonNull(sqlWithParameters.find(i));
                    TypeName nativeType = R2dbcNativeTypes.findAndBox(TypeName.get((TypeMirror)simpleParameter.type()));
                    CommonUtils.MappingData mapping = CommonUtils.parseMapping((Element)simpleParameter.variable()).getMapping(R2dbcTypes.PARAMETER_COLUMN_MAPPER);
                    if (nativeType != null && mapping == null) {
                        for (Integer n : sqlParameter.sqlIndexes()) {
                            if (CommonUtils.isNullable((AnnotatedConstruct)simpleParameter.variable())) {
                                b.addCode("if($L == null) {\n  _stmt.bindNull($L, $L.class);\n} else {\n  _stmt.bind($L, $L);\n}\n", new Object[]{parameterName, n, nativeType, n, parameterName});
                                continue;
                            }
                            b.addCode("_stmt.bind($L, $L);\n", new Object[]{n, parameterName});
                        }
                    } else if (mapping != null && mapping.mapperClass() != null) {
                        mapper = parameterMappers.get(R2dbcTypes.PARAMETER_COLUMN_MAPPER, mapping, parameter.type());
                        for (Integer index : sqlParameter.sqlIndexes()) {
                            b.addCode("$L.apply(_stmt, $L, $L);\n", new Object[]{mapper, index, parameterName});
                        }
                    } else {
                        mapper = parameterMappers.get(R2dbcTypes.PARAMETER_COLUMN_MAPPER, simpleParameter.type(), (Element)simpleParameter.variable());
                        for (Integer index : sqlParameter.sqlIndexes()) {
                            b.addCode("$L.apply(_stmt, $L, $L);\n", new Object[]{mapper, index, parameterName});
                        }
                    }
                }
                if (parameter instanceof QueryParameter.EntityParameter) {
                    QueryParameter.EntityParameter entityParameter = (QueryParameter.EntityParameter)parameter;
                    for (DbEntity.Column field : entityParameter.entity().columns()) {
                        String mapper;
                        CodeBlock fieldAccessor = CodeBlock.of((String)"$N.$L()", (Object[])new Object[]{parameterName, field.accessor()});
                        QueryWithParameters.QueryParameter sqlParameter = sqlWithParameters.find(field.queryParameterName(entityParameter.name()));
                        if (sqlParameter == null || sqlParameter.sqlIndexes().isEmpty()) continue;
                        TypeName typeName = R2dbcNativeTypes.findAndBox(TypeName.get((TypeMirror)field.type()));
                        CommonUtils.MappingData mapping = CommonUtils.parseMapping((Element)field.element()).getMapping(R2dbcTypes.PARAMETER_COLUMN_MAPPER);
                        if (typeName != null && mapping == null) {
                            for (Integer index : sqlParameter.sqlIndexes()) {
                                if (CommonUtils.isNullable((AnnotatedConstruct)field.element())) {
                                    b.addCode("if($L == null) {\n  _stmt.bindNull($L, $L.class);\n} else {\n  _stmt.bind($L, $L);\n}\n", new Object[]{fieldAccessor, index, typeName, index, fieldAccessor});
                                    continue;
                                }
                                b.addCode("_stmt.bind($L, $L);\n", new Object[]{index, fieldAccessor});
                            }
                            continue;
                        }
                        if (mapping != null && mapping.mapperClass() != null) {
                            mapper = parameterMappers.get(R2dbcTypes.PARAMETER_COLUMN_MAPPER, mapping, field.type());
                            for (Integer index : sqlParameter.sqlIndexes()) {
                                b.addCode("$L.apply(_stmt, $L, $L);\n", new Object[]{mapper, index, fieldAccessor});
                            }
                            continue;
                        }
                        mapper = parameterMappers.get(R2dbcTypes.PARAMETER_COLUMN_MAPPER, field.type(), (Element)field.element());
                        for (Integer index : sqlParameter.sqlIndexes()) {
                            b.addCode("$L.apply(_stmt, $L, $L);\n", new Object[]{mapper, index, fieldAccessor});
                        }
                    }
                }
            }
            ++i;
            ++sqlIndex;
        }
        if (batchParam != null) {
            b.addCode("if(i != $L.size() - 1) {\n  _stmt.add();\n}", new Object[]{batchParam.name()});
            b.addCode("\n$<}\n", new Object[0]);
        }
    }
}

