/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.database.annotation.processor.vertx;

import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeMirror;
import ru.tinkoff.kora.annotation.processor.common.CommonUtils;
import ru.tinkoff.kora.annotation.processor.common.FieldFactory;
import ru.tinkoff.kora.database.annotation.processor.QueryWithParameters;
import ru.tinkoff.kora.database.annotation.processor.entity.DbEntity;
import ru.tinkoff.kora.database.annotation.processor.model.QueryParameter;
import ru.tinkoff.kora.database.annotation.processor.vertx.VertxNativeType;
import ru.tinkoff.kora.database.annotation.processor.vertx.VertxNativeTypes;
import ru.tinkoff.kora.database.annotation.processor.vertx.VertxTypes;

public class ParametersToTupleBuilder {
    /*
     * WARNING - void declaration
     */
    public static void generate(MethodSpec.Builder b, QueryWithParameters sqlWithParameters, ExecutableElement method, List<QueryParameter> parameters, @Nullable QueryParameter batchParam, FieldFactory parameterMappers) {
        record Param(List<Integer> index, String name, CodeBlock code) {
        }
        if (batchParam != null) {
            b.addCode("var _batchParams = new $T<$T>($L.size());\n", new Object[]{ArrayList.class, VertxTypes.TUPLE, batchParam.variable()});
            b.addCode("for (var _i = 0; _i < $L.size(); _i++) {$>\n", new Object[]{batchParam.variable()});
            for (QueryParameter queryParameter : parameters) {
                if (!(queryParameter instanceof QueryParameter.BatchParameter)) continue;
                b.addCode("var _batch_$L = $L.get(_i);\n", new Object[]{queryParameter.name(), queryParameter.name()});
            }
        }
        List sqlParams = parameters.stream().filter(Predicate.not(p -> p instanceof QueryParameter.ConnectionParameter)).map(p -> {
            if (p instanceof QueryParameter.BatchParameter) {
                QueryParameter.BatchParameter bp = (QueryParameter.BatchParameter)p;
                return Map.entry("_batch_" + bp.name(), bp.parameter());
            }
            return Map.entry(p.name(), p);
        }).mapMulti((e, sink) -> {
            Object patt2030$temp = e.getValue();
            if (patt2030$temp instanceof QueryParameter.SimpleParameter) {
                QueryParameter.SimpleParameter simpleParameter = (QueryParameter.SimpleParameter)patt2030$temp;
                VertxNativeType nativeType = VertxNativeTypes.find(TypeName.get((TypeMirror)simpleParameter.type()));
                CommonUtils.MappingData mapping = CommonUtils.parseMapping((Element)simpleParameter.variable()).getMapping(VertxTypes.PARAMETER_COLUMN_MAPPER);
                QueryWithParameters.QueryParameter sqlParameter = Objects.requireNonNull(sqlWithParameters.find(simpleParameter.variable().getSimpleName().toString()));
                if (nativeType == null || mapping != null && mapping.mapperClass() == null) {
                    String mapperName = parameterMappers.get(VertxTypes.PARAMETER_COLUMN_MAPPER, simpleParameter.type(), (Element)simpleParameter.variable());
                    sink.accept(new Param(sqlParameter.sqlIndexes(), (String)e.getKey(), CodeBlock.of((String)"$N.apply($L)", (Object[])new Object[]{mapperName, e.getKey()})));
                } else if (mapping != null) {
                    String mapperName = parameterMappers.get(VertxTypes.PARAMETER_COLUMN_MAPPER, mapping, simpleParameter.type());
                    sink.accept(new Param(sqlParameter.sqlIndexes(), (String)e.getKey(), CodeBlock.of((String)"$N.apply($L)", (Object[])new Object[]{mapperName, e.getKey()})));
                } else {
                    sink.accept(new Param(sqlParameter.sqlIndexes(), (String)e.getKey(), CodeBlock.of((String)"$L", (Object[])new Object[]{e.getKey()})));
                }
            } else {
                QueryParameter.EntityParameter entityParam = (QueryParameter.EntityParameter)e.getValue();
                for (DbEntity.Column field : entityParam.entity().columns()) {
                    String mapperName;
                    QueryWithParameters.QueryParameter sqlParameter = sqlWithParameters.find(field.queryParameterName(entityParam.name()));
                    if (sqlParameter == null || sqlParameter.sqlIndexes().isEmpty()) continue;
                    String variableName = (String)e.getKey() + "_" + field.variableName();
                    CodeBlock fieldAccessor = CodeBlock.of((String)"$N.$N()", (Object[])new Object[]{e.getKey(), field.accessor()});
                    VertxNativeType nativeType = VertxNativeTypes.find(TypeName.get((TypeMirror)field.type()));
                    CommonUtils.MappingData mapping = CommonUtils.parseMapping((Element)field.element()).getMapping(VertxTypes.PARAMETER_COLUMN_MAPPER);
                    if (nativeType != null && mapping == null) {
                        sink.accept(new Param(sqlParameter.sqlIndexes(), variableName, CodeBlock.of((String)"$L", (Object[])new Object[]{fieldAccessor})));
                        continue;
                    }
                    if (mapping != null && mapping.mapperClass() != null) {
                        mapperName = parameterMappers.get(VertxTypes.PARAMETER_COLUMN_MAPPER, mapping, field.type());
                        sink.accept(new Param(sqlParameter.sqlIndexes(), variableName, CodeBlock.of((String)"$L.apply($L)", (Object[])new Object[]{mapperName, fieldAccessor})));
                        continue;
                    }
                    mapperName = parameterMappers.get(VertxTypes.PARAMETER_COLUMN_MAPPER, field.type(), (Element)field.element());
                    sink.accept(new Param(sqlParameter.sqlIndexes(), variableName, CodeBlock.of((String)"$L.apply($L)", (Object[])new Object[]{mapperName, fieldAccessor})));
                }
            }
        }).toList();
        for (Param sqlParam : sqlParams) {
            b.addCode("var _$L = $L;\n", new Object[]{sqlParam.name, sqlParam.code});
        }
        if (sqlParams.isEmpty()) {
            b.addCode("var _tuple = $T.tuple();\n", new Object[]{VertxTypes.TUPLE});
        } else {
            void var7_10;
            b.addCode("var _tuple = $T.of($>\n", new Object[]{VertxTypes.TUPLE});
            boolean bl = false;
            while (var7_10 < sqlParams.size()) {
                if (var7_10 > 0) {
                    b.addCode(",\n", new Object[0]);
                }
                b.addCode("_$L", new Object[]{((Param)sqlParams.get((int)var7_10)).name()});
                ++var7_10;
            }
            b.addCode("$<\n);\n", new Object[0]);
        }
        if (batchParam != null) {
            b.addCode("_batchParams.add(_tuple);\n", new Object[0]);
            b.addCode("$<\n}\n", new Object[0]);
        }
    }
}

