/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.database.annotation.processor.vertx;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import ru.tinkoff.kora.annotation.processor.common.AnnotationUtils;
import ru.tinkoff.kora.annotation.processor.common.CommonUtils;
import ru.tinkoff.kora.annotation.processor.common.FieldFactory;
import ru.tinkoff.kora.annotation.processor.common.Visitors;
import ru.tinkoff.kora.common.Tag;
import ru.tinkoff.kora.database.annotation.processor.DbUtils;
import ru.tinkoff.kora.database.annotation.processor.QueryWithParameters;
import ru.tinkoff.kora.database.annotation.processor.RepositoryGenerator;
import ru.tinkoff.kora.database.annotation.processor.model.QueryParameter;
import ru.tinkoff.kora.database.annotation.processor.model.QueryParameterParser;
import ru.tinkoff.kora.database.annotation.processor.vertx.ParametersToTupleBuilder;
import ru.tinkoff.kora.database.annotation.processor.vertx.VertxNativeTypes;
import ru.tinkoff.kora.database.annotation.processor.vertx.VertxTypes;

public final class VertxRepositoryGenerator
implements RepositoryGenerator {
    private final TypeMirror repositoryInterface;
    private final Types types;
    private final Elements elements;
    private final Filer filer;
    private final DeclaredType completionStageType;

    public VertxRepositoryGenerator(ProcessingEnvironment processingEnv) {
        TypeElement repository = processingEnv.getElementUtils().getTypeElement(VertxTypes.REPOSITORY.canonicalName());
        this.repositoryInterface = repository == null ? null : repository.asType();
        this.types = processingEnv.getTypeUtils();
        this.elements = processingEnv.getElementUtils();
        this.filer = processingEnv.getFiler();
        this.completionStageType = this.types.getDeclaredType(this.elements.getTypeElement(CompletionStage.class.getCanonicalName()), this.types.getWildcardType(null, null));
    }

    @Override
    @Nullable
    public TypeMirror repositoryInterface() {
        return this.repositoryInterface;
    }

    @Override
    public TypeSpec generate(TypeElement repositoryElement, TypeSpec.Builder type, MethodSpec.Builder constructor) {
        DeclaredType repositoryType = (DeclaredType)repositoryElement.asType();
        List<ExecutableElement> queryMethods = DbUtils.findQueryMethods(this.types, this.elements, repositoryElement);
        this.enrichWithExecutor(repositoryElement, type, constructor, queryMethods);
        FieldFactory resultMappers = new FieldFactory(this.types, this.elements, type, constructor, "_result_mapper_");
        FieldFactory parameterMappers = new FieldFactory(this.types, this.elements, type, constructor, "_parameter_mapper_");
        for (ExecutableElement method : queryMethods) {
            ExecutableType methodType = (ExecutableType)this.types.asMemberOf(repositoryType, method);
            List<QueryParameter> parameters = QueryParameterParser.parse(this.types, List.of(VertxTypes.CONNECTION, VertxTypes.SQL_CLIENT), VertxTypes.PARAMETER_COLUMN_MAPPER, method, methodType);
            AnnotationMirror queryAnnotation = AnnotationUtils.findAnnotation((Element)method, (ClassName)DbUtils.QUERY_ANNOTATION);
            String queryString = (String)AnnotationUtils.parseAnnotationValueWithoutDefault((AnnotationMirror)queryAnnotation, (String)"value");
            QueryWithParameters query = QueryWithParameters.parse(this.filer, this.types, queryString, parameters, repositoryType, method);
            String resultMapper = this.parseResultMapper(method, parameters, methodType).map(rm -> DbUtils.addMapper(resultMappers, rm)).orElse(null);
            DbUtils.addMappers(parameterMappers, DbUtils.parseParameterMappers(parameters, query, tn -> VertxNativeTypes.find(tn) != null, VertxTypes.PARAMETER_COLUMN_MAPPER));
            MethodSpec methodSpec = this.generate(method, methodType, query, parameters, resultMapper, parameterMappers);
            type.addMethod(methodSpec);
        }
        return type.addMethod(constructor.build()).build();
    }

    private MethodSpec generate(ExecutableElement method, ExecutableType methodType, QueryWithParameters query, List<QueryParameter> parameters, @Nullable String resultMapperName, FieldFactory parameterMappers) {
        CodeBlock resultMapper;
        String sql = query.rawQuery();
        ArrayList<Map.Entry<QueryWithParameters.QueryParameter, Integer>> params = new ArrayList<Map.Entry<QueryWithParameters.QueryParameter, Integer>>(query.parameters().size());
        for (int i = 0; i < query.parameters().size(); ++i) {
            QueryWithParameters.QueryParameter queryParameter = query.parameters().get(i);
            params.add(Map.entry(queryParameter, i));
        }
        for (Map.Entry entry : params.stream().sorted(Comparator.comparing(p -> ((QueryWithParameters.QueryParameter)p.getKey()).sqlParameterName().length()).reversed()).toList()) {
            sql = sql.replace(":" + ((QueryWithParameters.QueryParameter)entry.getKey()).sqlParameterName(), "$" + ((Integer)entry.getValue() + 1));
        }
        MethodSpec.Builder b = DbUtils.queryMethodBuilder(method, methodType);
        b.addStatement(CodeBlock.of((String)"var _query = new $T(\n  $S,\n  $S,\n  $S\n)", (Object[])new Object[]{DbUtils.QUERY_CONTEXT, query.rawQuery(), sql, DbUtils.operationName(method)}));
        QueryParameter batchParam = parameters.stream().filter(QueryParameter.BatchParameter.class::isInstance).findFirst().orElse(null);
        QueryParameter queryParameter = parameters.stream().filter(QueryParameter.ConnectionParameter.class::isInstance).findFirst().orElse(null);
        TypeMirror returnType = methodType.getReturnType();
        boolean isFlux = CommonUtils.isFlux((TypeMirror)returnType);
        boolean isMono = CommonUtils.isMono((TypeMirror)returnType);
        boolean isCompletionStage = this.isCompletionStage(returnType);
        boolean isVoid = this.isVoid(returnType);
        ParametersToTupleBuilder.generate(b, query, method, parameters, batchParam, parameterMappers);
        if (isVoid) {
            resultMapper = CodeBlock.of((String)"_rs -> null", (Object[])new Object[0]);
        } else if ((isMono || isCompletionStage) && ((DeclaredType)returnType).getTypeArguments().get(0).toString().equals(DbUtils.UPDATE_COUNT.canonicalName())) {
            resultMapper = CodeBlock.of((String)"$T::extractUpdateCount", (Object[])new Object[]{VertxTypes.ROW_SET_MAPPER});
        } else if (returnType.toString().equals(DbUtils.UPDATE_COUNT.canonicalName())) {
            resultMapper = CodeBlock.of((String)"$T::extractUpdateCount", (Object[])new Object[]{VertxTypes.ROW_SET_MAPPER});
        } else {
            Objects.requireNonNull(resultMapperName, () -> "Illegal State occurred when expected to get result mapper, but got null in " + method.getEnclosingElement().getSimpleName() + "#" + method.getSimpleName());
            resultMapper = CodeBlock.of((String)"$N", (Object[])new Object[]{resultMapperName});
        }
        if (returnType.getKind() != TypeKind.VOID) {
            b.addCode("return ", new Object[0]);
        }
        if (batchParam != null) {
            if (isCompletionStage || !isMono) {
                if (queryParameter == null) {
                    b.addCode("$T.batchCompletionStage(this._connectionFactory, _query, _batchParams)\n", new Object[]{VertxTypes.REPOSITORY_HELPER});
                } else {
                    b.addCode("$T.batchCompletionStage($N, this._connectionFactory.telemetry(), _query, _batchParams)\n", new Object[]{VertxTypes.REPOSITORY_HELPER, queryParameter.name()});
                }
                if (isVoid) {
                    b.addCode("  .thenApply(v -> (Void) null)\n", new Object[0]);
                }
            } else {
                if (queryParameter == null) {
                    b.addCode("$T.Reactor.batchMono(this._connectionFactory, _query, _batchParams)\n", new Object[]{VertxTypes.REPOSITORY_HELPER});
                } else {
                    b.addCode("$T.Reactor.batchMono($N, this._connectionFactory.telemetry(), _query, _batchParams)\n", new Object[]{VertxTypes.REPOSITORY_HELPER, queryParameter.name()});
                }
                if (isVoid) {
                    b.addCode("  .then()\n", new Object[0]);
                }
            }
        } else if (isFlux) {
            if (queryParameter == null) {
                b.addCode("$T.Reactor.flux(this._connectionFactory, _query, _tuple, $L)\n", new Object[]{VertxTypes.REPOSITORY_HELPER, resultMapperName});
            } else {
                b.addCode("$T.Reactor.flux($N, this._connectionFactory.telemetry(), _query, _tuple, $L)\n", new Object[]{VertxTypes.REPOSITORY_HELPER, queryParameter.name(), resultMapperName});
            }
        } else if (isMono) {
            if (queryParameter == null) {
                b.addCode("$T.Reactor.mono(this._connectionFactory, _query, _tuple, $L)\n", new Object[]{VertxTypes.REPOSITORY_HELPER, resultMapper});
            } else {
                b.addCode("$T.Reactor.mono($N, this._connectionFactory.telemetry(), _query, _tuple, $L)\n", new Object[]{VertxTypes.REPOSITORY_HELPER, queryParameter.name(), resultMapper});
            }
        } else if (queryParameter == null) {
            b.addCode("$T.completionStage(this._connectionFactory, _query, _tuple, $L)\n", new Object[]{VertxTypes.REPOSITORY_HELPER, resultMapper});
        } else {
            b.addCode("$T.completionStage($N, this._connectionFactory.telemetry(), _query, _tuple, $L)\n", new Object[]{VertxTypes.REPOSITORY_HELPER, queryParameter.name(), resultMapper});
        }
        if (isFlux) {
            b.addCode(";\n", new Object[0]);
        } else if (isMono) {
            b.addCode(";\n", new Object[0]);
        } else if (isCompletionStage) {
            b.addCode(";\n", new Object[0]);
        } else {
            b.addCode("  .join();\n", new Object[0]);
        }
        return b.build();
    }

    private Optional<DbUtils.Mapper> parseResultMapper(ExecutableElement method, List<QueryParameter> parameters, ExecutableType methodType) {
        for (QueryParameter parameter : parameters) {
            if (!(parameter instanceof QueryParameter.BatchParameter)) continue;
            return Optional.empty();
        }
        TypeMirror returnType = methodType.getReturnType();
        if (this.isVoid(returnType)) {
            return Optional.empty();
        }
        CommonUtils.MappersData mappings = CommonUtils.parseMapping((Element)method);
        CommonUtils.MappingData rowSetMapper = mappings.getMapping(VertxTypes.ROW_SET_MAPPER);
        CommonUtils.MappingData rowMapper = mappings.getMapping(VertxTypes.ROW_MAPPER);
        if (CommonUtils.isFlux((TypeMirror)returnType)) {
            TypeMirror fluxParam = (TypeMirror)Visitors.visitDeclaredType((TypeMirror)returnType, dt -> dt.getTypeArguments().get(0));
            ParameterizedTypeName mapperType = ParameterizedTypeName.get((ClassName)VertxTypes.ROW_MAPPER, (TypeName[])new TypeName[]{TypeName.get((TypeMirror)fluxParam)});
            if (rowMapper != null) {
                return Optional.of(new DbUtils.Mapper(rowMapper.mapperClass(), (TypeName)mapperType, rowMapper.mapperTags()));
            }
            return Optional.of(new DbUtils.Mapper((TypeName)mapperType, Set.of()));
        }
        if (CommonUtils.isMono((TypeMirror)returnType) || this.isCompletionStage(returnType)) {
            TypeMirror monoParam = (TypeMirror)Visitors.visitDeclaredType((TypeMirror)returnType, dt -> dt.getTypeArguments().get(0));
            ParameterizedTypeName mapperType = ParameterizedTypeName.get((ClassName)VertxTypes.ROW_SET_MAPPER, (TypeName[])new TypeName[]{TypeName.get((TypeMirror)monoParam)});
            if (monoParam.toString().equals(DbUtils.UPDATE_COUNT.canonicalName())) {
                return Optional.empty();
            }
            if (rowSetMapper != null) {
                return Optional.of(new DbUtils.Mapper(rowSetMapper.mapperClass(), (TypeName)mapperType, rowSetMapper.mapperTags()));
            }
            if (rowMapper != null) {
                if (CommonUtils.isList((TypeMirror)monoParam)) {
                    return Optional.of(new DbUtils.Mapper(rowMapper.mapperClass(), (TypeName)mapperType, rowMapper.mapperTags(), c -> CodeBlock.of((String)"$T.listRowSetMapper($L)", (Object[])new Object[]{VertxTypes.ROW_SET_MAPPER, c})));
                }
                if (CommonUtils.isOptional((TypeMirror)monoParam)) {
                    return Optional.of(new DbUtils.Mapper(rowMapper.mapperClass(), (TypeName)mapperType, rowMapper.mapperTags(), c -> CodeBlock.of((String)"$T.optionalRowSetMapper($L)", (Object[])new Object[]{VertxTypes.ROW_SET_MAPPER, c})));
                }
                return Optional.of(new DbUtils.Mapper(rowMapper.mapperClass(), (TypeName)mapperType, rowMapper.mapperTags(), c -> CodeBlock.of((String)"$T.singleRowSetMapper($L)", (Object[])new Object[]{VertxTypes.ROW_SET_MAPPER, c})));
            }
            return Optional.of(new DbUtils.Mapper((TypeName)mapperType, Set.of()));
        }
        ParameterizedTypeName mapperType = ParameterizedTypeName.get((ClassName)VertxTypes.ROW_SET_MAPPER, (TypeName[])new TypeName[]{TypeName.get((TypeMirror)returnType).box()});
        if (rowSetMapper != null) {
            return Optional.of(new DbUtils.Mapper(rowSetMapper.mapperClass(), (TypeName)mapperType, rowSetMapper.mapperTags()));
        }
        if (rowMapper != null) {
            if (CommonUtils.isList((TypeMirror)returnType)) {
                return Optional.of(new DbUtils.Mapper(rowMapper.mapperClass(), (TypeName)mapperType, rowMapper.mapperTags(), c -> CodeBlock.of((String)"$T.listRowSetMapper($L)", (Object[])new Object[]{VertxTypes.ROW_SET_MAPPER, c})));
            }
            if (CommonUtils.isOptional((TypeMirror)returnType)) {
                return Optional.of(new DbUtils.Mapper(rowMapper.mapperClass(), (TypeName)mapperType, rowMapper.mapperTags(), c -> CodeBlock.of((String)"$T.optionalRowSetMapper($L)", (Object[])new Object[]{VertxTypes.ROW_SET_MAPPER, c})));
            }
            return Optional.of(new DbUtils.Mapper(rowMapper.mapperClass(), (TypeName)mapperType, rowMapper.mapperTags(), c -> CodeBlock.of((String)"$T.singleRowSetMapper($L)", (Object[])new Object[]{VertxTypes.ROW_SET_MAPPER, c})));
        }
        if (returnType.toString().equals(DbUtils.UPDATE_COUNT.canonicalName())) {
            return Optional.empty();
        }
        return Optional.of(new DbUtils.Mapper((TypeName)mapperType, Set.of()));
    }

    public void enrichWithExecutor(TypeElement repositoryElement, TypeSpec.Builder builder, MethodSpec.Builder constructorBuilder, List<ExecutableElement> queryMethods) {
        builder.addField((TypeName)VertxTypes.CONNECTION_FACTORY, "_connectionFactory", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
        builder.addSuperinterface((TypeName)VertxTypes.REPOSITORY);
        builder.addMethod(MethodSpec.methodBuilder((String)"getVertxConnectionFactory").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addAnnotation(Override.class).returns((TypeName)VertxTypes.CONNECTION_FACTORY).addCode("return this._connectionFactory;", new Object[0]).build());
        CodeBlock executorTag = DbUtils.getTag(repositoryElement);
        if (executorTag != null) {
            constructorBuilder.addParameter(ParameterSpec.builder((TypeName)VertxTypes.CONNECTION_FACTORY, (String)"_connectionFactory", (Modifier[])new Modifier[0]).addAnnotation(AnnotationSpec.builder(Tag.class).addMember("value", executorTag).build()).build());
        } else {
            constructorBuilder.addParameter((TypeName)VertxTypes.CONNECTION_FACTORY, "_connectionFactory", new Modifier[0]);
        }
        constructorBuilder.addStatement("this._connectionFactory = _connectionFactory", new Object[0]);
    }

    private boolean isCompletionStage(TypeMirror returnType) {
        return this.types.isAssignable(returnType, this.completionStageType);
    }

    private boolean isVoid(TypeMirror tm) {
        if (this.isCompletionStage(tm) || CommonUtils.isMono((TypeMirror)tm)) {
            tm = (TypeMirror)Visitors.visitDeclaredType((TypeMirror)tm, dt -> dt.getTypeArguments().get(0));
        }
        return tm.getKind() == TypeKind.NONE || tm.toString().equals("java.lang.Void") || tm.getKind() == TypeKind.VOID;
    }
}

