/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.database.annotation.processor.vertx.extension;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import ru.tinkoff.kora.annotation.processor.common.CommonUtils;
import ru.tinkoff.kora.annotation.processor.common.GenericTypeResolver;
import ru.tinkoff.kora.annotation.processor.common.NameUtils;
import ru.tinkoff.kora.common.annotation.Generated;
import ru.tinkoff.kora.database.annotation.processor.DbEntityReadHelper;
import ru.tinkoff.kora.database.annotation.processor.entity.DbEntity;
import ru.tinkoff.kora.database.annotation.processor.vertx.VertxNativeType;
import ru.tinkoff.kora.database.annotation.processor.vertx.VertxNativeTypes;
import ru.tinkoff.kora.database.annotation.processor.vertx.VertxTypes;
import ru.tinkoff.kora.kora.app.annotation.processor.extension.ExtensionResult;
import ru.tinkoff.kora.kora.app.annotation.processor.extension.KoraExtension;

public class VertxTypesExtension
implements KoraExtension {
    private final Types types;
    private final Elements elements;
    private final Filer filer;
    private final DbEntityReadHelper entityHelper;

    public VertxTypesExtension(ProcessingEnvironment env) {
        this.types = env.getTypeUtils();
        this.elements = env.getElementUtils();
        this.filer = env.getFiler();
        this.entityHelper = new DbEntityReadHelper(VertxTypes.RESULT_COLUMN_MAPPER, this.types, fd -> CodeBlock.of((String)"this.$L.apply(_row, _$LColumn)", (Object[])new Object[]{fd.mapperFieldName(), fd.fieldName()}), fd -> {
            VertxNativeType nativeType = VertxNativeTypes.find(TypeName.get((TypeMirror)fd.type()));
            if (nativeType != null) {
                return nativeType.extract("_row", "_" + fd.fieldName() + "Column");
            }
            return null;
        }, fd -> fd.nullable() || fd.type().getKind().isPrimitive() ? CodeBlock.of((String)"", (Object[])new Object[0]) : CodeBlock.builder().beginControlFlow("if ($N == null)", new Object[]{fd.fieldName()}).add("throw new $T($S);\n", new Object[]{NullPointerException.class, "Result field %s is not nullable but row %s has null".formatted(fd.fieldName(), fd.columnName())}).endControlFlow().build());
    }

    @Nullable
    public KoraExtension.KoraExtensionDependencyGenerator getDependencyGenerator(RoundEnvironment roundEnvironment, TypeMirror typeMirror, Set<String> tags) {
        if (!tags.isEmpty()) {
            return null;
        }
        if (!(typeMirror instanceof DeclaredType)) {
            return null;
        }
        DeclaredType dt = (DeclaredType)typeMirror;
        if (typeMirror.toString().startsWith("ru.tinkoff.kora.database.vertx.mapper.result.VertxRowSetMapper<")) {
            return this.generateResultSetMapper(roundEnvironment, dt);
        }
        if (typeMirror.toString().startsWith("ru.tinkoff.kora.database.vertx.mapper.result.VertxRowMapper<")) {
            return this.generateResultRowMapper(roundEnvironment, dt);
        }
        return null;
    }

    @Nullable
    private KoraExtension.KoraExtensionDependencyGenerator generateResultRowMapper(RoundEnvironment roundEnvironment, DeclaredType typeMirror) {
        TypeMirror rowType = typeMirror.getTypeArguments().get(0);
        DbEntity entity = DbEntity.parseEntity(this.types, rowType);
        if (entity == null) {
            return null;
        }
        String mapperName = NameUtils.generatedType((Element)entity.typeElement(), (ClassName)VertxTypes.ROW_MAPPER);
        PackageElement packageElement = this.elements.getPackageOf(entity.typeElement());
        return () -> {
            TypeElement maybeGenerated = this.elements.getTypeElement(packageElement.getQualifiedName() + "." + mapperName);
            if (maybeGenerated != null) {
                List constructors = CommonUtils.findConstructors((TypeElement)maybeGenerated, m -> m.contains((Object)Modifier.PUBLIC));
                if (constructors.size() != 1) {
                    throw new IllegalStateException();
                }
                return ExtensionResult.fromExecutable((ExecutableElement)((ExecutableElement)constructors.get(0)));
            }
            TypeSpec.Builder type = TypeSpec.classBuilder((String)mapperName).addAnnotation(AnnotationSpec.builder(Generated.class).addMember("value", "$S", new Object[]{VertxTypesExtension.class.getCanonicalName()}).build()).addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)VertxTypes.ROW_MAPPER, (TypeName[])new TypeName[]{TypeName.get((TypeMirror)entity.typeMirror())})).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
            MethodSpec.Builder constructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC});
            MethodSpec.Builder apply = MethodSpec.methodBuilder((String)"apply").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addParameter((TypeName)VertxTypes.ROW, "_row", new Modifier[0]).returns(TypeName.get((TypeMirror)entity.typeMirror()));
            apply.addCode(this.readColumnIds(entity, "_row.getColumnIndex"));
            DbEntityReadHelper.ReadEntityCodeBlock read = this.entityHelper.readEntity("_result", entity);
            read.enrich(type, constructor);
            apply.addCode(read.block());
            apply.addCode("return _result;\n", new Object[0]);
            type.addMethod(constructor.build());
            type.addMethod(apply.build());
            JavaFile.builder((String)packageElement.getQualifiedName().toString(), (TypeSpec)type.build()).build().writeTo(this.filer);
            return ExtensionResult.nextRound();
        };
    }

    private KoraExtension.KoraExtensionDependencyGenerator generateResultSetMapper(RoundEnvironment roundEnvironment, DeclaredType typeMirror) {
        TypeMirror resultTypeMirror = typeMirror.getTypeArguments().get(0);
        TypeName resultType = TypeName.get((TypeMirror)resultTypeMirror);
        if (resultType.toString().startsWith("java.util.List<")) {
            TypeMirror rowType = ((DeclaredType)resultTypeMirror).getTypeArguments().get(0);
            DbEntity dbEntity = DbEntity.parseEntity(this.types, rowType);
            if (dbEntity != null) {
                return this.entityListRowSetMapper(rowType, dbEntity);
            }
            return () -> {
                ExecutableElement listResultSetMapper = this.elements.getTypeElement(VertxTypes.ROW_SET_MAPPER.canonicalName()).getEnclosedElements().stream().filter(e -> e.getKind() == ElementKind.METHOD && e.getModifiers().contains((Object)Modifier.STATIC)).map(ExecutableElement.class::cast).filter(m -> m.getSimpleName().contentEquals("listRowSetMapper")).findFirst().orElseThrow();
                TypeVariable tp = (TypeVariable)listResultSetMapper.getTypeParameters().get(0).asType();
                ExecutableType executableType = (ExecutableType)GenericTypeResolver.resolve((Types)this.types, Map.of(tp, rowType), (TypeMirror)listResultSetMapper.asType());
                return ExtensionResult.fromExecutable((ExecutableElement)listResultSetMapper, (ExecutableType)executableType);
            };
        }
        DbEntity dbEntity = DbEntity.parseEntity(this.types, resultTypeMirror);
        if (dbEntity != null) {
            return this.rowSetMapper(resultTypeMirror, dbEntity);
        }
        return () -> {
            ExecutableElement singleResultSetMapper = this.elements.getTypeElement(VertxTypes.ROW_SET_MAPPER.canonicalName()).getEnclosedElements().stream().filter(e -> e.getKind() == ElementKind.METHOD && e.getModifiers().contains((Object)Modifier.STATIC)).map(ExecutableElement.class::cast).filter(m -> m.getSimpleName().contentEquals("singleRowSetMapper")).findFirst().orElseThrow();
            TypeVariable tp = (TypeVariable)singleResultSetMapper.getTypeParameters().get(0).asType();
            ExecutableType executableType = (ExecutableType)GenericTypeResolver.resolve((Types)this.types, Map.of(tp, resultTypeMirror), (TypeMirror)singleResultSetMapper.asType());
            return ExtensionResult.fromExecutable((ExecutableElement)singleResultSetMapper, (ExecutableType)executableType);
        };
    }

    private KoraExtension.KoraExtensionDependencyGenerator rowSetMapper(TypeMirror rowTypeMirror, DbEntity dbEntity) {
        PackageElement packageElement = this.elements.getPackageOf(this.types.asElement(rowTypeMirror));
        TypeName rowType = TypeName.get((TypeMirror)rowTypeMirror);
        Element rowTypeElement = this.types.asElement(rowTypeMirror);
        String mapperName = NameUtils.generatedType((Element)rowTypeElement, (ClassName)VertxTypes.ROW_SET_MAPPER);
        return () -> {
            TypeElement maybeGenerated = this.elements.getTypeElement(packageElement.getQualifiedName() + "." + mapperName);
            if (maybeGenerated != null) {
                List constructors = CommonUtils.findConstructors((TypeElement)maybeGenerated, m -> m.contains((Object)Modifier.PUBLIC));
                if (constructors.size() != 1) {
                    throw new IllegalStateException();
                }
                return ExtensionResult.fromExecutable((ExecutableElement)((ExecutableElement)constructors.get(0)));
            }
            DbEntityReadHelper.ReadEntityCodeBlock readEntity = this.entityHelper.readEntity("_rowValue", dbEntity);
            MethodSpec.Builder constructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC});
            TypeSpec.Builder type = TypeSpec.classBuilder((String)mapperName).addAnnotation(AnnotationSpec.builder(Generated.class).addMember("value", "$S", new Object[]{VertxTypesExtension.class.getCanonicalName()}).build()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)VertxTypes.ROW_SET_MAPPER, (TypeName[])new TypeName[]{rowType}));
            readEntity.enrich(type, constructor);
            TypeSpec typeSpec = type.addMethod(MethodSpec.methodBuilder((String)"apply").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addAnnotation(Override.class).returns(rowType).addParameter((TypeName)VertxTypes.ROW_SET, "_rs", new Modifier[0]).addCode("if (_rs.rowCount() < 1) return null;\n", new Object[0]).addCode("var _row = _rs.iterator().next();\n", new Object[0]).addCode(this.readColumnIds(dbEntity, "_row.getColumnIndex")).addCode(readEntity.block()).addCode("return _rowValue;\n", new Object[0]).build()).addMethod(constructor.build()).build();
            JavaFile.builder((String)packageElement.getQualifiedName().toString(), (TypeSpec)typeSpec).build().writeTo(this.filer);
            return ExtensionResult.nextRound();
        };
    }

    private KoraExtension.KoraExtensionDependencyGenerator entityListRowSetMapper(TypeMirror rowTypeMirror, DbEntity dbEntity) {
        PackageElement packageElement = this.elements.getPackageOf(this.types.asElement(rowTypeMirror));
        TypeName rowType = TypeName.get((TypeMirror)rowTypeMirror);
        Element rowTypeElement = this.types.asElement(rowTypeMirror);
        String mapperName = NameUtils.generatedType((Element)rowTypeElement, (String)("List" + VertxTypes.ROW_SET_MAPPER.simpleName()));
        ParameterizedTypeName returnType = ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{rowType});
        return () -> {
            TypeElement maybeGenerated = this.elements.getTypeElement(packageElement.getQualifiedName() + "." + mapperName);
            if (maybeGenerated != null) {
                List constructors = CommonUtils.findConstructors((TypeElement)maybeGenerated, m -> m.contains((Object)Modifier.PUBLIC));
                if (constructors.size() != 1) {
                    throw new IllegalStateException();
                }
                return ExtensionResult.fromExecutable((ExecutableElement)((ExecutableElement)constructors.get(0)));
            }
            DbEntityReadHelper.ReadEntityCodeBlock readEntity = this.entityHelper.readEntity("_rowValue", dbEntity);
            MethodSpec.Builder constructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC});
            TypeSpec.Builder type = TypeSpec.classBuilder((String)mapperName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addAnnotation(AnnotationSpec.builder(Generated.class).addMember("value", "$S", new Object[]{VertxTypesExtension.class.getCanonicalName()}).build()).addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)VertxTypes.ROW_SET_MAPPER, (TypeName[])new TypeName[]{returnType}));
            readEntity.enrich(type, constructor);
            TypeSpec typeSpec = type.addMethod(MethodSpec.methodBuilder((String)"apply").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).returns((TypeName)returnType).addParameter((TypeName)VertxTypes.ROW_SET, "_rs", new Modifier[0]).addCode(this.readColumnIds(dbEntity, "_rs.columnsNames().indexOf")).addCode("var _result = new $T<$T>(_rs.rowCount());\n", new Object[]{ArrayList.class, rowType}).addCode("for (var _row : _rs) {$>\n", new Object[0]).addCode(readEntity.block()).addCode("_result.add(_rowValue);\n", new Object[0]).addCode("$<\n}\n", new Object[0]).addCode("return _result;\n", new Object[0]).build()).addMethod(constructor.build()).build();
            JavaFile.builder((String)packageElement.getQualifiedName().toString(), (TypeSpec)typeSpec).build().writeTo(this.filer);
            return ExtensionResult.nextRound();
        };
    }

    private CodeBlock readColumnIds(DbEntity entity, String findCode) {
        CodeBlock.Builder b = CodeBlock.builder();
        for (DbEntity.Column entityField : entity.columns()) {
            String fieldName = entityField.variableName();
            b.add("var _$LColumn = $L($S);\n", new Object[]{fieldName, findCode, entityField.columnName()});
        }
        return b.build();
    }
}

