/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.database.annotation.processor;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import ru.tinkoff.kora.annotation.processor.common.AnnotationUtils;
import ru.tinkoff.kora.annotation.processor.common.CommonUtils;
import ru.tinkoff.kora.annotation.processor.common.FieldFactory;
import ru.tinkoff.kora.annotation.processor.common.ProcessingErrorException;
import ru.tinkoff.kora.annotation.processor.common.TagUtils;
import ru.tinkoff.kora.database.annotation.processor.QueryWithParameters;
import ru.tinkoff.kora.database.annotation.processor.entity.DbEntity;
import ru.tinkoff.kora.database.annotation.processor.model.QueryParameter;

public class DbUtils {
    public static final ClassName QUERY_ANNOTATION = ClassName.get((String)"ru.tinkoff.kora.database.common.annotation", (String)"Query", (String[])new String[0]);
    public static final ClassName REPOSITORY_ANNOTATION = ClassName.get((String)"ru.tinkoff.kora.database.common.annotation", (String)"Repository", (String[])new String[0]);
    public static final ClassName BATCH_ANNOTATION = ClassName.get((String)"ru.tinkoff.kora.database.common.annotation", (String)"Batch", (String[])new String[0]);
    public static final ClassName COLUMN_ANNOTATION = ClassName.get((String)"ru.tinkoff.kora.database.common.annotation", (String)"Column", (String[])new String[0]);
    public static final ClassName ID_ANNOTATION = ClassName.get((String)"ru.tinkoff.kora.database.common.annotation", (String)"Id", (String[])new String[0]);
    public static final ClassName TABLE_ANNOTATION = ClassName.get((String)"ru.tinkoff.kora.database.common.annotation", (String)"Table", (String[])new String[0]);
    public static final ClassName EMBEDDED_ANNOTATION = ClassName.get((String)"ru.tinkoff.kora.database.common.annotation", (String)"Embedded", (String[])new String[0]);
    public static final ClassName ENTITY_CONSTRUCTOR_ANNOTATION = ClassName.get((String)"ru.tinkoff.kora.database.common.annotation", (String)"EntityConstructor", (String[])new String[0]);
    public static final ClassName QUERY_CONTEXT = ClassName.get((String)"ru.tinkoff.kora.database.common", (String)"QueryContext", (String[])new String[0]);
    public static final ClassName UPDATE_COUNT = ClassName.get((String)"ru.tinkoff.kora.database.common", (String)"UpdateCount", (String[])new String[0]);

    public static List<ExecutableElement> findQueryMethods(Types types, Elements elements, TypeElement repositoryElement) {
        return DbUtils.collectInterfaces(types, repositoryElement).stream().flatMap(type -> type.getEnclosedElements().stream().filter(e -> e.getKind() == ElementKind.METHOD).filter(e -> !e.getModifiers().contains((Object)Modifier.STATIC)).filter(e -> !e.getModifiers().contains((Object)Modifier.PRIVATE)).filter(e -> e.getModifiers().contains((Object)Modifier.ABSTRACT))).map(ExecutableElement.class::cast).filter(e -> AnnotationUtils.findAnnotation((Elements)elements, (Element)e, (ClassName)QUERY_ANNOTATION) != null).toList();
    }

    public static MethodSpec.Builder queryMethodBuilder(ExecutableElement method, ExecutableType methodType) {
        MethodSpec.Builder b = CommonUtils.overridingKeepAop((ExecutableElement)method, (ExecutableType)methodType);
        if (method.getModifiers().contains((Object)Modifier.PROTECTED)) {
            b.addModifiers(new Modifier[]{Modifier.PROTECTED});
        }
        if (method.getModifiers().contains((Object)Modifier.PUBLIC)) {
            b.addModifiers(new Modifier[]{Modifier.PUBLIC});
        }
        for (TypeMirror typeMirror : method.getThrownTypes()) {
            b.addException(TypeName.get((TypeMirror)typeMirror));
        }
        return b;
    }

    public static CodeBlock getTag(TypeElement repositoryElement) {
        AnnotationMirror repositoryAnnotation = AnnotationUtils.findAnnotation((Element)repositoryElement, (ClassName)REPOSITORY_ANNOTATION);
        AnnotationMirror executorTagAnnotation = (AnnotationMirror)AnnotationUtils.parseAnnotationValueWithoutDefault((AnnotationMirror)repositoryAnnotation, (String)"executorTag");
        if (executorTagAnnotation == null) {
            return null;
        }
        List tagValue = (List)AnnotationUtils.parseAnnotationValueWithoutDefault((AnnotationMirror)executorTagAnnotation, (String)"value");
        return TagUtils.writeTagAnnotationValue((List)tagValue);
    }

    static Set<TypeElement> collectInterfaces(Types types, TypeElement typeElement) {
        HashSet<TypeElement> result = new HashSet<TypeElement>();
        DbUtils.collectInterfaces(types, result, typeElement);
        return result;
    }

    private static void collectInterfaces(Types types, Set<TypeElement> collectedElements, TypeElement typeElement) {
        if (collectedElements.add(typeElement)) {
            if (typeElement.asType().getKind() == TypeKind.ERROR) {
                throw new ProcessingErrorException("Element is error: %s".formatted(typeElement.toString()), (Element)typeElement);
            }
            for (TypeMirror typeMirror : typeElement.getInterfaces()) {
                TypeElement interfaceElement = (TypeElement)types.asElement(typeMirror);
                DbUtils.collectInterfaces(types, collectedElements, interfaceElement);
            }
        }
    }

    public static String operationName(ExecutableElement method) {
        return method.getEnclosingElement().getSimpleName().toString() + "." + method.getSimpleName().toString();
    }

    public static void addMappers(FieldFactory factory, List<Mapper> mappers) {
        for (Mapper mapper : mappers) {
            if (mapper.typeMirror == null) {
                factory.add(mapper.typeName(), mapper.tag());
                continue;
            }
            String name = factory.add(mapper.typeMirror(), mapper.tag());
            if (mapper.wrapper() == null) continue;
            factory.add(mapper.typeName(), mapper.wrapper().apply(CodeBlock.of((String)"$N", (Object[])new Object[]{name})));
        }
    }

    public static String addMapper(FieldFactory factory, Mapper mapper) {
        if (mapper.typeMirror == null) {
            return factory.add(mapper.typeName(), mapper.tag());
        }
        String name = factory.add(mapper.typeMirror(), mapper.tag());
        if (mapper.wrapper() != null) {
            return factory.add(mapper.typeName(), mapper.wrapper().apply(CodeBlock.of((String)"$N", (Object[])new Object[]{name})));
        }
        return name;
    }

    public static List<Mapper> parseParameterMappers(List<QueryParameter> parameters, QueryWithParameters query, Predicate<TypeName> nativeTypePredicate, ClassName parameterColumnMapper) {
        ArrayList<Mapper> mappers = new ArrayList<Mapper>();
        for (QueryParameter parameter : parameters) {
            if (parameter instanceof QueryParameter.ConnectionParameter) continue;
            if (parameter instanceof QueryParameter.BatchParameter) {
                QueryParameter.BatchParameter bp = (QueryParameter.BatchParameter)parameter;
                parameter = bp.parameter();
            }
            TypeMirror parameterType = parameter.type();
            CommonUtils.MappersData mappings = CommonUtils.parseMapping((Element)parameter.variable());
            CommonUtils.MappingData mapping = mappings.getMapping(parameterColumnMapper);
            if (mapping != null) {
                ParameterizedTypeName mapperType = ParameterizedTypeName.get((ClassName)parameterColumnMapper, (TypeName[])new TypeName[]{TypeName.get((TypeMirror)parameterType)});
                mappers.add(new Mapper(mapping.mapperClass(), (TypeName)mapperType, mapping.mapperTags(), c -> c));
                continue;
            }
            if (parameter instanceof QueryParameter.SimpleParameter) {
                QueryParameter.SimpleParameter sp = (QueryParameter.SimpleParameter)parameter;
                if (nativeTypePredicate.test(TypeName.get((TypeMirror)parameter.type()))) continue;
                ParameterizedTypeName mapperType = ParameterizedTypeName.get((ClassName)parameterColumnMapper, (TypeName[])new TypeName[]{TypeName.get((TypeMirror)parameterType)});
                mappers.add(new Mapper((TypeName)mapperType, Set.of()));
                continue;
            }
            if (!(parameter instanceof QueryParameter.EntityParameter)) continue;
            QueryParameter.EntityParameter ep = (QueryParameter.EntityParameter)parameter;
            for (DbEntity.Column entityField : ep.entity().columns()) {
                QueryWithParameters.QueryParameter queryParam = query.find(entityField.queryParameterName(parameter.name()));
                if (queryParam == null || queryParam.sqlIndexes().isEmpty()) continue;
                ParameterizedTypeName mapperType = ParameterizedTypeName.get((ClassName)parameterColumnMapper, (TypeName[])new TypeName[]{TypeName.get((TypeMirror)entityField.type()).box()});
                TypeName entityTypeName = TypeName.get((TypeMirror)entityField.type());
                CommonUtils.MappersData fieldMappings = CommonUtils.parseMapping((Element)entityField.element());
                CommonUtils.MappingData fieldMapping = fieldMappings.getMapping(parameterColumnMapper);
                if (fieldMapping != null) {
                    mappers.add(new Mapper(fieldMapping.mapperClass(), (TypeName)mapperType, fieldMapping.mapperTags()));
                    continue;
                }
                if (nativeTypePredicate.test(entityTypeName)) continue;
                mappers.add(new Mapper((TypeName)mapperType, Set.of()));
            }
            QueryWithParameters.QueryParameter queryParam = query.find(parameter.name());
            if (queryParam == null || queryParam.sqlIndexes().isEmpty()) continue;
            ParameterizedTypeName mapperType = ParameterizedTypeName.get((ClassName)parameterColumnMapper, (TypeName[])new TypeName[]{TypeName.get((TypeMirror)ep.type()).box()});
            CommonUtils.MappersData fieldMappings = CommonUtils.parseMapping((Element)ep.entity().typeElement());
            CommonUtils.MappingData fieldMapping = fieldMappings.getMapping(parameterColumnMapper);
            if (fieldMapping != null) {
                mappers.add(new Mapper(fieldMapping.mapperClass(), (TypeName)mapperType, fieldMapping.mapperTags()));
                continue;
            }
            mappers.add(new Mapper((TypeName)mapperType, Set.of()));
        }
        return mappers;
    }

    public record Mapper(@Nullable TypeMirror typeMirror, TypeName typeName, Set<String> tag, @Nullable Function<CodeBlock, CodeBlock> wrapper) {
        public Mapper(TypeName typeName, Set<String> tag) {
            this(null, typeName, tag, null);
        }

        public Mapper(TypeMirror typeMirror, TypeName typeName, Set<String> tag) {
            this(typeMirror, typeName, tag, null);
        }
    }
}

