/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.database.annotation.processor;

import jakarta.annotation.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.Types;
import javax.tools.StandardLocation;
import ru.tinkoff.kora.annotation.processor.common.ProcessingErrorException;
import ru.tinkoff.kora.database.annotation.processor.QueryMacrosParser;
import ru.tinkoff.kora.database.annotation.processor.entity.DbEntity;
import ru.tinkoff.kora.database.annotation.processor.model.QueryParameter;

public record QueryWithParameters(String rawQuery, List<QueryParameter> parameters) {
    @Nullable
    public QueryParameter find(String name) {
        for (QueryParameter parameter : this.parameters) {
            if (!parameter.sqlParameterName.equals(name)) continue;
            return parameter;
        }
        return null;
    }

    @Nullable
    public QueryParameter find(int methodIndex) {
        for (QueryParameter parameter : this.parameters) {
            if (parameter.methodIndex != methodIndex) continue;
            return parameter;
        }
        return null;
    }

    public static QueryWithParameters parse(Filer filer, Types types, String rawSql, List<ru.tinkoff.kora.database.annotation.processor.model.QueryParameter> parameters, DeclaredType repositoryType, ExecutableElement method) {
        if (rawSql.startsWith("classpath:/")) {
            String resourceName;
            String packageName;
            String path = rawSql.substring(11);
            int i = path.lastIndexOf("/");
            if (i > 0) {
                packageName = path.substring(0, i).replace('/', '.');
                resourceName = path.substring(i + 1);
            } else {
                packageName = "";
                resourceName = path;
            }
            try (InputStream is = filer.getResource(StandardLocation.SOURCE_PATH, packageName, resourceName).openInputStream();){
                rawSql = new String(is.readAllBytes(), StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                try (InputStream is2 = filer.getResource(StandardLocation.CLASS_PATH, packageName, resourceName).openInputStream();){
                    rawSql = new String(is2.readAllBytes(), StandardCharsets.UTF_8);
                }
                catch (IOException e1) {
                    e.addSuppressed(e1);
                    throw new RuntimeException(e);
                }
            }
        }
        String sql = new QueryMacrosParser(types).parse(rawSql, repositoryType, method);
        ArrayList<QueryParameter> params = new ArrayList();
        for (int i = 0; i < parameters.size(); ++i) {
            ru.tinkoff.kora.database.annotation.processor.model.QueryParameter parameter = parameters.get(i);
            String parameterName = parameter.name();
            if (parameter instanceof QueryParameter.ConnectionParameter) continue;
            int size = params.size();
            if (parameter instanceof QueryParameter.BatchParameter) {
                QueryParameter.BatchParameter batchParameter = (QueryParameter.BatchParameter)parameter;
                parameter = batchParameter.parameter();
            }
            if (parameter instanceof QueryParameter.SimpleParameter) {
                QueryParameter.SimpleParameter simpleParameter = (QueryParameter.SimpleParameter)parameter;
                QueryWithParameters.parseSimpleParameter(sql, i, parameterName).ifPresent(params::add);
            }
            if (parameter instanceof QueryParameter.EntityParameter) {
                QueryParameter.EntityParameter entityParameter = (QueryParameter.EntityParameter)parameter;
                for (DbEntity.Column field : entityParameter.entity().columns()) {
                    QueryWithParameters.parseSimpleParameter(sql, i, field.queryParameterName(parameterName)).ifPresent(params::add);
                }
                QueryWithParameters.parseEntityDirectParameter(sql, i, parameterName).ifPresent(params::add);
            }
            if (params.size() != size) continue;
            throw new ProcessingErrorException("Parameter usage wasn't found in query: " + parameterName, (Element)parameter.variable());
        }
        List paramsNumbers = params.stream().map(QueryParameter::sqlIndexes).flatMap(Collection::stream).sorted().toList();
        params = params.stream().map(p -> new QueryParameter(p.sqlParameterName(), p.methodIndex(), p.sqlIndexes().stream().map(paramsNumbers::indexOf).toList())).toList();
        return new QueryWithParameters(sql, params);
    }

    private static Optional<QueryParameter> parseSimpleParameter(String rawSql, int methodParameterNumber, String sqlParameterName) {
        int index = -1;
        ArrayList<Integer> result = new ArrayList<Integer>();
        while ((index = rawSql.indexOf(":" + sqlParameterName, index + 1)) >= 0) {
            char charAfter;
            int indexAfter = index + sqlParameterName.length() + 1;
            if (rawSql.length() >= indexAfter + 1 && (Character.isAlphabetic(charAfter = rawSql.charAt(indexAfter)) || charAfter == '_' || charAfter == '$' || Character.isDigit(charAfter))) continue;
            result.add(index);
        }
        return result.isEmpty() ? Optional.empty() : Optional.of(new QueryParameter(sqlParameterName, methodParameterNumber, result));
    }

    private static Optional<QueryParameter> parseEntityDirectParameter(String rawSql, int methodParameterNumber, String sqlParameterName) {
        int index = -1;
        ArrayList<Integer> result = new ArrayList<Integer>();
        while ((index = rawSql.indexOf(":" + sqlParameterName, index + 1)) >= 0) {
            char charAfter;
            int indexAfter = index + sqlParameterName.length() + 1;
            if (rawSql.length() >= indexAfter + 1 && ('.' == (charAfter = rawSql.charAt(indexAfter)) || Character.isAlphabetic(charAfter) || charAfter == '_' || charAfter == '$' || Character.isDigit(charAfter))) continue;
            result.add(index);
        }
        return result.isEmpty() ? Optional.empty() : Optional.of(new QueryParameter(sqlParameterName, methodParameterNumber, result));
    }

    public record QueryParameter(String sqlParameterName, int methodIndex, List<Integer> sqlIndexes) {
    }
}

