/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.database.annotation.processor;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeSpec;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;
import ru.tinkoff.kora.annotation.processor.common.AbstractKoraProcessor;
import ru.tinkoff.kora.annotation.processor.common.CommonUtils;
import ru.tinkoff.kora.annotation.processor.common.LogUtils;
import ru.tinkoff.kora.annotation.processor.common.ProcessingError;
import ru.tinkoff.kora.annotation.processor.common.ProcessingErrorException;
import ru.tinkoff.kora.database.annotation.processor.DbUtils;
import ru.tinkoff.kora.database.annotation.processor.RepositoryBuilder;

public class RepositoryAnnotationProcessor
extends AbstractKoraProcessor {
    private static final Logger log = LoggerFactory.getLogger(RepositoryAnnotationProcessor.class);
    private RepositoryBuilder repositoryBuilder;

    public Set<ClassName> getSupportedAnnotationClassNames() {
        return Set.of(DbUtils.REPOSITORY_ANNOTATION);
    }

    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.repositoryBuilder = new RepositoryBuilder(processingEnv);
    }

    public void process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv, Map<ClassName, List<AbstractKoraProcessor.AnnotatedElement>> annotatedElements) {
        List elements = annotatedElements.getOrDefault(DbUtils.REPOSITORY_ANNOTATION, List.of());
        if (elements.isEmpty()) {
            return;
        }
        LogUtils.logAnnotatedElementsFull((Logger)log, (Level)Level.DEBUG, (String)"Generating Repository for", elements);
        for (AbstractKoraProcessor.AnnotatedElement element : elements) {
            try {
                this.processClass(element.element());
            }
            catch (ProcessingErrorException e) {
                e.printError(this.processingEnv);
            }
        }
    }

    private void processClass(Element classElement) {
        if (classElement.getKind() != ElementKind.INTERFACE && classElement.getKind() == ElementKind.CLASS && !classElement.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            throw new ProcessingErrorException(List.of(new ProcessingError("@Repository is only applicable to interfaces and abstract classes", classElement)));
        }
        TypeSpec typeSpec = this.repositoryBuilder.build((TypeElement)classElement);
        if (typeSpec == null) {
            return;
        }
        PackageElement packageElement = this.processingEnv.getElementUtils().getPackageOf(classElement);
        String packageName = packageElement.getQualifiedName().toString();
        JavaFile javaFile = JavaFile.builder((String)packageName, (TypeSpec)typeSpec).build();
        CommonUtils.safeWriteTo((ProcessingEnvironment)this.processingEnv, (JavaFile)javaFile);
    }
}

