/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.database.annotation.processor;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import ru.tinkoff.kora.annotation.processor.common.AnnotationUtils;
import ru.tinkoff.kora.annotation.processor.common.CommonUtils;
import ru.tinkoff.kora.annotation.processor.common.NameUtils;
import ru.tinkoff.kora.annotation.processor.common.ProcessingErrorException;
import ru.tinkoff.kora.annotation.processor.common.TagUtils;
import ru.tinkoff.kora.annotation.processor.common.TypeUtils;
import ru.tinkoff.kora.database.annotation.processor.RepositoryAnnotationProcessor;
import ru.tinkoff.kora.database.annotation.processor.RepositoryGenerator;
import ru.tinkoff.kora.database.annotation.processor.cassandra.CassandraRepositoryGenerator;
import ru.tinkoff.kora.database.annotation.processor.jdbc.JdbcRepositoryGenerator;
import ru.tinkoff.kora.database.annotation.processor.r2dbc.R2dbcRepositoryGenerator;
import ru.tinkoff.kora.database.annotation.processor.vertx.VertxRepositoryGenerator;

public class RepositoryBuilder {
    private final List<RepositoryGenerator> queryMethodGenerators;

    public RepositoryBuilder(ProcessingEnvironment processingEnv) {
        this.queryMethodGenerators = List.of(new JdbcRepositoryGenerator(processingEnv), new VertxRepositoryGenerator(processingEnv), new CassandraRepositoryGenerator(processingEnv), new R2dbcRepositoryGenerator(processingEnv));
    }

    @Nullable
    public TypeSpec build(TypeElement repositoryElement) throws ProcessingErrorException {
        String name = NameUtils.generatedType((Element)repositoryElement, (String)"Impl");
        TypeSpec.Builder builder = CommonUtils.extendsKeepAop((TypeElement)repositoryElement, (String)name).addAnnotation(AnnotationUtils.generated(RepositoryAnnotationProcessor.class));
        Set tags = TagUtils.parseTagValue((AnnotatedConstruct)repositoryElement);
        if (!tags.isEmpty()) {
            builder.addAnnotation(TagUtils.makeAnnotationSpec((Set)tags));
        }
        MethodSpec.Builder constructorBuilder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC});
        if (repositoryElement.getKind().isClass()) {
            this.enrichConstructorFromParentClass(constructorBuilder, repositoryElement);
        }
        DeclaredType repositoryType = (DeclaredType)repositoryElement.asType();
        for (RepositoryGenerator availableGenerator : this.queryMethodGenerators) {
            ClassName repositoryInterface = availableGenerator.repositoryInterface();
            DeclaredType repositoryInterfaceType = TypeUtils.findSupertype((DeclaredType)repositoryType, (ClassName)repositoryInterface);
            if (repositoryInterfaceType == null) continue;
            return availableGenerator.generate(repositoryElement, builder, constructorBuilder);
        }
        throw new ProcessingErrorException("Element doesn't extend any of known repository interfaces", (Element)repositoryElement);
    }

    private void enrichConstructorFromParentClass(MethodSpec.Builder constructorBuilder, TypeElement repositoryElement) {
        constructorBuilder.addCode("super(", new Object[0]);
        List constructors = CommonUtils.findConstructors((TypeElement)repositoryElement, m -> !m.contains((Object)Modifier.PRIVATE));
        if (constructors.isEmpty()) {
            constructorBuilder.addCode(");\n", new Object[0]);
            return;
        }
        if (constructors.size() > 1) {
            throw new ProcessingErrorException("Abstract repository class has more than one public constructor", (Element)repositoryElement);
        }
        ExecutableElement constructor = (ExecutableElement)constructors.get(0);
        List<? extends VariableElement> parameters = constructor.getParameters();
        for (int i = 0; i < parameters.size(); ++i) {
            VariableElement parameter = parameters.get(i);
            ParameterSpec.Builder constructorParameter = ParameterSpec.builder((TypeName)TypeName.get((TypeMirror)parameter.asType()), (String)parameter.getSimpleName().toString(), (Modifier[])new Modifier[0]);
            for (AnnotationMirror annotationMirror : parameter.getAnnotationMirrors()) {
                constructorParameter.addAnnotation(AnnotationSpec.get((AnnotationMirror)annotationMirror));
            }
            constructorBuilder.addParameter(constructorParameter.build());
            constructorBuilder.addCode("$L", new Object[]{parameter});
            if (i >= parameters.size() - 1) continue;
            constructorBuilder.addCode(", ", new Object[0]);
        }
        constructorBuilder.addCode(");\n", new Object[0]);
    }
}

