/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.database.annotation.processor.cassandra;

import com.squareup.javapoet.ClassName;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import ru.tinkoff.kora.annotation.processor.common.AbstractKoraProcessor;
import ru.tinkoff.kora.annotation.processor.common.ProcessingErrorException;
import ru.tinkoff.kora.database.annotation.processor.cassandra.CassandraEntityGenerator;
import ru.tinkoff.kora.database.annotation.processor.cassandra.CassandraTypes;
import ru.tinkoff.kora.database.annotation.processor.entity.DbEntity;

public class CassandraEntityAnnotationProcessor
extends AbstractKoraProcessor {
    private CassandraEntityGenerator generator;

    public Set<ClassName> getSupportedAnnotationClassNames() {
        return Set.of(CassandraTypes.CASSANDRA_ENTITY);
    }

    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.generator = new CassandraEntityGenerator(processingEnv.getTypeUtils(), processingEnv.getElementUtils(), processingEnv.getFiler());
    }

    public void process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv, Map<ClassName, List<AbstractKoraProcessor.AnnotatedElement>> annotatedElements) {
        for (List<AbstractKoraProcessor.AnnotatedElement> annotatedList : annotatedElements.values()) {
            for (AbstractKoraProcessor.AnnotatedElement annotated : annotatedList) {
                Element element = annotated.element();
                if (element.getKind() != ElementKind.RECORD && element.getKind() != ElementKind.CLASS) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "@EntityJdbc only works on records and java bean like classes");
                    continue;
                }
                try {
                    DbEntity entity = DbEntity.parseEntity(this.types, element.asType());
                    if (entity == null) {
                        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Can't parse entity from type: " + String.valueOf(element), element);
                        continue;
                    }
                    this.generator.generateRowMapper(entity);
                    this.generator.generateResultSetMapper(entity);
                    this.generator.generateListResultSetMapper(entity);
                }
                catch (ProcessingErrorException e) {
                    e.printError(this.processingEnv);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

